/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#include "skgdataengine.h"


#include <Plasma/DataContainer>

#include "skgtraces.h"
#include "skgservices.h"
#include <skgmainpanel.h>
#include <skgdocumentbank.h>


SKGDataEngine::SKGDataEngine(QObject* parent, const QVariantList& args): DataEngine(parent, args)
{

    // Get the document behind the current document
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    if(panel) setDocument(qobject_cast<SKGDocumentBank*> (panel->getDocument()));

    init();
}


SKGDataEngine::~SKGDataEngine()
{

}

QStringList SKGDataEngine::sources() const
{
    QStringList sources;

    static const QString accounts = "Accounts";
    static const QString incomes_expenditures = "Incomes & Expenditures";

    sources << accounts << incomes_expenditures;
    return sources;
}


bool SKGDataEngine::updateSourceEvent(const QString& source)
{
    if(source == "Accounts") {
        return getAccountData();
    } else if(source == "Incomes & Expenditures") {
        return getIncomeExpenditureData();
    }
    return false;
}

bool SKGDataEngine::sourceRequestEvent(const QString& source)
{
    return updateSourceEvent(source);
}


bool SKGDataEngine::getAccountData()
{

    SKGStringListList sqlResult;

    // Fetch results in the database
    SKGError err = document->executeSelectSqliteOrder("SELECT t_name, t_typenls, f_CURRENTAMOUNT, t_close FROM v_account_display ORDER BY t_type,t_name", sqlResult);


    // We may receive an error from querying the SQLite database
    if(err.isFailed()) {
        return false;
    }


    // Put the data in the dataengine
    for(int i = 1 ; i < sqlResult.count() ; i++) {
        QStringList values;
        values << sqlResult.at(i).at(1); // Account type
        values << sqlResult.at(i).at(2); // Amount of money
        values << sqlResult.at(i).at(3); // Account closed

        setData("Accounts", sqlResult.at(i).at(0), values);
    }
    return true;

}


bool SKGDataEngine::getIncomeExpenditureData()
{

    QDate date = QDate::currentDate();

    QString month = date.toString("yyyy-MM");
    QString previousmonth = date.addMonths(-1).toString("yyyy-MM");

    SKGStringListList data;
    SKGError err = document->executeSelectSqliteOrder("SELECT TOTAL(f_CURRENTAMOUNT), d_DATEMONTH FROM v_operation_display WHERE d_DATEMONTH IN ('" + month + "', '" + previousmonth + "') AND i_group_id=0 group by d_DATEMONTH, t_TYPEEXPENSE", data);


    // We may receive an error from querying the SQLite database
    if(err.isFailed()) {
        return false;
    }

    // Put the data in the dataengine
    for(int i = 0 ; i < data.count() ; i++) {
        setData("Incomes & Expenses", data.at(i).at(0), data.at(i).at(1));
    }
    return true;
}

void SKGDataEngine::setDocument(SKGDocument* iDocument)
{
    document = iDocument;
}

SKGDocument* SKGDataEngine::getDocument()
{
    return document;
}

// This does the magic that allows Plasma to load
// this plugin.  The first argument must match
// the X-Plasma-EngineName in the .desktop file.

K_EXPORT_PLASMA_DATAENGINE(dataengine_skrooge, SKGDataEngine)

// this is needed since skgdataengine is a QObject
#include "skgdataengine.moc"
