/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information.
 *
 * @author Siddharth SHARMA
 *
 */

#include "skgdashboard2pluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"
#include "skginterfaceplugin.h"
#include "skgdataengine.h"

#include <KAction>
#include <KMessageBox>
#include <Plasma/PluginLoader>
#include <Plasma/DataEngine>
#include <KService>
#include <KDebug>
#include <KStandardAction>
#include <KActionCollection>
#include <KMenu>

#include "skroogoidloader.h"

SKGDashboard2PluginWidget::SKGDashboard2PluginWidget(SKGDocument* iDocument)
    : SKGTabPage(iDocument), m_menu(NULL), m_addMenu(NULL), dialog(0)
{
    SKGTRACEIN(1, "SKGDashboard2PluginWidget::SKGDashboard2PluginWidget");
    if(!iDocument) return;
    ui.setupUi(this);

    // Create a context menu for adding widgets
    setContextMenuPolicy(Qt::CustomContextMenu);
    m_menu = new KMenu(this);
    connect(this , SIGNAL(customContextMenuRequested(const QPoint &)), this, SLOT(showHeaderMenu(const QPoint&)));

    // Create an action opening the list of available widgets
    QAction* act = m_menu->addAction("add widgets");
    if(act) {
        act->setIcon(KIcon("list-add"));
        connect(act, SIGNAL(triggered(bool)), this, SLOT(onAddSkroogoid()));
    }

    // Load the plasma kpart
    KService::Ptr service = KService::serviceByDesktopPath("plasma-kpart.desktop");
    if(service) {
        m_plasmadashboard = service->createInstance<KParts::ReadOnlyPart> (0);

        if(m_plasmadashboard) {
            ui.verticalLayout_6->addWidget(m_plasmadashboard->widget());

        } else {
            KMessageBox::error(this, i18n("Could not instantiate our Part!"));
        }
// Plasma::PluginLoader* loader = new Plasma::PluginLoader();
        //QVariantList args = QVariantList() << qVariantFromValue(loader);

        // Load the dataengine
        /*   QString dataengineName("skgdataengine");
           Plasma::DataEngine* dataengine = loader->loadDataEngine(dataengineName);
        */
//         KMessageBox::information(this, iDocument->getFileExtension());
        /*
                if (!dataengine) {
                    KMessageBox::error(this, dataengineName + " not found !");
                }

                dataengine->connectAllSources(this, 10000);

                // Load the applets
                KPluginInfo::List appletList = loader->listAppletInfo("", "skrooge");
                for (int i = 0 ; i < appletList.count(); i++) {
                    KPluginInfo applet = appletList.at(i);
                    loader->loadApplet(applet.name());
                }

        */
    }
}

void SKGDashboard2PluginWidget::showHeaderMenu(const QPoint& pos)
{
    //Display menu
    if(m_menu) m_menu->popup(mapToGlobal(pos));

}

void SKGDashboard2PluginWidget::onAddSkroogoid()
{
    if(!dialog) {
        dialog = new SkroogoidLoader();
        connect(dialog, SIGNAL(addApplet(QString)), m_plasmadashboard, SLOT(addApplet(QString)));
        dialog->setButtons(KDialog::Ok | KDialog::Cancel);
        dialog->show();
    } else {
        dialog->show();
    }
}


SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget()
{
    m_menu = NULL;
}


#include "skgdashboard2pluginwidget.moc"


