/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Applet for generic widget.
 *
 * @author Siddharth SHARMA
 */
#include "skgdashboard2applet.h"
#include "skgtraces.h"
#include "skgwidget.h"

#include <QGraphicsProxyWidget>
#include <QPainter>
#include <QtGui/QGraphicsGridLayout>
#include <QGroupBox>

SKGDashboard2Applet::SKGDashboard2Applet(QObject* parent, const QVariantList& args)
    : Plasma::Applet(parent, args), m_widget(NULL), m_gwidget(NULL)
{
    SKGTRACEIN(1, "SKGDashboard2Applet::SKGDashboard2Applet");
    m_layout = new QGraphicsLinearLayout(Qt::Vertical, this);
    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(100, 100);
}

SKGDashboard2Applet::~SKGDashboard2Applet()
{
}

void SKGDashboard2Applet::setSKGWidget(SKGWidget* iWidget)
{
    if(!iWidget) return;
    m_widget = iWidget;
    QObjectList listChildren = iWidget->children();
    int nbc = listChildren.count();
    for(int i = 0; i < nbc; ++i) {
        QGroupBox* box = qobject_cast<QGroupBox*>(listChildren.at(i));
        if(box) box->setFlat(true);
    }

    QGraphicsWidget* grWidget = new QGraphicsWidget();
    QGraphicsGridLayout* grLayout = new  QGraphicsGridLayout(grWidget);

    iWidget->setState("");
    iWidget->setAutoFillBackground(false);
    iWidget->setAttribute(Qt::WA_TranslucentBackground, true);

    QGraphicsProxyWidget* pWidget = new QGraphicsProxyWidget();
    pWidget->setWidget(iWidget);
    pWidget->show();

    grLayout->addItem(pWidget, 0, 0, 1, 1);
    setGraphicsWidget(grWidget);
}

void SKGDashboard2Applet::setGraphicsWidget(QGraphicsWidget* iWidget)
{
    if(!iWidget) return;
    m_gwidget = iWidget;
    m_layout->addItem(iWidget);

    QSizeF size = iWidget->preferredSize();
    size.setHeight(size.height() + 40); //TODO
    size.setWidth(size.width() + 40); //TODO

    setMinimumSize(size);
}

SKGWidget* SKGDashboard2Applet::getSKGWidget() const
{
    return m_widget;
}

QGraphicsWidget *SKGDashboard2Applet::graphicsWidget() const
{
    return m_gwidget;
}

#include "skgdashboard2applet.moc"


