/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file defines the main of skrooge.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skguniqueapplication.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <KDE/KLocale>

/**
 * Description of the application
 */
static const char description[] = I18N_NOOP("Personal finance management tool for KDE4, with the aim of being highly intuitive, while providing powerful functions such as reporting (including graphics), persistent Undo/Redo, encryption, and much more...");

/**
 * To compute the version
 */
#define VER1_(x) #x
/**
 * To compute the version
 */
#define VER_(x) VER1_(x)
/**
 * To compute the version
 */
#define VER VER_(SKGVERSION)


/**
 * The main of the application
 * @param argc number of arguments
 * @param argv arguments
 * @return return code
 */
int main(int argc, char **argv)
{
    KAboutData about("skrooge",
                     0,
                     ki18nc("The name of the application", "Skrooge"),
                     VER,
                     ki18nc("The description of the application", description),
                     KAboutData::License_GPL_V3,
                     ki18nc("Fullname", "(c) 2007-2010 Stephane MANKOWSKI & Guillaume DE BURE"),
                     KLocalizedString(),
                     "http://skrooge.org");

    about.addAuthor( ki18nc("Fullname", "Stephane MANKOWSKI"), ki18nc("A job description", "Architect & Developer"), "stephane@mankowski.fr" );
    about.addAuthor( ki18nc("Fullname", "Guillaume DE BURE"), ki18nc("A job description", "Developer"), "guillaume.debure@gmail.com" );
    about.setOtherText( ki18nc("The description of the application", "The application name is inspired by Charles Dicken's tale <i>A Christmas Carol</i>, where the main character, Ebenezer Scrooge, a grumpy old narrow man, gets visited by three ghosts who change the way he sees the world, in a good way."));

    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+[URL]", ki18nc("Application argument", "Document to open" ));
    KCmdLineArgs::addCmdLineOptions(options);

    int rc=0;
    if (!SKGUniqueApplication::start()) {
        fprintf(stderr, "Skrooge is already running!\n");
    } else {
        //Creating a main panel on a bank document
        SKGDocumentBank doc;
        SKGUniqueApplication kApp(&doc);

        rc=kApp.exec(); // krazy:exclude=crashy
    }
    SKGTraces::dumpProfilingStatistics();
    return rc;
}
