/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A KTabWidget with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtabwidget.h"
#include "skgtabpage.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include <kicon.h>
#include <klocale.h>
#include <ktabbar.h>

#include <QHBoxLayout>
#include <QPushButton>
#include <QTabBar>
#include <QTimer>
#include <QStringList>

SKGTabWidget::SKGTabWidget(QWidget *parent)
                : KTabWidget(parent)
{
        timerSave = new QTimer( this );
        timerSave->setSingleShot( true );
        connect( timerSave, SIGNAL( timeout() ), this, SLOT( onRefreshSaveIcon() ), Qt::QueuedConnection );
        connect( tabBar(), SIGNAL(moveTab(int, int)), this, SLOT(onMoveTab(int, int)));
        connect ( (SKGMainPanel*) parent, SIGNAL ( currentPageChanged ( ) ), this, SLOT ( onCurrentChanged() ) );

        // Use new KDE for moving tabs.
        KTabBar* tabbar = qobject_cast< KTabBar* >(tabBar());
        tabbar->setMovable(true);

        timerSave->start( 1000 );
}

SKGTabWidget::~SKGTabWidget()
{
        timerSave=NULL;
}

void SKGTabWidget::onCurrentChanged()
{
        if (currentWidget() && !mTabIndexSaveButton.keys().contains(currentWidget())) {
                //Build widgets
                QPushButton* kSave = new QPushButton(this);
                kSave->setIcon(KIcon("document-save"));
                kSave->setToolTip( i18nc("Verb", "Save this tab" ) );
                kSave->setFlat( true );
                kSave->setMaximumSize(QSize(16, 16));
                kSave->show();

                connect(kSave, SIGNAL(clicked()), this, SLOT(onSaveRequested()));
                tabBar()->setTabButton(currentIndex(), QTabBar::LeftSide, kSave);

                mTabIndexSaveButton.insert(currentWidget(), kSave);
        }

        //Rebuild indexes
        QMap<QWidget*, QPushButton*> TabIndexSaveButton2;

        int nb=count();
        for (int i=0; i<nb; ++i) {
                QWidget* w=widget(i);
                QPushButton* save=(QPushButton*) mTabIndexSaveButton[w];
                if (w && save) {
                        save->setVisible(false);

                        QPushButton* s=mTabIndexSaveButton.value(w);
                        if (s!=NULL) TabIndexSaveButton2[w]=s;
                }
        }

        mTabIndexSaveButton=TabIndexSaveButton2;

        onRefreshSaveIcon();
}

void SKGTabWidget::removeTab( int index )
{
	mTabIndexSaveButton.clear();
	KTabWidget::removeTab(index);
}


void SKGTabWidget::onMoveTab(int oldPos, int newPos)
{
        Q_UNUSED(oldPos);
        Q_UNUSED(newPos);
        mTabIndexSaveButton.clear();
        onCurrentChanged();
}

void SKGTabWidget::onSaveRequested()
{
        SKGTabPage *page = dynamic_cast<SKGTabPage*>(currentWidget());
        if (page) {
                page->overwrite(false);
                onRefreshSaveIcon();
        }
}

void SKGTabWidget::onRefreshSaveIcon()
{
        SKGTabPage *page = dynamic_cast<SKGTabPage*>(currentWidget());
        if (page) {
                QPushButton* save=(QPushButton*) mTabIndexSaveButton[page];
                if (save) {
                        if (page->isOverwriteNeeded()) {
                                save->show();
                                if (page->getBookmarkID().isEmpty()) {
                                        save->setIcon(KIcon("document-save"));
                                } else {
                                        QStringList overlay;
                                        overlay.push_back("rating");
                                        save->setIcon(KIcon("document-save", NULL, overlay));
                                }
                        } else save->hide();
                }

                if(timerSave) timerSave->start( 1000 );
        }
}
#include "skgtabwidget.moc"

