/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgservices.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        //============================================================================
        {
                //Test bank document
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGUnitObject unit_euro(&document1);
                SKGUnitValueObject unit_euro_val1;
                QDate d1=QDate::currentDate().addMonths(-6);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T1", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(d1), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                        //Creation operation
                        SKGOperationObject op;
                        SKGTESTERROR("ACCOUNT:addOperation",account.addOperation(op), true);
                        SKGTESTERROR("OPE:setMode",op.setMode("cheque"), true);
                        SKGTESTERROR("OPE:setPayee",op.setPayee("Doctor"), true);
                        SKGTESTERROR("OPE:setDate",op.setDate(d1), true);
                        SKGTESTERROR("OPE:setUnit",op.setUnit(unit_euro), true);
                        SKGTESTERROR("OPE:save", op.save(), true);

                        SKGSubOperationObject subop1;
                        SKGTESTERROR("OPE:addSubOperation",op.addSubOperation(subop1), true);
                        SKGTESTERROR("SUBOPE:setQuantity",subop1.setQuantity(21), true);
                        SKGTESTERROR("SUBOPE:save", subop1.save(), true);
                        SKGSubOperationObject subop2;
                        SKGTESTERROR("OPE:addSubOperation",op.addSubOperation(subop2), true);
                        SKGTESTERROR("SUBOPE:setQuantity",subop2.setQuantity(1), true);
                        SKGTESTERROR("SUBOPE:save", subop2.save(), true);

                        SKGTrackerObject tracker(&document1);
                        SKGTrackerObject trackerCopy(tracker);
                        SKGTrackerObject trackerCopy2((SKGObjectBase) tracker);
                        SKGTESTERROR("REF:setName",tracker.setName("tracker"), true);
                        SKGTESTERROR("REF:setComment",tracker.setComment("comment"), true);
                        SKGTESTERROR("REF:save", tracker.save(), true);
                        SKGTEST("REF:getName", tracker.getName(), "tracker");
                        SKGTEST("REF:getComment", tracker.getComment(), "comment");

                        SKGTEST("REF:isClosed", tracker.isClosed(), false);
                        SKGTESTERROR("OPE:setClosed",tracker.setClosed(true), true);
                        SKGTEST("REF:isClosed", tracker.isClosed(), true);
                        SKGTESTERROR("OPE:setClosed",tracker.setClosed(false), true);
                        SKGTEST("REF:isClosed", tracker.isClosed(), false);

                        SKGTESTERROR("OPE:setTracker",subop1.setTracker(tracker), true);
                        SKGTESTERROR("OPE:save", subop1.save(), true);
                        SKGTrackerObject tracker2;
                        SKGTESTERROR("OPE:getTracker",subop1.getTracker(tracker2), true);
                        SKGTEST("OPE:compare", (tracker==tracker2), true);

                        SKGTESTERROR("REF:load", tracker.load(), true);
                        SKGTEST("REF:getCurrentAmount", tracker.getCurrentAmount(), 21);
                        SKGObjectBase::SKGListSKGObjectBase oSubOperations;
                        SKGTESTERROR("REF:getSubOperations",tracker.getSubOperations(oSubOperations), true);
                        SKGTEST("REF:compare", oSubOperations.count(), 1);

			SKGTrackerObject track;
                        SKGTESTERROR("REF:createTracker",SKGTrackerObject::createTracker ( &document1, "track", track, true ), true);
                }
        }

        //End test
        SKGENDTEST();
}
