/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgservices.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        //============================================================================
        {
                //Test bank document
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGUnitObject unit_euro(&document1);
                SKGUnitValueObject unit_euro_val1;
                QDate d1=QDate::currentDate().addMonths(-6);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T1", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(d1), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                        //Creation operation
                        SKGOperationObject op;
                        SKGTESTERROR("ACCOUNT:addOperation",account.addOperation(op), true);
                        SKGTESTERROR("OPE:setMode",op.setMode("cheque"), true);
                        SKGTESTERROR("OPE:setPayee",op.setPayee("SNCF"), true);
                        SKGTESTERROR("OPE:setComment",op.setComment("10 tickets"), true);
                        SKGTESTERROR("OPE:setDate",op.setDate(d1), true);
                        SKGTESTERROR("OPE:setUnit",op.setUnit(unit_euro), true);
                        SKGTESTERROR("OPE:save", op.save(), true);

                        {
                                SKGSubOperationObject subop;
                                SKGTESTERROR("OPE:addSubOperation",op.addSubOperation(subop), true);
                                SKGTESTERROR("SUBOPE:setQuantity",subop.setQuantity(8.5), true);
                                SKGTESTERROR("SUBOPE:save", subop.save(), true);
                        }
                        {
                                SKGSubOperationObject subop;
                                SKGTESTERROR("OPE:addSubOperation",op.addSubOperation(subop), true);
                                SKGTESTERROR("SUBOPE:setQuantity",subop.setQuantity(10), true);
                                SKGTESTERROR("SUBOPE:save", subop.save(), true);
                        }
                        //Checks
                        SKGTESTERROR("OPE:load", op.load(), true);
                        {
                                SKGOperationObject op2;
                                SKGTESTERROR("ACCOUNT:addOperation",account.addOperation(op2), true);
                                SKGTESTERROR("OPE:setMode",op2.setMode("cheque"), true);
                                SKGTESTERROR("OPE:setPayee",op2.setPayee("SNCF"), true);
                                SKGTESTERROR("OPE:setComment",op2.setComment("10 tickets"), true);
                                SKGTESTERROR("OPE:setDate",op2.setDate(d1), true);
                                SKGTESTERROR("OPE:setUnit",op2.setUnit(unit_euro), true);
                                SKGTESTERROR("OPE:save", op2.save(), true);

                                SKGSubOperationObject subop;
                                SKGTESTERROR("OPE:addSubOperation",op2.addSubOperation(subop), true);
                                SKGTESTERROR("SUBOPE:setQuantity",subop.setQuantity(8.5), true);
                                SKGTESTERROR("SUBOPE:save", subop.save(), true);

                                SKGTESTERROR("OPE:save", op.setGroupOperation(op2), true);
                                SKGTESTERROR("OPE:save", op.save(), true);
                        }

                        //Add recurrent operation
                        SKGRecurrentOperationObject recuope;
                        SKGTESTERROR("OP:addRecurrentOperation", op.addRecurrentOperation(recuope), true);
                        SKGTESTERROR("RECOP:setPeriodIncrement", recuope.setPeriodIncrement(2), true);
                        SKGTESTERROR("RECOP:setPeriodUnit", recuope.setPeriodUnit(SKGRecurrentOperationObject::MONTH), true);
                        SKGTESTERROR("RECOP:setAutoWriteDays", recuope.setAutoWriteDays(6), true);
                        SKGTESTERROR("RECOP:autoWriteEnabled", recuope.autoWriteEnabled(true), true);
                        SKGTESTERROR("RECOP:setWarnDays", recuope.setWarnDays(10), true);
                        SKGTESTERROR("RECOP:warnEnabled", recuope.warnEnabled(true), true);
                        SKGTESTERROR("RECOP:setTimeLimit", recuope.setTimeLimit(3), true);
                        SKGTESTERROR("RECOP:timeLimit", recuope.timeLimit(true), true);
                        SKGTESTERROR("RECOP:save", recuope.save(), true);

                        SKGObjectBase::SKGListSKGObjectBase recops;
                        SKGTESTERROR("OP:getRecurrentOperations", op.getRecurrentOperations(recops), true);
                        SKGTEST("RECOP:recops.count", recops.count(), 1);

                        SKGTEST("RECOP:getPeriodIncrement", recuope.getPeriodIncrement(), 2);
                        SKGTEST("RECOP:getPeriodUnit", recuope.getPeriodUnit(), SKGRecurrentOperationObject::MONTH);
                        SKGTEST("RECOP:getAutoWriteDays", recuope.getAutoWriteDays(), 6);
                        SKGTEST("RECOP:isAutoWriteEnabled", recuope.isAutoWriteEnabled(), true);
                        SKGTEST("RECOP:getWarnDays", recuope.getWarnDays(), 10);
                        SKGTEST("RECOP:isWarnEnabled", recuope.isWarnEnabled(), true);
                        SKGTEST("RECOP:getTimeLimit", recuope.getTimeLimit(), 3);
                        SKGTEST("RECOP:hasTimeLimit", recuope.hasTimeLimit(), true);
                        SKGTEST("RECOP:getDate", recuope.getDate().toString(), d1.toString());

                        SKGOperationObject ope2;
                        SKGTESTERROR("RECOP:getParentOperation", recuope.getParentOperation(ope2), true);
                        SKGTEST("RECOP:op==ope2", (op==ope2), true);

                        document1.dump(DUMPOPERATION);

                        int nbi=0;
                        SKGTESTERROR("RECOP:process", recuope.process(nbi), true);
                        SKGTEST("RECOP:nbi", nbi, 3);
                        SKGTESTERROR("RECOP:getParentOperation", recuope.getParentOperation(ope2), true);
                        SKGTEST("RECOP:op!=ope2", (op!=ope2), true);

                        SKGTESTERROR("RECOP:getRecurredOperations", recuope.getRecurredOperations(recops), true);
                        SKGTEST("RECOP:recops.count", recops.count(), 3);

                        SKGTESTERROR("RECOP:SKGRecurrentOperationObject::process", SKGRecurrentOperationObject::process(&document1,nbi), true);

                        document1.dump(DUMPOPERATION);
                }
        }

        //End test
        SKGENDTEST();
}
