/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGREPORTPLUGINWIDGET_H
#define SKGREPORTPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgreportpluginwidget_base.h"
#include "skgtabwidget.h"

#include <QStringList>
#include <QDomDocument>

class SKGDocumentBank;

/**
 * This file is Skrooge plugin to generate report
 */
class SKGReportPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGReportPluginWidget(SKGMainPanel* iParent, SKGDocumentBank* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGReportPluginWidget();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttibute();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

public slots:
        /**
         * Refresh the panel
         */
        void refresh();

        /**
        * data are modified
        * @param iTableName table name
        * @param iIdTransaction the id of the transaction for direct modifications of the table (update of modify objects is enough)
        *or 0 in case of modifications by impact (full table must be refreshed)
        */
        virtual void dataModified(const QString& iTableName, int iIdTransaction);

private slots:
        void onDoubleClick(int row, int column);
        void onOpenReport();
        void onSelectionChanged();

private:
        Q_DISABLE_COPY(SKGReportPluginWidget);
        QString getConsolidatedWhereClause();
        void getWhereClauseAndTitleForSelection(int row, int column, QString& oWc, QString& oTitle);

        Ui::skgreportplugin_base ui;
        QString previousParametersUsed;
        QStringList AttsForColumns;
        QStringList AttsForLines;
        QString operationWhereClause;
        QDomDocument lastState;
        QAction* openReportAction;
};

#endif // SKGREPORTPLUGINWIDGET_H
