/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to follow refund
 *
 * @author Stephane MANKOWSKI
 */
#include "skgrefundplugin.h"
#include "skgrefundpluginwidget.h"
#include "skrooge_refund.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

K_PLUGIN_FACTORY(SKGRefundPluginFactory, registerPlugin<SKGRefundPlugin>();)
K_EXPORT_PLUGIN(SKGRefundPluginFactory("skrooge_refund", "skrooge_refund"))

SKGRefundPlugin::SKGRefundPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGRefundPlugin::SKGRefundPlugin");
}

SKGRefundPlugin::~SKGRefundPlugin()
{
        SKGTRACEIN(10, "SKGRefundPlugin::~SKGRefundPlugin");
        parent=NULL;
        currentBankDocument=NULL;
}

void SKGRefundPlugin::setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGRefundPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
        parent=iParent;

        setComponentData( SKGRefundPluginFactory::componentData() );
        setXMLFile("skrooge_refund.rc");

        //Create yours actions here
}

void SKGRefundPlugin::refresh()
{
        SKGTRACEIN(10, "SKGRefundPlugin::refresh");
}

void SKGRefundPlugin::close()
{
        SKGTRACEIN(10, "SKGRefundPlugin::close");
}

SKGTabWidget* SKGRefundPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGRefundPlugin::getWidget");
        return new SKGRefundPluginWidget(parent, currentBankDocument);
}

QWidget* SKGRefundPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGRefundPlugin::getPreferenceWidget");
        //QWidget* widget=new QWidget();
        //ui.setupUi(widget);

        return NULL;
}

KConfigSkeleton* SKGRefundPlugin::getPreferenceSkeleton()
{
        return skrooge_refund::self();
}

SKGError SKGRefundPlugin::savePreferences() const
{
        return SKGError();
}

QString SKGRefundPlugin::title() const
{
        return i18n("Refund trackers");
}

QString SKGRefundPlugin::icon() const
{
        return "edit-find";
}

QString SKGRefundPlugin::statusTip () const
{
        return i18n("Manage refund trackers");
}

QString SKGRefundPlugin::toolTip () const
{
	return i18n("Manage refund trackers");
}


int SKGRefundPlugin::getOrder() const
{
        return 25;
}

QStringList SKGRefundPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>...you can follow your refunds by using a tracker.</p>"));
        return output;
}

bool SKGRefundPlugin::isInContext() const
{
        return true;
}

#include "skgrefundplugin.moc"
