/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for operation management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgoperationboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"

SKGOperationBoardWidget::SKGOperationBoardWidget (SKGDocument* iDocument )
                : SKGWidget (iDocument )
{
        SKGTRACEIN ( 10, "SKGOperationBoardWidget::SKGOperationBoardWidget" );

        ui.setupUi ( this );

        //Refresh
        connect ( ( const QObject* ) getDocument(), SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)), Qt::QueuedConnection );
        dataModified("", 0);
}

SKGOperationBoardWidget::~SKGOperationBoardWidget()
{
        SKGTRACEIN ( 10, "SKGOperationBoardWidget::~SKGOperationBoardWidget" );

}

void SKGOperationBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
        SKGTRACEIN ( 10, "SKGOperationBoardWidget::dataModified" );
        if (iTableName=="operation" || iTableName.isEmpty()) {
                //Get month
                QDate date=QDate::currentDate();
                date=date.addDays(1-date.day());
                QDate date1=date.addDays(-1);
                QString month=date.toString("yyyy-MM");
                QString previousmonth=date1.toString("yyyy-MM");

                QString primary=((SKGDocumentBank*) getDocument())->getPrimaryUnit();
                KLocale* locale=KGlobal::locale();

                SKGStringListList listTmp;
                SKGError err=SKGServices::executeSelectSqliteOrder(getDocument(),
                                "SELECT TOTAL(f_CURRENTAMOUNT), t_TYPEEXPENSE, d_DATEMONTH  from v_operation_display WHERE (d_DATEMONTH='"+month+"' OR d_DATEMONTH='"+previousmonth+"') AND i_group_id=0 group by d_DATEMONTH, t_TYPEEXPENSE",
                                listTmp);
                if (err.isSucceeded() && listTmp.count()>2) {
                        double income_previous_month=0;
                        double expense_previous_month=0;
                        double income_month=SKGServices::stringToDouble(listTmp.at(1).at(0));
                        double expense_month=abs(SKGServices::stringToDouble(listTmp.at(2).at(0)));
                        if (listTmp.count()>4) {
                                income_previous_month=income_month;
                                expense_previous_month=expense_month;
                                income_month=SKGServices::stringToDouble(listTmp.at(3).at(0));
                                expense_month=abs(SKGServices::stringToDouble(listTmp.at(4).at(0)));
                        }

                        //Set Maximum
                        int max=qMax(income_previous_month, qMax(expense_previous_month, qMax(income_month, expense_month)));
                        ui.kIncome->setMaximum(max);
                        ui.kIncome_previous->setMaximum(max);
                        ui.kExpense->setMaximum(max);
                        ui.kExpense_previous->setMaximum(max);

                        //Set value
                        ui.kIncome->setValue(income_month);
                        ui.kIncome_previous->setValue(income_previous_month);
                        ui.kExpense->setValue(expense_month);
                        ui.kExpense_previous->setValue(expense_previous_month);

                        //Set tool tips
                        QString tmp=QString ( "<font color=\"" ) + ( income_month<0 ? "red" : "black" ) +"\">"+locale->formatMoney ( income_month, primary, 2 ) +"</font>";
                        ui.kIncome->setToolTip (tmp);
                        tmp=QString ( "<font color=\"" ) + ( income_previous_month<0 ? "red" : "black" ) +"\">"+locale->formatMoney ( income_previous_month, primary, 2 ) +"</font>";
                        ui.kIncome_previous->setToolTip (tmp);
                        tmp=QString ( "<font color=\"" ) + ( expense_month<0 ? "red" : "black" ) +"\">"+locale->formatMoney ( expense_month, primary, 2 ) +"</font>";
                        ui.kExpense->setToolTip (tmp);
                        tmp=QString ( "<font color=\"" ) + ( expense_previous_month<0 ? "red" : "black" ) +"\">"+locale->formatMoney ( expense_previous_month, primary, 2 ) +"</font>";
                        ui.kExpense_previous->setToolTip (tmp);
                }
        }
}

#include "skgoperationboardwidget.moc"
