/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for debug.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdebugplugin.h"
#include "skgdebugpluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"

K_PLUGIN_FACTORY(SKGDebugPluginFactory, registerPlugin<SKGDebugPlugin>();)
K_EXPORT_PLUGIN(SKGDebugPluginFactory("skrooge_debug", "skrooge_debug"))

SKGDebugPlugin::SKGDebugPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGDebugPlugin::SKGDebugPlugin");
}

SKGDebugPlugin::~SKGDebugPlugin()
{
        SKGTRACEIN(10, "SKGDebugPlugin::~SKGDebugPlugin");
	parent=NULL;
	currentBankDocument=NULL;
}

void SKGDebugPlugin::setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGDebugPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
        parent=iParent;
}

void SKGDebugPlugin::close()
{
        SKGTRACEIN(10, "SKGDebugPlugin::close");
}

SKGTabWidget* SKGDebugPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGDebugPlugin::getWidget");
        return new SKGDebugPluginWidget(parent, currentBankDocument);
}

QString SKGDebugPlugin::title() const
{
        return i18n("Debug");
}

QString SKGDebugPlugin::icon() const
{
        return "tools-report-bug";
}

QString SKGDebugPlugin::statusTip () const
{
        return i18n("Useful for debug");
}

QString SKGDebugPlugin::toolTip () const
{
        return i18n("Useful for debug");
}

bool SKGDebugPlugin::isInContext() const
{
        return true;
}

bool SKGDebugPlugin::isEnabled() const
{
        return (SKGTraces::SKGLevelTrace>0 || SKGTraces::SKGPerfo);
}

#include "skgdebugplugin.moc"
