/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A dashboard for skrooge.
 *
 * @author Stephane MANKOWSKI
 */
#include "skgdashboardpluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"
#include "skginterfaceplugin.h"

#include <QDomDocument>
#include <QSpacerItem>

SKGDashboardPluginWidget::SKGDashboardPluginWidget(SKGMainPanel* iParent, SKGDocument* iDocument)
                : SKGTabWidget(iParent, iDocument), gridLayout(NULL)
{
        SKGTRACEIN(1, "SKGDashboardPluginWidget::SKGDashboardPluginWidget");

        ui.setupUi(this);

        gridLayout = new QGridLayout(ui.kContent);

        int index=1;
        int col=0;
        int row=0;
        int nbInserted=0;
        while (index>0) {
                SKGInterfacePlugin* plugin=getMainPanel()->getPluginByIndex(index);
                if (plugin) {
                        SKGWidget* dbPlugin=plugin->getDashboardWidget();
                        if (dbPlugin) {
                                dbPlugin->setParent(ui.kContent);
                                gridLayout->addWidget(dbPlugin, row, col);

                                ++nbInserted;
                                ++col;
                                if (col==3) {
                                        ++row;
                                        col=0;
                                }
                        }
                } else {
                        index=-1;
                }
                ++index;
        }

        if (nbInserted<3) {
                gridLayout->addItem(new QSpacerItem(0,0), row, col, QSizePolicy::Expanding);
        }
        gridLayout->addItem(new QSpacerItem(0,0), row+1, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
}

SKGDashboardPluginWidget::~SKGDashboardPluginWidget()
{
        SKGTRACEIN(1, "SKGDashboardPluginWidget::~SKGDashboardPluginWidget");
}

QString SKGDashboardPluginWidget::getState()
{
        SKGTRACEIN(10, "SKGDashboardPluginWidget::getState");
        QDomDocument doc("SKGML");
        QDomElement root = doc.createElement("parameters");
        doc.appendChild(root);

        //Get state
        //Example: QString account=root.attribute ( "account");
        //         if (account.isEmpty()) root.setAttribute("account", ui.kDisplayAccountCombo->currentText());

        return doc.toString();
}

void SKGDashboardPluginWidget::setState(const QString& iState )
{
        SKGTRACEIN(10, "SKGDashboardPluginWidget::setState");
        QDomDocument doc("SKGML");
        doc.setContent(iState);
        QDomElement root = doc.documentElement();

        //Set state
        //Example: QString account=root.attribute ( "account");
}

QWidget* SKGDashboardPluginWidget::getWidgetForPrint()
{
        return this;
}

void SKGDashboardPluginWidget::refresh()
{
        SKGTRACEIN(1, "SKGDashboardPluginWidget::refresh");

}

#include "skgdashboardpluginwidget.moc"


