/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDATEEDIT_H
#define SKGDATEEDIT_H
/** @file
 * A date edit for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <kglobal.h>
#include <QDateEdit>
#include <QtDesigner/QDesignerExportWidget>

/**
 * This file is Skrooge tab widget used by plugins
 */
class KDE_EXPORT SKGDateEdit : public QDateEdit
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         * @param parent the parent
         */
        SKGDateEdit(QWidget *parent = 0);

        /**
         * Default Destructor
         */
        virtual ~SKGDateEdit();

protected:
        /**
        * This event handler, for event event, can be reimplemented in a subclass to receive key press events for the widget.
        * @param event the event
         */
        virtual void keyPressEvent( QKeyEvent * event );

private:
        Q_DISABLE_COPY(SKGDateEdit);
};

#endif // SKGDATEEDIT_H
