/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is part of Skrooge and implements classes SKGSubOperationObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgsuboperationobject.h"
#include "skgoperationobject.h"
#include "skgcategoryobject.h"
#include "skgrefundtrackerobject.h"
#include "skgservices.h"

SKGSubOperationObject::SKGSubOperationObject(const SKGDocument* iDocument, int iID): SKGObjectBase(iDocument, "v_suboperation", iID)
{
}

SKGSubOperationObject::~SKGSubOperationObject()
{
}

SKGSubOperationObject::SKGSubOperationObject(const SKGSubOperationObject& iObject)
                : SKGObjectBase(iObject)
{
}

SKGSubOperationObject::SKGSubOperationObject(const SKGObjectBase& iObject)
{
        if (iObject.getRealTable()=="suboperation") {
                copyFrom(iObject);
        } else {
                *this=SKGObjectBase::SKGObjectBase(iObject.getDocument(), "v_suboperation", iObject.getID());
        }
}

const SKGSubOperationObject& SKGSubOperationObject::operator= (const SKGObjectBase& iObject)
{
        copyFrom(iObject);
        return *this;
}

SKGError SKGSubOperationObject::setComment(const QString& iComment)
{
        return setAttribute("t_comment", iComment);
}

QString SKGSubOperationObject::getComment() const
{
        return getAttribute("t_comment");
}

SKGError SKGSubOperationObject::getParentOperation(SKGOperationObject& oOperation) const
{
        SKGError err = getObject(getDocument(), "v_operation", "id=" + getAttribute("rd_operation_id"), oOperation);
        return err;
}

SKGError SKGSubOperationObject::setParentOperation(const SKGOperationObject& iOperation)
{
        return setAttribute("rd_operation_id", SKGServices::intToString(iOperation.getID()));
}


SKGError SKGSubOperationObject::getCategory(SKGCategoryObject& oCategory) const
{
        SKGError err = getObject(getDocument(), "v_category", "id=" + getAttribute("r_category_id"), oCategory);
        return err;
}

SKGError SKGSubOperationObject::setCategory(const SKGCategoryObject& iCategory)
{
        return setAttribute("r_category_id", SKGServices::intToString(iCategory.getID()));
}

SKGError SKGSubOperationObject::setQuantity(double iValue)
{
        return setAttribute("f_value", SKGServices::doubleToString(iValue));
}

double SKGSubOperationObject::getQuantity() const
{
        return SKGServices::stringToDouble(getAttribute("f_value"));
}


SKGError SKGSubOperationObject::setRefundTracker(const SKGRefundTrackerObject& iTracker)
{
        return setAttribute("r_refund_id", SKGServices::intToString(iTracker.getID()));
}

SKGError SKGSubOperationObject::getRefundTracker(SKGRefundTrackerObject& oTracker) const
{
        SKGError err = getObject(getDocument(), "v_refund", "id=" + getAttribute("r_refund_id"), oTracker);
        return err;

}

SKGError SKGSubOperationObject::removeRefundTracker()
{
        return setAttribute("r_refund_id", "0");
}

#include "skgsuboperationobject.moc"
