/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNDOREDOPLUGINDOCKWIDGET_H
#define SKGUNDOREDOPLUGINDOCKWIDGET_H
/** @file
* This file is Skrooge undoredo for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgundoredoplugindockwidget_base.h"
#include "skgtabwidget.h"

/**
 * This file is Skrooge plugin for undoredo management
 */
class SKGUndoRedoPluginDockWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGUndoRedoPluginDockWidget(SKGMainPanel* iParent, SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGUndoRedoPluginDockWidget();

protected:
        /**
         * This event handler can be reimplemented in a subclass to receive widget resize events which are passed in the event parameter.
         * When resizeEvent() is called, the widget already has its new geometry. The old size is accessible through QResizeEvent::oldSize().
         * @param event the event pointer
         */
        virtual void resizeEvent(QResizeEvent *event);

private slots:
        void onUndoRedo(const QModelIndex & index);

private:
        Q_DISABLE_COPY(SKGUndoRedoPluginDockWidget);

        Ui::skgundoredoplugindockwidget_base ui;
};

#endif // SKGUNDOREDOPLUGINDOCKWIDGET_H
