/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to print pages.
 *
 * @author Stephane MANKOWSKI
 */
#include "skgprintpluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"

#include <QDomDocument>
#include <QPrintPreviewWidget>

SKGPrintPluginWidget::SKGPrintPluginWidget(SKGMainPanel* iParent, SKGDocument* iDocument)
                : SKGTabWidget(iParent, iDocument)
{
        SKGTRACEIN(1, "SKGPrintPluginWidget::SKGPrintPluginWidget");

        new QPrintPreviewWidget( this);

        //ui.setupUi(this);

        //Build you panel here
}

SKGPrintPluginWidget::~SKGPrintPluginWidget()
{
        SKGTRACEIN(1, "SKGPrintPluginWidget::~SKGPrintPluginWidget");
}

QString SKGPrintPluginWidget::getState()
{
        SKGTRACEIN(10, "SKGPrintPluginWidget::getState");
        QDomDocument doc("SKGML");
        QDomElement root = doc.createElement("parameters");
        doc.appendChild(root);

        //Get state
        //Example: QString account=root.attribute ( "account");
        //         if (account.isEmpty()) root.setAttribute("account", ui.kDisplayAccountCombo->currentText());

        return doc.toString();
}

void SKGPrintPluginWidget::setState(const QString& iState )
{
        SKGTRACEIN(10, "SKGPrintPluginWidget::setState");
        QDomDocument doc("SKGML");
        doc.setContent(iState);
        QDomElement root = doc.documentElement();

        //Set state
        //Example: QString account=root.attribute ( "account");
}

QWidget* SKGPrintPluginWidget::getWidgetForPrint()
{
        return NULL;
}

void SKGPrintPluginWidget::refresh()

{
        SKGTRACEIN(1, "SKGPrintPluginWidget::refresh");

        QSqlDatabase* db = getDocument()->getDatabase();
        setEnabled(db!=NULL);
        if (db!=NULL) {
                //Refresh yours widgets here
        }
}

#include "skgprintpluginwidget.moc"


