/*
 * # skkinput (Simple Kana-Kanji Input) table.h --- define roma-kana table,
 * roma-kana rule list and prefix rule. This file is part of skkinput.
 * Copyright (C) 1997 Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * skkinput; see the file COPYING.  If not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef TABLE_H
#define TABLE_H

#include "kanji.h"

struct roma_kana_table
  {
    struct myChar prefix[4];
    struct myChar kana[4];
    struct myChar katakana[4];
  };

static struct roma_kana_table skk_roma_kana_a[] =
{
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2422},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2522},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2450},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2550},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2453},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2553},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2440},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2540},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2447},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2547},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2442},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2542},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2421},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2521},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242e},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252e},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2452},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2552},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242d},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252d},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245f},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255f},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244b},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254b},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2451},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2551},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2454},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2554},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2469},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2569},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246a},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256a},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2435},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2535},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x243f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x253f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2446},
      {CHARSET_JISX0208_1983, 0x2421},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2546},
      {CHARSET_JISX0208_1983, 0x2521},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'v'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x212b},
      {CHARSET_JISX0208_1983, 0x2421},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2574},
      {CHARSET_JISX0208_1983, 0x2521},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2421},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2521},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2575},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2464},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2564},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2436},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2536},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2463},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2563},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
};
static struct roma_kana_table skk_roma_kana_i[] =
{
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2424},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2524},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2453},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2553},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2453},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2553},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2442},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2542},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2447},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2547},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2442},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2542},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242e},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252e},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2452},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2552},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2452},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2552},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242d},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252d},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245f},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255f},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244b},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254b},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2454},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2554},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2454},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2554},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246a},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256a},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2446},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2546},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'v'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x212b},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2574},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2526},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2470},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2570},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2423},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2523},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
};
static struct roma_kana_table skk_roma_kana_u[] =
{
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2526},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2456},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2556},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2453},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2553},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2445},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2545},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2447},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2547},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2442},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2542},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2430},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2530},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242e},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252e},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2452},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2552},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252f},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242d},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252d},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2460},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2560},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245f},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255f},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244b},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254b},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2457},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2557},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2454},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2554},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246a},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256a},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2439},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2539},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2444},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2544},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2446},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2546},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2444},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2544},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'v'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x212b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2574},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2526},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2425},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2525},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2443},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2543},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2443},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2543},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2466},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2566},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x243a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x253a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2465},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2565},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
};
static struct roma_kana_table skk_roma_kana_e[] =
{
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2428},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2528},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2459},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2559},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2453},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2553},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2447},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2547},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2447},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2547},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2442},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2542},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2432},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2532},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242e},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252e},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2458},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2558},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2452},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2552},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2431},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2531},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242d},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252d},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2461},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2561},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245f},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255f},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244b},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254b},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2454},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2554},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246a},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256a},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x243b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x253b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2446},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2546},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2446},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2546},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'v'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x212b},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2574},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2526},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2431},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2576},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2471},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2571},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2424},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2524},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x243c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x253c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2427},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2527},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
};
static struct roma_kana_table skk_roma_kana_o[] =
{
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252a},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255c},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'b'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2453},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2553},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'c'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2449},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2549},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2447},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2547},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'd'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2442},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2542},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2429},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2529},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'f'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2455},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2555},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2434},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2534},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'g'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242e},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252e},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255b},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2452},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2552},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'j'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2433},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2533},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'k'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x242d},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x252d},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2462},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2562},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'm'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245f},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255f},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'n'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x244b},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x254b},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x245d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x255d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'p'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2454},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2554},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'r'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x246a},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x256a},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x243d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x253d},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 's'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2437},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2537},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2448},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2548},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'h'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2446},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2546},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 't'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2441},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2541},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'v'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2426},
      {CHARSET_JISX0208_1983, 0x212b},
      {CHARSET_JISX0208_1983, 0x2429},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2574},
      {CHARSET_JISX0208_1983, 0x2529},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'w'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2472},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2572},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2429},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2529},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'x'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2468},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2568},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x243e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x253e},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, 'z'},
      {CHARSET_ASCII, 'y'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2438},
      {CHARSET_JISX0208_1983, 0x2467},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_JISX0208_1983, 0x2538},
      {CHARSET_JISX0208_1983, 0x2567},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
  {
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
    {
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
      {CHARSET_ASCII, '\0'},
    },
  },
};

static struct myChar kanji_num_list[] = {
  { CHARSET_JISX0208_1983, 0x213b /*  */ }, 
  { CHARSET_JISX0208_1983, 0x306c /*  */ }, 
  { CHARSET_JISX0208_1983, 0x4673 /*  */ }, 
  { CHARSET_JISX0208_1983, 0x3b30 /*  */ }, 
  { CHARSET_JISX0208_1983, 0x3b4d /*  */ }, 
  { CHARSET_JISX0208_1983, 0x385e /*  */ }, 
  { CHARSET_JISX0208_1983, 0x4f3b /* ϻ */ }, 
  { CHARSET_JISX0208_1983, 0x3c37 /*  */ }, 
  { CHARSET_JISX0208_1983, 0x482c /* Ȭ */ }, 
  { CHARSET_JISX0208_1983, 0x3665 /*  */ }, 
} ;

static struct myChar kazu_no_tanni[17][5] =
{
  {
    {CHARSET_JISX0208_1983, 0x4b7c /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x322f /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x437b /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x357e /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x5436 /* Զ */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x5933 /* ٳ */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x3e77 /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x3942 /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x3442 /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x4035 /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x3a5c /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x364b /*  */ },
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x3931 /* Ϻ */ },
    {CHARSET_JISX0208_1983, 0x324f},
    {CHARSET_JISX0208_1983, 0x3a3b},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x3024 /* ε */ },
    {CHARSET_JISX0208_1983, 0x414e},
    {CHARSET_JISX0208_1983, 0x3540},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x4661 /* ͳ¾ */ },
    {CHARSET_JISX0208_1983, 0x4d33},
    {CHARSET_JISX0208_1983, 0x423e},
    {CHARSET_ASCII, '\0'},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x4954 /* ԲĻ׵ */ },
    {CHARSET_JISX0208_1983, 0x3244},
    {CHARSET_JISX0208_1983, 0x3b57},
    {CHARSET_JISX0208_1983, 0x3544},
    {CHARSET_ASCII, '\0'}},
  {
    {CHARSET_JISX0208_1983, 0x4c35 /* ̵ */ },
    {CHARSET_JISX0208_1983, 0x4e4c},
    {CHARSET_JISX0208_1983, 0x4267},
    {CHARSET_JISX0208_1983, 0x3f74},
    {CHARSET_ASCII, '\0'}}};

#if 0
/* ʸλ°ơ֥롣 */
static int skk_char_type_vector[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 0, 4, 4, 4,
  4, 0, 4, 4, 4, 4, 4, 4,
  0, 4, 4, 0, 0, 0, 0, 0,
  0, 3, 1, 1, 1, 3, 1, 1,
  1, 3, 1, 1, 0, 1, 2, 3,
  1, 0, 1, 1, 1, 3, 1, 1,
  2, 1, 1, 0, 0, 0, 0, 5,
};
#endif

/* ǽ prefix Υꥹ */
static char *skk_prefix_list[] =
{
  "by", "ch", "cy", "dh", "dy", "fy", "gy", "hy", "jy", "ky", "my",
  "py", "ry", "sh", "sy", "th", "ts", "ty", "xk", "xt", "xts", "xw",
  "xy", "zy", "ny", NULL
};

#if 0
static struct skk_rom_kana_rule skkinput_rom_kana_rule_list[] =
{
  {"nn", "n", "", ""},
  {"n'", NULL, "", ""},
  {"nL", NULL, "", ""},
  {"nl", NULL, "", ""},
  {NULL, NULL, NULL, NULL},
};
#endif

#endif
