/* Copyright 2013-2014 IBM Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <asm-utils.h>

/*
	hello_kernel.S!
	---------------

	Because skiboot has its own stack, we don't even need that!
	All we need to do is make an OPAL call to write to the console.

*/

	
	. = 0x0
	.globl _start
_start:
	mr 2, 8
	li 0, 1 /* OPAL_CONSOLE_WRITE */
	li 3, 0 /* terminal 0 */
	LOAD_IMM64(29, 0x20010000)
	lis 4, len@ha
	addi 4,4, len@l
	add 4,4,29
	lis 5, str@ha
	addi 5,5, str@l
	add 5,5,29
	mtctr 9
	bctrl
	attn

len:	
	.long 0x00
	.long 0x0D
str:	
	.string "Hello World!\n"
