/* Public domain. */

#include <unistd.h>
#include <errno.h>
#include "bytestr.h"
#include "stralloc.h"
#include "djbunix.h"

void execvep_tmp (char const *file, char const *const *argv, char const *const *envp, char const *path, stralloc *tmp)
{
  if (!path) errno = EINVAL ;
  else if (file[str_chr(file, '/')])
    execve(file, (char *const *)argv, (char *const *)envp) ; /* prototype stupidity */
  else
  {
    unsigned int tmpbase = tmp->len ;
    int savederrno = 0 ;
    for (;;)
    {
      unsigned int split = str_chr(path, ':') ;
      tmp->len = tmpbase ;
      if (!(split ? stralloc_catb(tmp, path, split) : stralloc_catb(tmp, ".", 1))
       || !stralloc_catb(tmp, "/", 1)
       || !stralloc_cats(tmp, file)
       || !stralloc_0(tmp))
        break ;
      execve(tmp->s + tmpbase, (char *const *)argv, (char *const *)envp) ; /* sigh */
      if (errno != ENOENT)
      {
        savederrno = errno ;
        if ((errno != EACCES) && (errno != EPERM) && (errno != EISDIR)) break ;
      }
      if (!path[split])
      {
        if (savederrno) errno = savederrno ;
        break ;
      }
      path += split + 1 ;
    }
    tmp->len = tmpbase ;
  }
}
