#include "sjog.h"
#include "sjog_brightness.h"

/* Timer callback that hides the brightness dialog window.
 */
int
sjog_brightness_timer_callback(gpointer * data)
{

   D_ENTER;

   sjog_brightness_hide();

   /* return false so that the timer won't call us back again */
   return FALSE;
}


/* Brightness window closed callback, we hide the window instead of
 * destroying it.
 */
int
sjog_brightness_signal_delete_event_callback(GtkWidget * widget,
                                             GdkEvent * event,
                                             gpointer * data)
{

   D_ENTER;

   sjog_brightness_hide();

   /* return true so that the window won't be destroyed */
   return TRUE;

}
