#define _XOPEN_SOURCE 500
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/io.h>
#include <sys/mman.h>
#include <dirent.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include <getopt.h>
#include <linux/pci.h>
#include <sys/time.h>


#define BRIGHTNESS 0x96
#define DATA_REG 0x62
#define CST_REG  0x66

typedef unsigned short u16;

static void ecr_set(u16 value)
{
	while (inw(CST_REG) & 3) usleep(1);
	outw(0x81, CST_REG);
	while (inw(CST_REG) & 2) usleep(1);
	outw(BRIGHTNESS, DATA_REG);
	while (inw(CST_REG) & 2) usleep(1);
	outw(value, DATA_REG);
	while (inw(CST_REG) & 2) usleep(1);
}

static u16 ecr_get()
{
	while (inw(CST_REG) & 3) usleep(1);
	outb(0x80, CST_REG);
	while (inw(CST_REG) & 2) usleep(1);
	outb(BRIGHTNESS, DATA_REG);
	while (inw(CST_REG) & 2) usleep(1);
	return (inw(DATA_REG)&255);
}

static void usage()
{
        fprintf(stdout, "Usage: setbrightness [--read | <value between 0 and 255>]\n");
        fprintf(stdout, "       Sets the screen brightness on a Sony Vaio\n");
}

int main(int argc, char *argv[])
{

	ioperm(DATA_REG, 0x08, 1); 
        if( geteuid() != 0 )
                fprintf(stdout, "You must be root to use %s\n", argv[0]);

        else if( argc == 2 && strcmp(argv[1], "--read") == 0) 
	    printf("%d\n", ecr_get());

        else if( argc != 2 || !isdigit(argv[1][0])) 
                usage();

        else
        {
	        iopl(3);
        	ecr_set(atoi(argv[1]));
        }

	return 0;

}
