bool move_is_long_algebraic(const char *move) const
{
   const int board_size = bitboard_t<kind>::board_files*bitboard_t<kind>::board_ranks;

   if (move[0] == '+') move++;
   if (strlen(move) < 4) return false;

#if 1
   bool ok = false;
   for (int n = 0; n<board_size; n++) {
      if (strstr(move, square_names[n]) == move) {
         ok = true;
         move += strlen(square_names[n]);
         break;
      }
   }

   if (!ok) return false;

   ok = false;
   for (int n = 0; n<board_size; n++) {
      if (strstr(move, square_names[n]) == move) {
         ok = true;
         move += strlen(square_names[n]);
         break;
      }
   }
   if (!ok) return false;

   if (*move == 0) return true;
   if (*move == '+') return true;
   if (!isdigit(*move)) return true;

   return false;

#else
#if 1
   if (!isalpha(move[0])) return false;
   if (!islower(move[0])) return false;

   move++;
   if (!isdigit(move[0])) return false;
   while (*move && isdigit(move[0])) move++;

   if (!isalpha(move[0])) return false;
   if (!islower(move[0])) return false;

   move++;
   if (!isdigit(move[0])) return false;
   
   return true;
#else

   if (isalpha(move[0]) && isalpha(move[2]) && islower(move[0]) && isdigit(move[1]) && isdigit(move[3]))
      return true;

   return false;
#endif
#endif
}

move_t move_string_to_move(const char *move_str, const movelist_t *external_movelist) const
{
   const int board_size = bitboard_t<kind>::board_files*bitboard_t<kind>::board_ranks;
   movelist_t movelist;
   int src = 0, dest = 0, ppiece = 0;
   char *s;
   int n;

   /* First, generate the list of moves for this position */
   if (external_movelist) {
      movelist.clear();
      for(int n = 0; n<external_movelist->num_moves; n++)
         movelist.push(external_movelist->move[n]);
   } else {
      generate_legal_moves(&movelist);
   }

   while (isspace(*move_str) && *move_str) move_str++;

   /* Test if the move is simplified long algebraic (from-to) */
   if (move_is_long_algebraic(move_str)) {
      const char *s = move_str;
      int from, to;

      for (int n = 0; n<board_size; n++) {
         if (strstr(s, square_names[n]) == s) {
            from = n;
            s += strlen(square_names[n]);
            break;
         }
      }

      for (int n = 0; n<board_size; n++) {
         if (strstr(s, square_names[n]) == s) {
            to = n;
            s += strlen(square_names[n]);
            break;
         }
      }

      /* Capture of own piece: castling move encoded as KxR or RxK? */
      side_t side = board.side_to_move;
      if (board.bbc[side].test(to)) {
         int piece = board.get_piece(to);

         for (int n = 0; n < movelist.num_moves; ) {
            if (is_castle_move(movelist.move[n]))
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }

         /* Gating move? */
         if (s[0]) {
            /* Filter out non-gate moves */
            for (int n = 0; n < movelist.num_moves; ) {
               if (is_gate_move(movelist.move[n])) {
                  n++;
               } else {
                  movelist.move[n] = movelist.move[--movelist.num_moves];
               }
            }

            int piece = pt.promotion_piece_id_from_string(s);

            /* Filter by piece-type if still not unique */
            if (movelist.num_moves > 1)
               for (int n = 0; n < movelist.num_moves; ) {
                  if (get_move_promotion_piece(movelist.move[n]) == piece)
                     n++;
                  else
                     movelist.move[n] = movelist.move[--movelist.num_moves];
               }
         }

         if (pt.castle_piece[side] == piece) { /* KxR */
            if (s[0]) { /* Gates */
               for (int n = 0; n < movelist.num_moves; ) {
                  if (is_gate_move(movelist.move[n]) && get_move_drop_square(movelist.move[n]) == from)
                     n++;
                  else
                     movelist.move[n] = movelist.move[--movelist.num_moves];
               }
            }

            bool qsc = (to <= from);
            for (int n = 0; n < movelist.num_moves; ) {
               if (unpack_file(get_move_to(movelist.move[n])) < div_file && qsc)
                  n++;
               else if (unpack_file(get_move_to(movelist.move[n])) > div_file && !qsc)
                  n++;
               else
                  movelist.move[n] = movelist.move[--movelist.num_moves];
            }
         } else {                              /* RxK */
            if (s[0]) { /* Gates */
               for (int n = 0; n < movelist.num_moves; ) {
                  move_t move = movelist.move[n];
                  if (is_gate_move(move) && get_move_drop_square(move) == get_castle_move_from2(move))
                     n++;
                  else
                     movelist.move[n] = movelist.move[--movelist.num_moves];
               }
            }
            bool qsc = (to >= from);
            for (int n = 0; n < movelist.num_moves; ) {
               if (unpack_file(get_move_to(movelist.move[n])) < div_file && qsc)
                  n++;
               else if (unpack_file(get_move_to(movelist.move[n])) > div_file && !qsc)
                  n++;
               else
                  movelist.move[n] = movelist.move[--movelist.num_moves];
            }
         }

         if (movelist.num_moves == 1)
            return movelist.move[0];
      }

      for (int n = 0; n < movelist.num_moves; ) {
         if (get_move_to(movelist.move[n]) == to && get_move_from(movelist.move[n]) == from)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }

      /* Promotion piece */
      if (movelist.num_moves > 1) {
         if (*s == '+') {
            for (int n = 0; n < movelist.num_moves; )
               if (is_promotion_move(movelist.move[n]))
                  n++;
               else
                  movelist.move[n] = movelist.move[--movelist.num_moves];
         } else {
            int n = -1;
            if (*s && islower(*s)) {
               int ppiece = pt.promotion_piece_id_from_string(s);
               if (is_castle_move(movelist.move[0])) {
                  for (int n = 0; n < movelist.num_moves; )
                     if (is_gate_move(movelist.move[n]) && get_move_drop_square(movelist.move[n]) == from)
                        n++;
                     else
                        movelist.move[n] = movelist.move[--movelist.num_moves];
                  n = 0;
               } else
                  n = movelist.validate_move(from, to, ppiece);
            } else
               n = movelist.validate_move(from, to);

            if (n > -1)
               return movelist.move[n];
         }
      }

      if (movelist.num_moves == 1)
         return movelist.move[0];

      /* Try again */
      if (external_movelist) {
         movelist.clear();
         for(int n = 0; n<external_movelist->num_moves; n++)
            movelist.push(external_movelist->move[n]);
      } else {
         generate_legal_moves(&movelist);
      }

      return 0;
   }

   /* Now, filter the move list in an attempt to identify SAN moves. */
   if (strchr(move_str, '^')) {                                         /* Pickup move */
      for (int n = 0; n < movelist.num_moves; ) {
         if (is_pickup_move(movelist.move[n]))
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }

      const char *s = move_str;
      int file, rank, n;
      while (!isdigit(s[1])) s++;
      file = *s - 'a'; s++;
      sscanf(s, "%d %n", &rank, &n); s += n;
      rank -= rank_offset; /* Xboard counts ranks from 0 for large boards */
      int from = bitboard_t<kind>::pack_rank_file(rank, file);

      for (int n = 0; n < movelist.num_moves; ) {
         if (get_move_from(movelist.move[n]) == from)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }

      int piece = pt.piece_id_from_string(move_str);
      for (int n = 0; n < movelist.num_moves; ) {
         if (get_move_piece(movelist.move[n]) == piece)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }
   } else if (strstr(move_str, "@@")) { /* Pickup move, alternate encoding */
      for (int n = 0; n < movelist.num_moves; ) {
         if (is_pickup_move(movelist.move[n]))
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }

      const char *s = move_str;
      int file, rank, n;
      while (!isdigit(s[1])) s++;
      file = *s - 'a'; s++;
      sscanf(s, "%d %n", &rank, &n); s += n;
      rank -= rank_offset; /* Xboard counts ranks from 0 for large boards */
      int from = bitboard_t<kind>::pack_rank_file(rank, file);

      for (int n = 0; n < movelist.num_moves; ) {
         if (get_move_from(movelist.move[n]) == from)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }
   } else if (strchr(move_str, '@') || strchr(move_str, '*')) {         /* Drop move */
      for (int n = 0; n < movelist.num_moves; ) {
         if (is_drop_move(movelist.move[n]))
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }

      const char *s = move_str;
      int file, rank, n;
      while (!isdigit(s[1])) s++;
      file = *s - 'a'; s++;
      sscanf(s, "%d %n", &rank, &n); s += n;
      rank -= rank_offset; /* Xboard counts ranks from 0 for large boards */
      int to = bitboard_t<kind>::pack_rank_file(rank, file);

      for (int n = 0; n < movelist.num_moves; ) {
         if (get_move_to(movelist.move[n]) == to)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }

      int piece = pt.piece_id_from_string(move_str);
      for (int n = 0; n < movelist.num_moves; ) {
         if (get_move_piece(movelist.move[n]) == piece)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }
   } else {
      /* Filter out drop moves */
      for (int n = 0; n < movelist.num_moves; ) {
         if (is_drop_move(movelist.move[n]) || is_pickup_move(movelist.move[n]))
            movelist.move[n] = movelist.move[--movelist.num_moves];
         else
            n++;
      }
      if (move_str[0] == 'O' && move_str[2] == 'O') {       /* Castling */
         for (int n = 0; n < movelist.num_moves; ) {
            if (is_castle_move(movelist.move[n]))
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }
         bool qsc = (strlen(move_str) == strlen(queenside_castle));
         for (int n = 0; n < movelist.num_moves; ) {
            if (unpack_file(get_move_to(movelist.move[n])) < div_file && qsc)
               n++;
            else if (unpack_file(get_move_to(movelist.move[n])) > div_file && !qsc)
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }
      } else if (islower(move_str[0])) {     /* Pawn move */
         /* Throw out all moves that do not reach the correct destination square */
         const char *s = strchr(move_str, 'x');
         if (!s) s = strchr(move_str, '-');
         if (s)
            s++;
         else
            s = move_str;
         int to = -1;
         for (int n = 0; n<board_size; n++) {
            if (strstr(s, square_names[n])) {
               to = n;
               break;
            }
         }

         for (int n = 0; n < movelist.num_moves; ) {
            if (get_move_to(movelist.move[n]) == to)
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }

         /* Throw away non-pawns */
         for (int n = 0; n < movelist.num_moves; ) {
            if (piece_symbol_string[get_move_piece(movelist.move[n])] == ' ')
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }

      } else if (isupper(move_str[0]) || move_str[0] == '+') {     /* Piece move */
         int piece = -1;
         for (int n=0; n<pt.num_piece_types; n++) {
            if (strstr(move_str, pt.piece_notation[n]) == move_str) {
               piece = n;
               break;
            }
         }
         for (int n = 0; n < movelist.num_moves; ) {
            if (get_move_piece(movelist.move[n]) == piece)
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }

         /* Throw out all moves that do not reach the correct destination square */
         const char *s = strchr(move_str, '-');
         int file, rank, n;
         if (s)
            s++;
         else
            s = move_str+1;
         while (!isdigit(s[1])) s++;
         file = *s - 'a'; s++;
         sscanf(s, "%d %n", &rank, &n); s += n;
         rank -= rank_offset; /* Xboard counts ranks from 0 for large boards */
         int to = bitboard_t<kind>::pack_rank_file(rank, file);

         for (int n = 0; n < movelist.num_moves; ) {
            if (get_move_to(movelist.move[n]) == to)
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }
      }
   }
   
   if (movelist.num_moves > 1) {
      bool is_gate = false;
      if (isupper(move_str[strlen(move_str)-1]))
         is_gate = true;

      /* Filter out non-gate moves */
      for (int n = 0; n < movelist.num_moves; ) {
         if (is_gate_move(movelist.move[n]) == is_gate) {
            n++;
         } else {
            movelist.move[n] = movelist.move[--movelist.num_moves];
         }
      }

      if (is_gate) {
         int piece = pt.promotion_piece_id_from_string(move_str + strlen(move_str)-1);

         /* Filter by piece-type if still not unique */
         if (movelist.num_moves > 1)
         for (int n = 0; n < movelist.num_moves; ) {
            if (get_move_promotion_piece(movelist.move[n]) == piece)
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }
      }
   }

   if (movelist.num_moves > 1 && islower(move_str[1])) { /* Disambiguate by file? */
      int file = move_str[1] - 'a';
      if (islower(move_str[0])) file = move_str[0] - 'a';   /* Pawn! */
      if (file < bitboard_t<kind>::board_files)
      for (int n = 0; n < movelist.num_moves; ) {
         if (unpack_file(get_move_from(movelist.move[n])) == file)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }
   }

   if (movelist.num_moves > 1 && isdigit(move_str[1])) { /* Disambiguate by rank? */
      int rank;
      sscanf(move_str+1, "%d", &rank);
      rank -= rank_offset; /* Xboard counts ranks from 0 for large boards */
      for (int n = 0; n < movelist.num_moves; ) {
         if (unpack_rank(get_move_from(movelist.move[n])) == rank)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }
   }

   if (movelist.num_moves > 1 && isdigit(move_str[0])) { /* Disambiguate by rank - for pawns */
      int rank;
      sscanf(move_str, "%d", &rank);
      rank -= rank_offset; /* Xboard counts ranks from 0 for large boards */
      for (int n = 0; n < movelist.num_moves; ) {
         if (unpack_rank(get_move_from(movelist.move[n])) == rank)
            n++;
         else
            movelist.move[n] = movelist.move[--movelist.num_moves];
      }
   }

   if (movelist.num_moves > 1) { /* Promotions? These may be optional! */
      bool is_promotion = false;
      int piece = -1;

      char c = move_str[strlen(move_str)-1];
      if (c == '+')
         is_promotion = true;
      else {
         piece = pt.promotion_piece_id_from_string(move_str + strlen(move_str)-1);
         if (piece != -1) is_promotion = true;
      }

      if (is_promotion) {
         /* Filter-out non-promotion moves */
         for (int n = 0; n < movelist.num_moves; ) {
            if (is_promotion_move(movelist.move[n]))
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }

         /* Filter by piece-type if still not unique */
         if (movelist.num_moves > 1)
         for (int n = 0; n < movelist.num_moves; ) {
            if (get_move_promotion_piece(movelist.move[n]) == piece)
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }
      } else {
         /* Filter-out promotion moves */
         for (int n = 0; n < movelist.num_moves; ) {
            if (!is_promotion_move(movelist.move[n]))
               n++;
            else
               movelist.move[n] = movelist.move[--movelist.num_moves];
         }
      }
   }

   if (movelist.num_moves == 1)
      return movelist.move[0];

   return 0;
}

