void add_rule(uint32_t rule) {
   board.rule_flags |= rule;
}

void remove_rule(uint32_t rule) {
   board.rule_flags &= ~rule;
}

void set_board_size(int files, int ranks) {
   assert(files*ranks <= 8*sizeof(kind));
   initialise_square_names(files, ranks);

   bitboard_t<kind>::initialise_bitboards(files,ranks);
   movegen.initialise();
   movegen.initialise_slider_tables();

   this->ranks = ranks; 
   this->files = files; 

   initialise_base_evaluation_tables(files, ranks);
}

void remove_square(int square) {
   bitboard_t<kind> bb = ~bitboard_t<kind>::square_bitboards[square];
   int n;

   bitboard_t<kind>::board_all &= bb;
   bitboard_t<kind>::board_edge &= bb;
   bitboard_t<kind>::board_east_edge &= bb;
   bitboard_t<kind>::board_west_edge &= bb;
   bitboard_t<kind>::board_north_edge &= bb;
   bitboard_t<kind>::board_south_edge &= bb;
   bitboard_t<kind>::board_south &= bb;
   bitboard_t<kind>::board_north &= bb;
   for (n=0; n<16; n++) {
      bitboard_t<kind>::board_rank[n] &= bb;
      bitboard_t<kind>::board_file[n] &= bb;
      bitboard_t<kind>::board_northward[n] &= bb;
      bitboard_t<kind>::board_southward[n] &= bb;
   }
   for (n=0; n<32; n++) {
      bitboard_t<kind>::board_diagonal[n] &= bb;
      bitboard_t<kind>::board_antidiagonal[n] &= bb;
   }
}

void place_flag(side_t side, int square) {
   board.flag[side].set(square);
}

void remove_flag(side_t side, int square) {
   board.flag[side].reset(square);
}


