#include "san.h"
#include "squares.h"

const char *move_to_short_string(move_t move, const movelist_t *movelist, char *buffer)
{
   static char static_buffer[256];
   char *s = buffer;
   const char *gate_token = "";
   const char *token = "";
   const char *origin = "";
   char piece = ' ';
   char tp = '\0';

   if (!s) s = static_buffer;

   if (move == 0) {
      snprintf(s, sizeof static_buffer, "(pass)");
      return s;
   }

   int from = get_move_from(move);
   int to   = get_move_to(move);
   int p    = get_move_piece(move);

   if (is_castle_move(move)) {
      int f = unpack_file(to);
      if (f >= div_file)
         snprintf(s, sizeof static_buffer, "%s", kingside_castle);
      else
         snprintf(s, sizeof static_buffer, "%s", queenside_castle);
      return s;
   }

   if (is_capture_move(move)) token = "x";
   if (is_drop_move(move)) token = "@";
   if (is_promotion_move(move) || is_gate_move(move)) tp = piece_symbol_string[get_move_promotion_piece(move)];
   if (is_gate_move(move)) gate_token = "/";
   piece = piece_symbol_string[p];

   if (is_drop_move(move)) piece = piece_drop_string[p];

   if (is_pickup_move(move)) {
      piece = piece_drop_string[p];
      token = "^"; 
      to = from;
      goto disambiguous;
   }

   /* Slightly special case: pawn capture */
   if (piece == ' ' && is_capture_move(move)) {
      origin = file_names[unpack_file(from)];
   } else if (p && movelist) {
      /* The information we have now might be ambiguous - check */
      int count = 0;
      int n;
      for (n=0; n<movelist->num_moves; n++) {
         if (get_move_piece(move) == get_move_piece(movelist->move[n]) && to == get_move_to(movelist->move[n])) {
            if (is_promotion_move(move))
               count += tp == piece_symbol_string[get_move_promotion_piece(movelist->move[n])];
            else
               count++;
         }
      }
      if (count <= 1) goto disambiguous;

      /* Try to disambiguate by file */
      count = 0;
      for (n=0; n<movelist->num_moves; n++) {
         if (get_move_piece(move) == get_move_piece(movelist->move[n]) &&
             to == get_move_to(movelist->move[n]) &&
             unpack_file(from) == unpack_file(get_move_from(movelist->move[n])))
            count++;
      }
      if (count == 1) {
         origin = file_names[unpack_file(from)];
      } else if (count > 1) {
         /* Disambiguate by row */
         origin = rank_names[unpack_rank(from)];
      }
   }
disambiguous:

   snprintf(s, 15, "%c%s%s%s%s%c", piece, origin, token, square_names[to], gate_token, tp);

   return s;
}



