module Project_details
  def self.name
    'SiSU'
  end
  def self.thor
    "ruby-thor files for the installation/setup of #{name}"
  end
  def self.platform_notice
    "[#{name} is for Linux/Unix Platforms]"
  end
  def self.env
    RbConfig::CONFIG
  end
  def self.host
    env['host']
  end
  def self.dir
    def self.proj
      Project_details.name.downcase
    end
    def self.arch
      env['archdir']
    end
    def self.sitearch
      env['sitearchdir']
    end
    def self.bin
      env['bindir']
    end
    def self.lib
      env['sitelibdir']
    end
    def self.data
      env['datadir']
    end
    def self.share
      "#{env['datadir']}/sisu"
    end
    def self.conf
      env['sysconfdir']
    end
    def self.man
      env['mandir']
    end
    def self.vim
      "#{env['datadir']}/sisu/vim"
    end
    def self.out
      "#{env['localstatedir']}/#{proj}"
    end
    def self.rubylib
      env['LIBRUBYARG_SHARED']
    end
    def self.pwd
      Dir.pwd #ENV['PWD']
    end
    self
  end
  def self.version
    stamp={}
    v="#{dir.pwd}/data/sisu/version.yml"
    if File.exist?(v)
      stamp=YAML::load(File::open(v))
      stamp[:version]
    else ''
    end
  end
  def self.system_info
    ##{Project_details.platform_notice}
    puts <<-WOK
  Host
    host:             #{Project_details.host}
    arch:             #{Project_details.dir.arch}
    sitearch:         #{Project_details.dir.sitearch}
  Directories for installation
    bin:                                          #{Project_details.dir.bin}
    lib (site-ruby):                              #{Project_details.dir.lib}/#{Project_details.dir.proj}/v*
    conf [etc]:                                   #{Project_details.dir.conf}/#{Project_details.dir.proj}
    data (odf, shared images):                    #{Project_details.dir.share}
    vim  (vim syntax, highlighting, ftplugin):    #{Project_details.dir.data}/sisu/vim
    data (README, version_manifest):              #{Project_details.dir.data}/doc/#{Project_details.dir.proj}
    man (manual pages):                           #{Project_details.dir.man}
    output:                                       #{Project_details.dir.out}
      processing:                                 #{Project_details.dir.out}/processing
      www:                                        #{Project_details.dir.out}/www
    rubylib:                                      #{Project_details.dir.rubylib}

    WOK
  end
end
module Utils
  def self.answer?(ask)
    resp='redo'
    print ask + " ['yes', 'no' or 'quit']: "
    resp=File.new('/dev/tty').gets.strip #resp=gets.strip
    if    resp == 'yes'        then true
    elsif resp == 'no'         then false
    elsif resp =~/^quit|exit$/ then exit
    else                       puts "[please type: 'yes', 'no' or 'quit']"
                               answer?(ask)
    end
  end
  def self.default_notice # local help not implemented description incorrect
    ans= %{#{Project_details.thor}
    Information on alternative actions is available using:
    [if ruby-thor is installed:]
      "#{$called_as} help")
    Default action selected - "install #{Project_details.name}" proceed? }
    resp=answer?(ans)
    exit unless resp
  end
  def self.chmod_file(place)
    if place =~/\/bin/; File.chmod(0755,place)
    else                File.chmod(0644,place)
    end
  end
  def self.chmod_util(place)
    if place =~/\/bin/; chmod(0755,place)
    else                chmod(0644,place)
    end
  end
  def self.system_date
    `date "+%Y-%m-%d"`.strip
  end
  def self.system_date_stamp
    `date "+%Yw%W/%u"`.strip
  end
  def self.program_found?(prog)
    found=`which #{prog}` #`whereis #{make}`
    (found =~/bin\/#{prog}\b/) ? :true : :false
  end
end
module Version_info
  def self.contents(vi)
    <<-WOK
---
:project: #{vi[:project]}
:version: #{vi[:version]}
:date_stamp: #{vi[:date_stamp]}
:date: "#{vi[:date]}"
    WOK
  end
  module Current
    def self.yml_file_path(version)
      'data/sisu/version.yml'
    end
    def self.settings(file)
      v="#{Dir.pwd}/#{file}"
      if File.exist?(v)
        YAML::load(File::open(v))
      else ''
      end
    end
    def self.file_stable
      yml_file_path(SiSU_version_dir_stable)
    end
    def self.setting_stable
      settings(file_stable)
    end
    def self.content_stable
      Version_info.contents(setting_stable)
    end
  end
  module Next
    def self.settings(v)
      {
        project:        "#{Project_details.name}",
        version:        "#{v}",
        date:           "#{Utils.system_date}",
        date_stamp:     "#{Utils.system_date_stamp}",
      }
    end
    def self.setting_stable
      settings(SiSU_version_next_stable)
    end
    def self.content_stable
      Version_info.contents(setting_stable)
    end
  end
  module Update
    def self.version_info_update_commit(filename,vi_hash_current,vi_content_current,vi_hash_next,vi_content_next)
      ans=%{update #{Project_details.name.downcase} version info replacing:
  #{vi_hash_current.sort}
with:
  #{vi_hash_next.sort}

#{vi_content_current} becoming:
#{vi_content_next}
proceed? }
      resp=Utils.answer?(ans)
      if resp
        fn="#{Dir.pwd}/#{filename}"
        if File.writable?("#{Dir.pwd}/.")
          file_version=File.new(fn,'w+')
          file_version << vi_content_next
          file_version.close
        else
          puts %{*WARN* is the file or directory writable? could not create #{filename}}
        end
      end
    end
    def self.update_stable
      version_info_update_commit(
        Version_info::Current.file_stable,
        Version_info::Current.setting_stable,
        Version_info::Current.content_stable,
        Version_info::Next.setting_stable,
        Version_info::Next.content_stable
      )
    end
    def self.changelog_header(vi)
      <<-WOK
** #{vi[:version]}.orig.tar.xz (#{vi[:date]}:#{vi[:date_stamp].gsub(/20\d\dw/,'')})
http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=log;h=refs/tags/sisu_#{vi[:version]}
http://www.jus.uio.no/sisu/pkg/src/sisu_#{vi[:version]}.orig.tar.xz
  sisu_#{vi[:version]}.orig.tar.xz
      WOK
    end
    def self.changelog_header_stable
      changelog_header(Version_info::Current.setting_stable)
    end
  end
  self
end
module Package
  def self.sequence
    puts <<-WOK
  --update-version  # update package version
  --tag             # git tags upstream version
  --merge           # git merge upstream tag into debian/sid
  --dch             # dch create and edit
  --dch-commit      # dch commit
  --build           # git-buildpackage
  --git_push        # git push changes
  --dput            # dput package
  --reprepro_update # reprepro update
  --reprepro_push   # reprepro rsync changes
    WOK
  end
  def self.tag_upstream_and_merge_into_debian_sid
    system(%{
      git tag -a sisu_#{SiSU_VERSION} -m"SiSU #{SiSU_VERSION}" &&
      git checkout debian/sid &&
      git merge sisu_#{SiSU_VERSION}
    })

  end
  def self.tag_upstream
    system(%{
      git tag -a sisu_#{SiSU_VERSION} -m"SiSU #{SiSU_VERSION}"
    })
  end
  def self.merge_into_debian_sid
    system(%{
      git checkout debian/sid &&
      git merge sisu_#{SiSU_VERSION}
    })
  end
  def self.debian_changelog_create
    if File.directory?('./debian')
      system(%{
        git-dch -R -N #{SiSU_VERSION}-1 --full
      })
    else puts 'not in git branch: debian/sid ?'
    end
  end
  def self.debian_changelog_commit
    system(%{
      git commit -a -m"debian/changelog (#{SiSU_VERSION}-1)"
    })
  end
  def self.debian_package_build
    system(%{
      git-buildpackage --git-upstream-tag=sisu_%(version)s --git-debian-tag=debian/sisu_%(version)s --git-tag --git-keyid=#{Dev::GPGpubKey}
    })
  end
  def self.debian_package_dput
    #system(%{
    #  dput -s sisu_#{SiSU_VERSION}-1_amd64.changes
    #})
    system(%{
      dput sisu_#{SiSU_VERSION}-1_amd64.changes
    })
  end
  def self.debian_package_push
    system(%{
      git push --all &&
      git push --tags
    })
  end
  def self.reqprepro_update
    dir_repo=Pathname.new(
      "#{Dir.home}/grotto/repo/deb.repo/debian/rep"
    )
    dir_build=Pathname.new(
      "#{Dir.home}/grotto/repo/git.repo/code/builds/sisu_#{SiSU_VERSION}-1_amd64.changes"
    )
    system(%{
      cd #{dir_repo.dirname} &&
      reprepro -Vb . include unstable #{dir_build}
      cd -
    })
  end
  def self.reprepro_push
    dir_repo=Pathname.new(
      "#{Dir.home}/grotto/repo/deb.repo/debian/rep"
    )
    system(%{
      cd #{dir_repo} &&
      rsync -av --delete-after {dists,pool} sisudoc:/srv/www/sisu/archive/. &&
      rsync -av --delete-after {dists,pool} ralpha@uio:./sisu/archive/.
    })
  end
end
