# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/xml_scaffold.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: extract and print an XML rendition of document structure to screen

=end
module SiSU_XML_Scaffold_Structure_Sisu
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'ao'                                 # ao.rb
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def spaces
      Ax[:spaces]
    end
    def read
      begin
        @md,@ao_array=@particulars.md,@particulars.ao_array
        SiSU_XML_Scaffold_Structure_Sisu::Source::Scroll.new(@ao_array,@md).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    private
    class Scroll <Source
      def initialize(data='',md='')
        @data,@md=data,md
      end
      def songsheet
        @t='sisu'
        data=@data
        if @md.opt.act[:verbose_plus][:set]==:on
          structure_sisu_simple(data)
        end
        structure_build_sisu(data)
      end
      def tags
        def sisu
          [ '0',
            'A',
            'B',
            'C',
            '1',
            '2',
            '3'
          ]
        end
        self
      end
      def structure_sisu_simple(data)
        puts "\nsisu structure, heading outline --->\n\n"
        data.each_with_index do |o,i|
          if  (o.is ==:heading || o.is ==:heading_insert)
            puts "#{spaces*o.ln}<#{tags.sisu[o.ln]}>[#{o.ocn}] #{o.ln} #{o.obj}</#{tags.sisu[o.ln]}>"
          end
        end
      end
      def output(o,lev=nil,comment='')
         puts lev == (0..6) \
         ? "#{spaces*lev}<#{lev}>[#{o.ocn}] #{o.ln} #{o.obj}</#{lev}>#{comment}"
         : "<#{lev}>[#{o.ocn}] #{o.ln} #{o.obj}</#{lev}>#{comment}"
      end
      def structure_build_sisu(data)
        @s=tags.sisu
        puts "\nXML [#{@t} type] structure outline --->\n\n"
        h=[0,false,false,false]
        puts "<#{@s[0]}>"
        data.each_with_index do |o,i|
          if  (o.is ==:heading || o.is ==:heading_insert)
            structure_build_tag_close(o.ln,h)
            puts "#{spaces*o.ln}<#{@s[o.ln]}>\n#{spaces*o.ln}  [#{o.ocn}] #{o.ln} {#{o.node}}"
            case o.ln
            when 1
              h=[o.ln,true,false,false]
            when 2
              h=[o.ln,true,true,false]
            when 3
              h=[o.ln,true,true,true]
            when 4..6
              h[0]=o.ln
            end
          end
        end
        structure_build_tag_close(0,h)
      end
      def structure_build_tag_close(lev,h)
        case h[0]
        when 1
          puts "#{spaces*1}</#{@s[1]}>" if (lev <= 1) && h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 2
          puts "#{spaces*2}</#{@s[2]}>" if (lev <= 2) && h[2]
          puts "#{spaces*1}</#{@s[1]}>" if (lev <= 1) && h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 3
          puts "#{spaces*3}</#{@s[3]}>" if (lev <= 3) && h[3]
          puts "#{spaces*2}</#{@s[2]}>" if (lev <= 2) && h[2]
          puts "#{spaces*1}</#{@s[1]}>" if (lev <= 1) && h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 4
          puts "#{spaces*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{spaces*3}</#{@s[3]}>" if (lev <= 3) && h[3]
          puts "#{spaces*2}</#{@s[2]}>" if (lev <= 2) && h[2]
          puts "#{spaces*1}</#{@s[1]}>" if (lev <= 1) && h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 5
          puts "#{spaces*5}</#{@s[5]}>" if (lev <= 5)
          puts "#{spaces*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{spaces*3}</#{@s[3]}>" if (lev <= 3) && h[3]
          puts "#{spaces*2}</#{@s[2]}>" if (lev <= 2) && h[2]
          puts "#{spaces*1}</#{@s[1]}>" if (lev <= 1) && h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        when 6
          puts "#{spaces*6}</#{@s[6]}>" if (lev <= 6)
          puts "#{spaces*5}</#{@s[5]}>" if (lev <= 5)
          puts "#{spaces*4}</#{@s[4]}>" if (lev <= 4)
          puts "#{spaces*3}</#{@s[3]}>" if (lev <= 3) && h[3]
          puts "#{spaces*2}</#{@s[2]}>" if (lev <= 2) && h[2]
          puts "#{spaces*1}</#{@s[1]}>" if (lev <= 1) && h[1]
          puts "</#{@s[0]}>"         if (lev==0)
        end
      end
    end
  end
end
__END__
@s=['0',
  'A',
  'B',
  'C',
  '1',
  '2',
  '3'
]
#@t='docbook'         #@t='fictionbook'
#@s=['book',          #@s=['body',
#  'part',            #  'section',
#  'subpart N/A',     #  'section',
#  'sub-subpart N/A', #  'section',
#  'chapter',         #  'section',
#  'sect1',           #  'section',
#  'sect2'            #  'section'
#]                    #]
