# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/se_createsite.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Create_Site
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'screen_text_color'                     # screen_text_color.rb
  require_relative 'se_info_env'                           # se_info_env.rb
  begin
    require 'fileutils'
      include FileUtils::Verbose
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('fileutils NOT FOUND (LoadError)')
  end
  class CreateSite < SiSU_Info_Env::InfoEnv                # se_info_env.rb
    require_relative 'css'                                 # css.rb
      include SiSU_Style
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::InfoEnv.new
      @init=SiSU_Env::GetInit.new
      @home,@pwd=ENV['HOME'],ENV['PWD'] #@pwd=Dir.pwd
      @rc=SiSU_Env::GetInit.new.sisu_yaml.rc
      @vz=SiSU_Viz::Defaults.new
      @vz_home=SiSU_Viz::Home.new
    end
    def create_default_sisu_homepage(action=:none)
      if action==:none
        puts %{  place your homepages in directory:\n    "#{@env.path.rc}/home/*.html"\n  (no action taken)}
      else
        puts %{  place your homepages in directory:\n    "#{@env.path.rc}/home/*.html"\n  (in order to replace default sisu homepage)}
        filename_homepage=
          @env.path.webserv + '/' \
          + @env.path.base_markup_dir_stub + '/index.html'
        filename_home_toc=
          @env.path.webserv + '/' \
          + @env.path.base_markup_dir_stub + '/toc.html'
        file_homepage=File.new(filename_homepage,'w')
        file_home_toc=File.new(filename_home_toc,'w')
        file_homepage << @vz_home.homepage
        file_home_toc << @vz_home.homepage
        file_homepage.close
        file_home_toc.close
      end
    end
    def homepage
      home_pages_manually_created=Dir.glob("#{@env.path.rc}/home/*.html")
      FileUtils::mkdir_p("#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}") \
        unless FileTest.directory?("#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}")
      if home_pages_manually_created.length > 0
        home_pages_manually_created.each do |homepage|
          FileUtils.cp(homepage,"#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}")
        end
      else
        create_default_sisu_homepage(:none)
        #create_default_sisu_homepage(:default)
      end
    end
    def cp_images(src_path,dest_path)
      if FileTest.directory?(src_path)
        FileUtils::cd(src_path)
        source=Dir.glob("*.{png,jpg,gif,ico}")
        FileUtils::mkdir_p(dest_path) unless FileTest.directory?(dest_path)
        FileUtils::chmod(0755,dest_path)
        source.each do |i|
          if FileTest.file?(i)
            FileUtils::cp(i,"#{dest_path}/#{i}")
            FileUtils::chmod(0644,"#{dest_path}/#{i}")
          else STDERR.puts %{\t*WARN* did not find image - "#{i}" [#{__FILE__}:#{__LINE__}]}
          end
        end
        FileUtils::cd(@pwd)
      else STDERR.puts %{\t*WARN* did not find - #{src_path} [#{__FILE__}:#{__LINE__}]}
      end
    end
    def cp_local_images
      src=@pwd + '/_sisu/image'
      dest=
        @env.path.webserv + '/' \
        + @env.path.base_markup_dir_stub + '/_sisu/image'
      cp_images(src,dest) if FileTest.directory?(src)
    end
    def cp_external_images
      src=@env.processing_path.processing + '/' \
      + 'external_document/image'
      dest=
        @env.path.webserv + '/' \
        + @env.path.base_markup_dir_stub + '/' \
        + '_sisu/image_external'
      if FileTest.directory?(src)
        cp_images(src,dest) if FileTest.directory?(src)
      end
    end
    def cp_webserver_images
      src=@env.path.image_source
      dest_arr=[
        "#{@env.path.webserv}/_sisu/image",
        "#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}/_sisu/image",
      ]
      dest_arr.each do |dest|
        cp_images(src,dest) if FileTest.directory?(src)
      end
    end
    def cp_webserver_images_local      #this should not have been necessary
      src=@env.path.image_source
      dest=
        @env.path.webserv + '/' \
        + @env.path.base_markup_dir_stub + '/' \
        + '_sisu/image'
      cp_images(src,dest) if FileTest.directory?(src)
    end
    def cp_base_images #fix images
      src=SiSU_is[:path_base_system_data] + '/image'
      dest_arr=[
        "#{@env.path.webserv}/_sisu/image_sys",
        "#{@env.path.webserv}/#{@env.path.base_markup_dir_stub}/_sisu/image_sys"
      ]
      dest_arr.each do |dest|
        cp_images(src,dest) if FileTest.directory?(src)
      end
    end
    def cp_css
      FileUtils::mkdir_p("#{@env.path.output}/#{@env.path.style}") \
        unless FileTest.directory?("#{@env.path.output}/#{@env.path.style}")
      css_path=[
        '/etc/sisu/css',
        "#{@home}/.sisu/css",
        "#{@pwd}/_sisu/css",
      ] #BROKEN
      if defined? @rc['permission_set']['css_modify'] \
      and @rc['permission_set']['css_modify']
        SiSU_Screen::Ansi.new(
          @opt.cmd,
          "*WARN* modify is css set to: #{@rc['permission_set']['css_modify']}"
        ).warn if @opt.cmd=~/[MV]/
        css_path.each do |x|
          if FileTest.directory?(x)
            FileUtils::cd(x)
            source=Dir.glob("*.{css}")
            source.each do |i|
              if FileTest.file?(i)
                FileUtils::cp(i,"#{@env.path.output}/#{@env.path.style}")
              else STDERR.puts %{\t*WARN* did not find css - "#{i}" [#{__FILE__}:#{__LINE__}]}
              end
            end
            FileUtils::cd(@pwd)
          end
        end
      else
        SiSU_Screen::Ansi.new(
          @opt.cmd,
          "*WARN* modify css is not set or is set to: false"
        ).warn if @opt.cmd=~/[MV]/
      end
      fn_css=SiSU_Env::CSS_Default.new
      css=SiSU_Style::CSS.new
      path_style="#{@env.path.output}/#{@env.path.style}"
      FileUtils::mkdir_p(path_style) \
        unless FileTest.directory?(path_style)
      if @opt.cmd =~/C/ \
      or not FileTest.file?("#{path_style}/#{fn_css.homepage}")
        style=File.new("#{path_style}/#{fn_css.homepage}",'w')
        style << css.homepage
        style.close
      end
      if @opt.cmd =~/C/ \
      or not FileTest.file?("#{path_style}/#{fn_css.html_tables}")
        style=File.new("#{path_style}/#{fn_css.html_tables}",'w')
        style << css.html_tables
        style.close
      end
      if @opt.cmd =~/C/ \
      or not FileTest.file?("#{path_style}/#{fn_css.html}")
        style=File.new("#{path_style}/#{fn_css.html}",'w')
        style << css.html
        style.close
      end
      if @opt.cmd =~/C/ \
      or not FileTest.file?("#{path_style}/#{fn_css.harvest}")
        style=File.new("#{path_style}/#{fn_css.harvest}",'w')
        style << css.harvest
        style.close
      end
      if @opt.cmd =~/C/ \
      or (@opt.cmd =~/[x]/ \
      and not FileTest.file?("#{path_style}/#{fn_css.xml_sax}"))
        style=File.new("#{path_style}/#{fn_css.xml_sax}",'w')
        style << css.xml_sax
        style.close
      end
      if @opt.cmd =~/C/ \
      or (@opt.cmd =~/[X]/ \
      and not FileTest.file?("#{path_style}/#{fn_css.xml_dom}"))
        style=File.new("#{path_style}/#{fn_css.xml_dom}",'w')
        style << css.xml_dom
        style.close
      end
      if @opt.cmd =~/C/ \
      or (@opt.act[:xml_docbook_book][:set] == :on \
      and not FileTest.file?("#{path_style}/#{fn_css.xml_docbook}"))
        style=File.new("#{path_style}/#{fn_css.xml_docbook}",'w')
        style << css.xml_docbook
        style.close
      end
      if @opt.cmd =~/C/ \
      or (@opt.cmd =~/[b]/ \
      and not FileTest.file?("#{path_style}/#{fn_css.xhtml}"))
        style=File.new("#{path_style}/#{fn_css.xhtml}",'w')
        style << css.xhtml
        style.close
      end
    end
  end
end
__END__
