# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/dbi.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: postgresql module, dbi import frame

=end
module  SiSU_DBI                                                                 #% database building
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'db_dbi'                             # db_dbi.rb
    include SiSU_DbDBI
  require_relative 'html_lite_shared'                   # html_lite_shared.rb
    include SiSU_FormatShared
  class SQL
    def initialize(opt)
      @opt=opt
      @db=SiSU_Env::InfoDb.new
      if @opt.act[:psql][:set]==:on \
      or @opt.act[:sqlite][:set]==:on
        @sql_type=if @opt.act[:psql][:set]==:on
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.act[:maintenance][:set]==:on
          :pg
        elsif @opt.act[:psql][:set]==:on
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.act[:maintenance][:set]==:on
          :pg
        elsif @opt.act[:sqlite][:set]==:on
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.act[:maintenance][:set]==:on
          :sqlite
        elsif @opt.act[:sqlite][:set]==:on
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.act[:maintenance][:set]==:on
          :sqlite
        else
          maintenance_check(@opt,__FILE__,__LINE__) if @opt.act[:maintenance][:set]==:on
          :sqlite
        end
        if    @sql_type==:pg    then SiSU_Env::Load.new('pg',true).prog
        elsif @sql_type==:sqlite then SiSU_Env::Load.new('sqlite3',true).prog
        end
      end
    end
    def maintenance_check(opt,file,line)
      p opt.mod
      p opt.cmd
      p "at #{file} #{line}"
    end
    def read_psql
      begin
        require 'pg'
        @conn=@db.psql.conn_pg
      rescue
        if @opt.act[:psql_create][:set]==:on
          cX=SiSU_Screen::Ansi.new(@opt.act[:color_state][:set]).cX
          puts <<-WOK
manually create the database: "#{cX.green}#{@db.db}#{cX.off}" if it does not yet exist
  #{cX.yellow}createdb #{@db.db}#{cX.off}
          WOK
          #sudo su -p postgres;  createdb #{@db.db}; #[createuser?]
        end
      ensure
      end
    end
    def read_sqlite
      begin
        begin
          require 'sqlite3'
          @conn=@db.sqlite.conn_sqlite3
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('sqlite3 NOT FOUND (LoadError)')
        end
      end
    end
    def connect
      case @sql_type
      when :pg     then read_psql #read_pg
      when :sqlite then read_sqlite
      end
      SiSU_Screen::Ansi.new(
        @opt.act[:color_state][:set],
        "DBI (#{@sql_type}) #{@opt.mod}",
        @opt.fno
      ).dbi_title unless @opt.act[:quiet][:set]==:on
      begin
        SiSU_DbDBI::Case.new(@opt,@conn,@sql_type).cases
      rescue
        SiSU_Errors::Rescued.new($!,$@,@cf,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
      begin
      rescue
        connect
      end
    end
  end
end
__END__
