# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   particulars, composite information about document being processed

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/particulars.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Particulars
  require 'singleton'
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'ao'                                 # ao.rb
  class CombinedSingleton
    include Singleton
    def get_all(opt)
      set_env(opt)
      set_file(opt)
      set_md(opt)
      set_ao(opt)                #needs @md
    end
    def get_env(opt)
      set_env(opt)
    end
    def get_file(opt)
      set_file(opt)
    end
    def get_md(opt)
      set_md(opt)
    end
    def get_ao_array(opt)
      set_ao(opt)                #needs @md
    end
    def get_env_md(opt)
      set_env(opt)
      set_md(opt)
    end
    def get_idx_sst(opt)
      set_sst_idx(opt)
    end
    def get_idx_raw(opt)
      set_raw_idx(opt)
    end
    def get_idx_html(opt)
      set_html_idx(opt)
    end
    def get_idx_xhtml(opt)
      set_xhtml_idx(opt)
    end
    def get_name_tags(opt)
      set_name_tags(opt)
    end
    def get_maps(opt)
      set_nametags_map(opt)
      set_ocn_htmlseg_map(opt)
    end
    def get_map_nametags(opt)
      set_nametags_map(opt)
    end
    def get_map_ocn_htmlseg(opt)
      set_ocn_htmlseg_map(opt)
    end
    attr_accessor :opt,:md,:sst_idx,:raw_idx,:html_idx,:xhtml_idx
    def set_md(opt)
      begin
        @md=SiSU_Param::Parameters.new(opt).get
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    attr_accessor :opt,:env,:file
    def set_env(opt)
      begin
        @env=SiSU_Env::InfoEnv.new(opt.fns)
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    def set_file(opt)
      begin
        set_md(opt) unless @md
        @file=SiSU_Env::FileOp.new(@md)
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    attr_accessor :opt,:ao_array
    def set_ao(opt)
      begin
        @ao_array=SiSU_AO::Source.new(opt).get
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    def set_sst_idx(opt)
      begin
        @sst_idx=SiSU_AO::Source.new(opt).get_idx_sst
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    def set_raw_idx(opt)
      begin
        @raw_idx=SiSU_AO::Source.new(opt).get_idx_raw
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    def set_html_idx(opt)
      begin
        @html_idx=SiSU_AO::Source.new(opt).get_idx_html
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    def set_xhtml_idx(opt)
      begin
        @xhtml_idx=SiSU_AO::Source.new(opt).get_idx_xhtml
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    attr_accessor :nametags_map
    def set_nametags_map(opt)
      begin
        opt=@md ? @md : opt
        @nametags_map=SiSU_AO::Source.new(opt).get_map_nametags
        self
      rescue
        if @md
          SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.opt.fnl).location do
            __LINE__.to_s + ':' + __FILE__
          end
        else
          SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
            __LINE__.to_s + ':' + __FILE__
          end
        end
      end
    end
    attr_accessor :ocn_htmlseg_map
    def set_ocn_htmlseg_map(opt)
      begin
        @ocn_htmlseg_map=SiSU_AO::Source.new(@md).get_map_ocn_htmlseg
        self
      rescue
        SiSU_Errors::Rescued.new($!,$@,opt.cmd,opt.fnl).location do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
  end
end
__END__
consider running as separate objects
