# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/xml_docbook_book.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Docbook book XML rendition

=end
module SiSU_XML_Docbook_Book
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'ao'                                 # ao.rb
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'txt_shared'                         # txt_shared.rb
    include SiSU_TextUtils
  require_relative 'xml_shared'                         # xml_shared.rb
    include SiSU_XML_Munge
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      begin
        @md,@ao_array=@particulars.md,@particulars.ao_array
        @env=@particulars.env
        report
        SiSU_XML_Docbook_Book::Source::Scroll.new(@ao_array,@md).songsheet
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    private
    def report
      unless @opt.act[:quiet][:set]==:on
        tool=(@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? "#{@env.program.docbook_viewer} #{@md.file.output_path.xml_docbook_book.dir}/#{@md.file.base_filename.xml_docbook_book}"
        : "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'DocBook',tool).green_hi_blue
        : SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'DocBook',tool).green_title_hi
        if (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],@opt.fns,"#{@md.file.output_path.xml_docbook_book.dir}/#{@md.file.base_filename.xml_docbook_book}").flow
        end
      end
    end
    class Scroll <Source
      def initialize(data='',md='')
        @data,@md=data,md
        @trans=SiSU_XML_Munge::Trans.new(@md)
        @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(md.opt)
        @env=@particulars.env
      end
      def songsheet
        @t='sisu'
        data=@data
        if @md.opt.act[:verbose_plus][:set]==:on
          structure_collapsed(data)
        end
        #head
        #extract_endnotes
        data=markup_text(data)
        structure_build_collapsed(data)
        #tail
      end
      def space
        '  '
      end
      def tags
        # collapsed -->
        def collapsed
          %w[ 0 1 2 3 4 5 6 ]
        end
        def docbook(lc,chlv='')
          case lc
          when 1
            'book'
          when 2
            lc==chlv ? 'chapter' : 'section'
          when 3
            lc==chlv ? 'chapter' : 'section'
          when 4
            lc==chlv ? 'chapter' : 'section'
          when 5
            'section'
          when 6
            'section'
          end
        end
        self
      end
      def put(line)
        #@file_docbook.puts line                           #look into and use perhaps
        puts line if @md.opt.act[:verbose_plus][:set]==:on
      end
      def head
        <<-WOK
<?xml version="1.0" encoding="utf-8"?>
<book xmlns="http://docbook.org/ns/docbook"
  xmlns:xl="http://www.w3.org/1999/xlink"
  version="5.0">
        WOK
      end
      def markup_text(data)
        data.each_with_index do |o,i|
          if o.is ==:heading || o.is ==:para
            o=@trans.markup_docbook(o) #unless o.obj==nil
          end
        end
        data
      end
      def tail
        tail=<<-WOK
</book>
        WOK
        put(tail)
      end
      def output(o,lev=nil,comment='')
         puts lev == 0..6 \
         ? "#{space*lev}<#{lev}>[#{o.ocn}] #{o.ln} #{o.obj}</#{lev}>#{comment}"
         : "<#{lev}>[#{o.ocn}] #{o.ln} #{o.obj}</#{lev}>#{comment}"
      end
      def structure_collapsed(data)
        puts "\ncollapsed structure, heading outline --->\n\n"
        data.each_with_index do |o,i|
          if  (o.is ==:heading || o.is ==:heading_insert)
            output(o,o.lc)
          end
        end
      end
      #def chapterlevel
      #end
      def structure_build_collapsed(data)
        #output_file=@md.file.output_path.xml_docbook_book.dir + '/' + @md.file.base_filename.xml_docbook_book
        file=SiSU_Env::FileOp.new(@md)
        filename_docbook=file.write_file.xml_docbook_book
        h=0
        @chlv=chlv=0
        doc_position=:head
        filename_docbook.puts head
        data.each_with_index do |o,i|
          if (defined? o.ocn and not o.ocn.nil?)
            ocn="\n#{Dx[:ocn_o]}#{o.ocn}#{Dx[:ocn_c]}"
            id=%{ id="o#{o.ocn}" }
          else
            ocn,id='',''
          end
          if  (o.is ==:heading || o.is ==:heading_insert)
            lev=o.lc
            chlv=(o.lv.to_i == 1) \
            ? @chlv=o.lc.to_i
            : 0
            @splv=lev
            unless doc_position==:head
              filename_docbook.puts structure_build_tag_close(lev,h)
            end
            doc_position=:body_and_tail
            filename_docbook.puts  %{#{space*(lev-1)}<#{tags.docbook(lev,chlv)}>
#{space*lev}<title#{id}>
}
            filename_docbook.puts SiSU_TextUtils::Wrap.new(o.obj + ocn,80,(@splv*2+2)).line_wrap
            filename_docbook.puts %{#{space*lev}</title>}
            h=lev
          elsif (o.of ==:para or o.of ==:block)
            filename_docbook.puts "#{space*(@splv)}<para#{id}>"
            filename_docbook.puts SiSU_TextUtils::Wrap.new(o.obj + ocn,80,(@splv*2+2)).line_wrap
            filename_docbook.puts "#{space*(@splv)}</para>"
          end
        end
        filename_docbook.puts structure_build_tag_close(0,h)
        filename_docbook.close
      end
      def structure_build_tag_close(lev,h)
        x=[]
        case h
        when 1
          x << "#{space*0}</#{tags.docbook(1)}>"       if (lev <= 1)
        when 2
          x << "#{space*1}</#{tags.docbook(2,@chlv)}>" if (lev <= 2)
          x << "#{space*0}</#{tags.docbook(1)}>"       if (lev <= 1)
        when 3
          x << "#{space*2}</#{tags.docbook(3,@chlv)}>" if (lev <= 3)
          x << "#{space*1}</#{tags.docbook(2,@chlv)}>" if (lev <= 2)
          x << "#{space*0}</#{tags.docbook(1)}>"       if (lev <= 1)
        when 4
          x << "#{space*3}</#{tags.docbook(4,@chlv)}>" if (lev <= 4)
          x << "#{space*2}</#{tags.docbook(3,@chlv)}>" if (lev <= 3)
          x << "#{space*1}</#{tags.docbook(2,@chlv)}>" if (lev <= 2)
          x << "#{space*0}</#{tags.docbook(1)}>"       if (lev <= 1)
        when 5
          x << "#{space*4}</#{tags.docbook(5)}>"       if (lev <= 5)
          x << "#{space*3}</#{tags.docbook(4,@chlv)}>" if (lev <= 4)
          x << "#{space*2}</#{tags.docbook(3,@chlv)}>" if (lev <= 3)
          x << "#{space*1}</#{tags.docbook(2,@chlv)}>" if (lev <= 2)
          x << "#{space*0}</#{tags.docbook(1)}>"       if (lev <= 1)
        when 6
          x << "#{space*5}</#{tags.docbook(6)}>"       if (lev <= 6)
          x << "#{space*4}</#{tags.docbook(5)}>"       if (lev <= 5)
          x << "#{space*3}</#{tags.docbook(4,@chlv)}>" if (lev <= 4)
          x << "#{space*2}</#{tags.docbook(3,@chlv)}>" if (lev <= 3)
          x << "#{space*1}</#{tags.docbook(2,@chlv)}>" if (lev <= 2)
          x << "#{space*0}</#{tags.docbook(1)}>"       if (lev <= 1)
        end
        x.join("\n")
      end
    end
  end
end
__END__
