# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   minitoc

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/html_minitoc.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
  module SiSU_HTML_MiniToc
    require_relative 'html_tune'                        # html_tune.rb
      include SiSU_HTML_Tune
    class TocMini
      @@seg_mini=nil
      @@seg_url=''
      @@firstseg=nil
      def initialize(md,data)
        @md,@data=md,data
        @pat_strip_heading_name=/<a name="h?\d.*?">(.+?)<\/a>/
        @tell=SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set]) if @md
      end
      def songsheet
        if (@md.opt.act[:verbose][:set]==:on \
        || @md.opt.act[:verbose_plus][:set]==:on \
        || @md.opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],'Toc').txt_grey
        end
        toc=nil
        @toc=[]
        @data.each do |txt|
          if txt.is ==:heading \
          || txt.is ==:heading_insert
            txt.obj=txt.obj.gsub(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,''). #remove endnotes from toc
              gsub(/<a name="-\d+" href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;<\/a>/,'').
              gsub(@pat_strip_heading_name,'\1')
              #gsub(/(.*?)<a name="(\d+)"><\/a>(.*)/,'\1') #2002w42 altered gsub - problematic? - suspect
            toc=case txt.ln
            when 1; SiSU_HTML_MiniToc::TocMini.new(@md,txt).level_1
            when 2; SiSU_HTML_MiniToc::TocMini.new(@md,txt).level_2
            when 3; SiSU_HTML_MiniToc::TocMini.new(@md,txt).level_3
            when 4; SiSU_HTML_MiniToc::TocMini.new(@md,txt).level_4
            when 5; SiSU_HTML_MiniToc::TocMini.new(@md,txt).level_5
            when 6; SiSU_HTML_MiniToc::TocMini.new(@md,txt).level_6
            else
            end
            @toc << toc
          end
        end
        @toc
      end
    protected
      def level_concordance
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
        @@seg_mini << format_head_toc.mini_seg_concordance
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
        @@seg_mini << format_head_toc.mini_seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@d0c)
        @@seg_mini << format_head_toc.mini_concordance
      end
      def level_1
        txt=@data
        if (txt.is ==:heading \
        || txt.is ==:heading_insert) \
        && txt.ocn !=0
          txt.obj=txt.obj.gsub(@pat_strip_heading_name,'\1')
        end
        title=unless txt.obj =~/Document Information/; txt.obj
        else
          link='metadata'
          %{<b><a href="#{link}#{@md.lang_code_insert}#{Sfx[:html]}">#{txt.obj}</a></b>}
        end
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc_mini=if txt.name =~/^meta/ and txt.obj=~/Document Information/
          format_toc.mini_tail
        else format_toc.mini_lev1
        end
        toc_mini
      end
      def level_2
        txt=@data
        if (txt.is ==:heading \
        || txt.is ==:heading_insert) \
        && txt.ocn !=0
          txt.obj=txt.obj.gsub(@pat_strip_heading_name,'\1')
        end
        txt_obj={ txt: txt.obj }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc_mini=format_toc.mini_lev2
        toc_mini
      end
      def level_3
        txt=@data
        txt_obj={ txt: txt.obj }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc_mini=format_toc.mini_lev3
        toc_mini
      end
      def level_4
        txt=@data
        unless txt =~/~metadata/
          if txt.ln ==4
            fnh={
              fn: txt.name,
            }
            f=@md.file.base_filename.html_seg(fnh)
            seg_link=%{  <a href="#{f}" target="_top">
    #{txt.obj}
  </a> }
            @@seg_url=txt.name
          elsif txt.obj =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
            fn,hd=/^(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/.match(dob.obj)[1,2]
            fnh={
              fn: fn,
            }
            f=@md.file.base_filename.html_seg(fnh)
            seg_link=%{<a href="#{f}" target="_top">#{fn} #{hd}</a> }
          end
          txt_obj={ txt: seg_link }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc_mini=format_toc.mini_lev4
          toc_mini
        end
      end
      def level_5
        txt=@data
        if (txt.is ==:heading \
        || txt.is ==:heading_insert) \
        && txt.ocn !=0
          txt.obj=txt.obj.gsub(@pat_strip_heading_name,'\1')
        end
        fnh={
          fn: @@seg_url,
        }
        f=@md.file.base_filename.html_seg(fnh)
        lnk_n_txt=%{  <a href="#{f}##{txt.ocn}">
    #{txt.obj}
  </a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc_mini=format_toc.mini_lev5
        toc_mini
      end
      def level_6
        txt=@data
        if (txt.is ==:heading \
        || txt.is ==:heading_insert) \
        && txt.ocn !=0
          txt.obj=txt.obj.gsub(@pat_strip_heading_name,'\1')
        end
        fnh={
          fn: @@seg_url,
        }
        f=@md.file.base_filename.html_seg(fnh)
        lnk_n_txt=%{  <a href="#{f}##{txt.ocn}">
    #{txt.obj}
  </a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc_mini=format_toc.mini_lev6
        toc_mini
      end
    end
  end
__END__
