# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/epub_segments.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: epub segment generation, processing

=end
module SiSU_EPUB_Seg
  require_relative 'shared_xhtml'                       # shared_xhtml.rb
  require_relative 'epub'                               # epub.rb
  require_relative 'shared_metadata'                    # shared_metadata.rb
  class Output
    def initialize(md,outputfile,seg,type='')
      @md,@output_epub_cont_seg,@seg,@type=md,outputfile,seg,type
    end
    def output #CONSIDER
      if @seg[:title] =~/\S/
        filename_seg=[]
        filename_seg << @seg[:title] << @seg[:nav]
        if @type=='endnotes'
          @seg[:headings]=[] #watch
          txt_obj={ txt: 'Endnotes', ocn_display: ''}
          format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_endnotes] << @seg[:headings] << %{\n<div class="content">\n} << @seg[:endnote_all] << '</div>'
        elsif @type=='idx'
          @seg[:headings]=[]
          format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_idx] << @seg[:headings] << %{\n<div class="content">\n} << @seg[:idx] << '</div>'
        elsif @type=='metadata'
          metadata=SiSU_Metadata::Summary.new(@md).xhtml_display.metadata
          @seg[:headings]=[]
          txt_obj={ txt: 'Metadata', ocn_display: ''}
          format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_idx] << @seg[:headings] << %{\n<div class="content">\n} << metadata << '</div>'
        elsif @type=='sisu_manifest'
          env=SiSU_Env::InfoEnv.new(@md.fns)
          path_and_name,url_and_name="#{env.path.output}/#{@md.fnb}/sisu_manifest.html","#{env.url.root}/#{@md.fnb}/sisu_manifest.html"
          manifest=if FileTest.file?("#{path_and_name}")==true
            <<WOK
<p>A list of available output types may be available at the following url:</p>
<p><a href="#{url_and_name}">#{url_and_name}</a></p>
WOK
          else ''
          end
          @seg[:headings]=[]
          txt_obj={ txt: 'Manifest', ocn_display: ''}
          format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
          @seg[:headings] << format_seg.title_heading1
          filename_seg << @seg[:heading_idx] << @seg[:headings] << %{\n<div class="content">\n} << manifest << '</div>'
        else
          filename_seg << @seg[:headings] << @seg[:main] << "\n</div>\n"
        end
        filename_seg << @seg[:tail] << @seg[:nav] << @seg[:close]
        filename_seg=filename_seg.flatten.compact #watch
        filename_seg.each do |str|
          unless str =~/\A\s*\Z/
            @output_epub_cont_seg << str.strip
          end
        end
        @output_epub_cont_seg.close
      end
    end
  end
  class Seg
    @@seg,@@seg_subtoc,@@seg_endnotes,@@seg_ad={},{},{},{}
    @@seg_name,@@seg_name_xhtml=[],[]
    @@seg_url=@@fn=@@get_hash_to=@@get_hash_fn=''
    @@loop_count=@@seg_total=@@tracker=0
    @@is4=@@is3=@@is2=@@is1=0
    @@heading1=@@heading2=@@heading3=@@heading4=0
    @@seg[:headings],@@seg[:main],@@seg[:idx],@@seg[:tail],@@seg_subtoc_array,@@seg_endnotes_array,@@seg[:endnote_all]=Array.new(7){[]}
    @@seg[:heading_endnotes]=''
    @@tablehead,@@number_of_cols=0,0
    @@fns_previous=''
    attr_reader :seg_name_xhtml,:seg_name_xhtml_tracker
    def initialize(md='',data='')
      @md,@data=md,data
      @vz=SiSU_Viz::Defaults.new
      @seg_name_xhtml=@@seg_name_xhtml || nil
      @seg_name_xhtml_tracker=@@tracker || nil
      @make=SiSU_Env::ProcessingSettings.new(@md) if @md
    end
    def songsheet
      begin
        data=get_subtoc_endnotes(@data)
        data=articles(data)
        SiSU_EPUB_Seg::Seg.new.cleanup # (((( added ))))
        #### (((( END )))) ####
      rescue
        SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        @@seg_name=[]
      end
    end
  protected
    def articles(data)
      tracking,newfile=0,0
      @@is4=@@is3=@@is2=@@is1=0
      printed_endnote_seg='n'
      idx_xhtml=nil
      if @md.book_idx
        idx_xhtml=SiSU_Particulars::CombinedSingleton.instance.get_idx_xhtml(@md).xhtml_idx
        idx_xhtml.each {|x| @@seg[:idx] << x }
        @@seg[:heading_idx]=''
      end
      data.each do |dob|
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        and dob.ln==4
          @@seg_name << dob.name
          dob.name
        end
      end
      @@seg_name_xhtml=@@seg_name
      @@seg_total=@@seg_name.length
      testforartnum=@@seg_name_xhtml
      if (@md.opt.act[:verbose][:set]==:on \
      || @md.opt.act[:verbose_plus][:set]==:on \
      || @md.opt.act[:maintenance][:set]==:on)
        SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],@@seg_name.length)
      end
      SiSU_Particulars::CombinedSingleton.instance.get_map_nametags(@md).nametags_map #p map_nametags
      data.each do |dob|
        #if defined? dob.obj \
        #and dob.obj =~/href="#{Xx[:segment]}#+\S+?"/
        #  ##Consider: remove, reinstate earlier?
        #  #while dob.obj =~/href="#{Xx[:segment]}#+(\S+?)"/
        #  #  m=$1
        #  #  if map_nametags[m][:segname]
        #  #    dob.obj=dob.obj.sub(/href="#{Xx[:segment]}#+(\S+?)"/,%{href="#{map_nametags[m][:segname]}#{Sfx[:html]}#\\1"})
        #  #  else
        #  #    p "NOT FOUND name_tags: #{m}"
        #  #    dob.obj=dob.obj.sub(/href="#{Xx[:segment]}#+(\S+?)"/,%{href="#\\1"}) # not satisfactory
        #  #  end
        #  #end
        #end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        and dob.ln==4
          if dob.ocn==0
            @@heading4=dob.obj
          else @@heading4=dob.obj
          end
          @@is4=newfile=1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        and dob.ln==3
          @@heading3=dob.obj
          @@is4,@@is3=0,1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        and dob.ln==2
          @@heading2=dob.obj
          @@is4,@@is3,@@is2=0,0,1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        and dob.ln==1
          @@heading1=dob.obj
          @@is4,@@is3,@@is2,@@is1=0,0,0,1
        end
        if (@@is1 && !@@is2 && !@@is3 && !@@is4)
          if not (dob.is==:heading \
          || dob.is==:heading_insert) \
          and dob.ln==1
            $_ #; check
          end
        end
        if @@is4==1
          dir_epub_cont="#{@md.env.processing_path.epub}/#{Ep[:d_oebps]}"
          if newfile==1 \
          or dob.obj =~/^#{Mx[:br_endnotes]}|^#{Mx[:br_eof]}/
            newfile=0
            if (dob.is==:heading \
            || dob.is==:heading_insert) \
            and dob.ln==4
              if tracking != 0
                SiSU_EPUB_Seg::Seg.new(@md).tail
                segfilename="#{dir_epub_cont}/#{@@seg_name_xhtml[tracking-1]}#{Sfx[:epub_xhtml]}"
                output_epub_cont_seg=File.new(segfilename,'w') if @@seg_name_xhtml[tracking-1]
                if dob.is==:heading \
                or @@seg_name_xhtml[tracking-1] !~/endnotes|book_index|metadata/
                  SiSU_EPUB_Seg::Output.new(@md,output_epub_cont_seg,@@seg).output
                elsif dob.is==:heading_insert
                  if @@seg_name_xhtml[tracking-1]=='endnotes'
                    SiSU_EPUB_Seg::Output.new(@md,output_epub_cont_seg,@@seg,'endnotes').output
                  elsif @@seg_name_xhtml[tracking-1]=='book_index'
                    SiSU_EPUB_Seg::Output.new(@md,output_epub_cont_seg,@@seg,'idx').output
                    @@seg[:idx]=[]
                  elsif @@seg_name_xhtml[tracking-1]=='metadata' # navigation bug FIX
                    SiSU_EPUB_Seg::Output.new(@md,output_epub_cont_seg,@@seg,'metadata').output
                  else puts "#{__FILE__}::#{__LINE__}"
                  end
                else puts "#{__FILE__}::#{__LINE__}"
                end
                SiSU_EPUB_Seg::Seg.new.reinitialise
                heading_art(dob)
                head(dob)
                if @@seg_name_xhtml[tracking] =='metadata'
                  segfilename="#{dir_epub_cont}/#{@@seg_name_xhtml[tracking]}#{Sfx[:epub_xhtml]}"
                  output_epub_cont_seg=File.new(segfilename,'w')
                  SiSU_EPUB_Seg::Output.new(@md,output_epub_cont_seg,@@seg,'metadata').output
                  SiSU_EPUB_Seg::Seg.new.reinitialise #BUG navigation bug with items following metadata, and occurring before manifest, this becomes a bug ... work area for book index, FIX
                end
               #@output_epub_cont_seg.close                                         #%(((( EOF )))) -->
              end
              if tracking==0
                heading_art(dob)
                head(dob)
              end
            end
            tracking=tracking+1
          end
          if (dob.is==:heading \
          || dob.is==:heading_insert) \
          and dob.ln==4 \
          and dob.name
            @@get_hash_to=dob.name
            @@get_hash_fn=dob.name
          end
          if dob.obj.is_a?(String)
            markup(dob)
          elsif dob.obj.is_a?(Array)
            dob.obj.each do |pg|
              markup(pg)
            end
          end
          if testforartnum[tracking-1] =~/endnote/
            if printed_endnote_seg=='n'
              printed_endnote_seg='y'
            end
          end
        end
      end
      data
    end
    def heading_art(dob)
      @@seg[:title]=SiSU_EPUB_Format::HeadSeg.new(@md).head
    end
    def head(dob)
      clean=/<!.*?!>|<:.*?>$/
      @p_num ||= ''
      if @@is1==1
        if defined? @md.creator.author \
        and @md.creator.author
          @author=%{<b>#{@md.creator.author}</b>\n}
        end
        ocn=(@@heading1[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: @@heading1, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading1.gsub(clean,'')
        @@heading1=@@heading1.gsub(/#{$ep[:hsp]}<a name="-[\d*+]+" href="#_[\d*+]+">#{$ep[:hsp]}<sup>[\d*+]+<\/sup>#{$ep[:hsp]}<\/a>/,'')
      end
      if @@is2==1
        heading2=@@heading2
        ocn=(heading2[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading2, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading2.gsub(clean,'')
        @@heading2=@@heading2.gsub(/#{$ep[:hsp]}<a name="-[\d*+]+" href="#_[\d*+]+">#{$ep[:hsp]}<sup>[\d*+]+<\/sup>#{$ep[:hsp]}<\/a>/,'')
      end
      if @@is3==1
        heading3=@@heading3
        ocn=(heading3[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading3, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading3.gsub(clean,'')
        @@heading3=@@heading3.gsub(/#{$ep[:hsp]}<a name="-[\d*+]+" href="#_[\d*+]+">#{$ep[:hsp]}<sup>[\d*+]+<\/sup>#{$ep[:hsp]}<\/a>/,'')
      end
      if @@is4==1
        heading4=@@heading4
        ocn=(heading4[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading4, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
        @@seg[:headings] << format_seg.title_heading4.gsub(clean,'')
      end
      @@tracker=@@tracker+1
    end
    def markup(dob)
      @debug=[]
      if dob.is ==:heading \
      || dob.is ==:heading_insert \
      || dob.is ==:para
        #extend as necessary FIX
        @p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,dob.ocn)
      end
      sto=SiSU_EPUB_Format::FormatTextObject.new(@md,dob)
      dob_xhtml=if dob.is==:heading \
      || dob.is==:heading_insert \
      || dob.is==:para
        dob_xhtml=if dob.is==:heading \
        or dob.is==:heading_insert
          if dob.ln==4
            sto.seg_heading4 # work on see SplitTextObject
          elsif dob.ln==5
            sto.seg_heading5
          elsif dob.ln==6
            sto.seg_heading6
          end
        elsif dob.is==:para
          if dob.indent \
          and dob.hang \
          and dob.indent =~/[0-9]/ \
          and dob.hang =~/[0-9]/
            if dob.bullet_
              (dob.indent =~/[1-9]/) \
              ? sto.format('li',"i#{dob.indent}")
              : sto.format('li','bullet')
            elsif dob.indent == dob.hang
              sto.format('p',"i#{dob.indent}")
            elsif dob.indent != dob.hang
              sto.format('p',"h#{dob.hang}i#{dob.indent}")
            else sto.para
            end
          else sto.para
          end
        end
        elsif dob.is ==:block \
        || dob.is ==:group \
        || dob.is ==:alt
          sto.para #fix this should be block type specific #FIX
        elsif dob.is==:verse
          sto.verse
        elsif dob.is==:code
          sto.code
        elsif dob.is==:table
          sto.table
        elsif dob.is==:break
          sto.break
      end
      if @md.flag_separate_endnotes # may need to revisit, check
        dob.obj=dob.obj.gsub(/"\s+href="#note_ref(\d+)">/,%{" href=\"endnotes#{Sfx[:epub_xhtml]}#note_ref\\1">})       #endnote- twice #removed file type
      end
      if (dob.is ==:heading \
      || dob.is==:heading_insert \
      || dob.is==:para) \
      && (not dob.ocn or dob.ocn.to_s.empty?)
        format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,dob)
      end
      if (dob.is==:heading \
      || dob.is==:heading_insert \
      || dob.is==:para) \
      and dob.note_ #dob.obj =~/<a href="#note_ref\d+">&nbsp;<sup id=/                #endnote- note-
        format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,dob)
        dob.obj=format_seg.no_paranum
      end
      if (dob.is==:heading \
      || dob.is==:heading_insert) \
      and dob.ln==4
        @@seg[:main] <<  %{\n<div class="content">\n}
        @@seg[:main] << dob_xhtml
        if @make.build.segsubtoc?
          @@seg[:main] << @@seg_subtoc[@@get_hash_fn]                       #% insertion of sub-toc
        end
      else
        @@seg[:main] << dob_xhtml
      end
    end
    def tail
      format_head_seg=SiSU_EPUB_Format::HeadSeg.new(@md)
      if @md.flag_auto_endnotes \
      and @@seg_endnotes[@@get_hash_fn]
        @@seg[:tail] <<  %{\n<div class="content">\n<div class="endnote">\n}
        if @@seg_endnotes[@@get_hash_fn].flatten.length > 0
          @@seg[:tail] << format_head_seg.endnote_mark
          @@seg[:tail] << @@seg_endnotes[@@get_hash_fn].flatten #endnotes deposited at end of individual segments ||@|EXTRACTION OF ENDNOTES|
        end
        @@seg[:tail] << '</div>'
        @@seg[:tail] << '</div>' #this div closes div class content
      end
      @@seg[:close]=[]
      @@seg[:close] << format_head_seg.xhtml_close
    end
    def reinitialise
      @@seg[:headings],@@seg[:main],@@seg[:tail],@@seg[:credits]=Array.new(4){[]}
    end
    def cleanup
      reinitialise
      @@seg_total,@@tracker=0,0
      @@seg_endnotes,@@seg_subtoc={},{}
      @@seg_endnotes_array,@@seg_subtoc_array=[],[]
      @@seg[:endnote_all]=[]
    end
    def get_subtoc_endnotes(data) #get endnotes & sub-table of contents subtoc
      data.each do |dob|
        dob.obj=dob.obj.gsub(/<a name=\"h\d.*?\">(.+?)<\/a>/mi,'\1')
        if @md.flag_auto_endnotes
          if (dob.is==:heading \
          || dob.is==:heading_insert) \
          and dob.ln.to_s =~/^[1234]/ \
          and not @@fn.to_s.empty?
            @@seg_endnotes[@@fn]=[]
            @@seg_endnotes[@@fn] << @@seg_endnotes_array
            @@seg_endnotes_array=[] if dob.ln==4
            @@fns_previous=@md.fns if dob.ln==4 and dob.name =~/^meta/
          end
          if (dob.is==:heading \
          || dob.is==:heading_insert) \
          and dob.ln==4                                              #%  EXTRACTION OF SUB-TOCs & SEGMENT NAME, after EXTRACTION OF ENDNOTES & SUB-TOCs
            @@seg_subtoc[@@fn]=@@seg_subtoc_array
            @@seg_subtoc_array=[]
            if dob.name \
            and dob.obj
              @@fn=dob.name
            else
              @@fn=(dob.name =~/\S+/) \
              ? dob.name
              : ''
            end
          end
        end
        if dob.is==:heading \
        and dob.ln.to_s =~/^[56]/
          case dob.ln
          when 5
            format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,dob)
            subtoc=format_seg.subtoc_lev5 #keep and make available, this is the subtoc
          when 6
            format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,dob)
            subtoc=format_seg.subtoc_lev6 #keep and make available, this is the subtoc
          end
          @@seg_subtoc_array << subtoc
        end
        if @md.flag_auto_endnotes
          ast,pls='&#042;','&#043;'
          if dob.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})(?:\d|#{ast}|#{pls})+ / \
          and dob.is !=:code # endnote-
            endnote_array=[]
            if dob.obj=~/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m)
            end
            if dob.obj=~/#{Mx[:en_b_o]}#{ast}\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_b_o]}#{ast}\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            if dob.obj=~/#{Mx[:en_b_o]}#{pls}\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_b_o]}#{pls}\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            endnote_array=endnote_array.flatten #.compact #check compacting
            endnote_array.each do |note|
              note_match=note.dup
              note_match_seg=note.dup
              e_n=note_match_seg[/(?:#{Mx[:en_a_o]}(?:\d|#{ast}|#{pls})+|#{Mx[:en_b_o]}(?:#{ast}|#{pls})\d+)\s+(.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,1]
              try=e_n.split(/<br \/>/)
              try.each do |e|
                txt_obj={ txt: e }
                format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
                note_match=if e =~/#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]}/
                  format_seg.endnote_body_indent
                else format_seg.endnote_body
                end
                @@seg_endnotes_array << note_match
              end
              try.join('<br \/>')
              #% creation of separate end segment/page of all endnotes referenced back to reference segment
              m=/(?:#{Mx[:en_a_o]}(?:\d|#{ast}|#{pls})+|#{Mx[:en_b_o]}(?:#{ast}|#{pls})\d+)\s+(.+?href=")(#note_ref(?:\d|_a|_b)+".+)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/mi
              endnote_part_a=note_match_seg[m,1]
              endnote_part_b=note_match_seg[m,2]
              txt_obj={ endnote_part_a: endnote_part_a, endnote_part_b: endnote_part_b }
              format_seg=SiSU_EPUB_Format::FormatSeg.new(@md,txt_obj)
              note_match_all_seg=format_seg.endnote_seg_body(@@fn) #BUG WATCH 200408
              @@seg[:endnote_all] << note_match_all_seg
            end
            dob.obj=dob.obj.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
          end
        end
      end
    end
  end
end
__END__
