# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/dal_misc_arrange.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_DAL_MiscArrangeText
  class SI
    def initialize(md,data)
      @md,@data=md,data
    end
    def conditional_headings(para)
      para=para.gsub(/^(:?A~)\s*$/,'\1~ @title @author').                                    #conditional header
        gsub(/^((?:[1-9]|:?[A-C])~\S*)\s*$/,'\1~ [Note: heading marker::required title missing]~#')    #conditional header for incorporated document 2004w12
      if para =~/^@\S+?:/
        para=para.gsub(/^@(\S+?):(\s+|$)/,"#{Mx[:meta_o]}\\1#{Mx[:meta_c]}\\2").
          gsub(/^@(\S+?):([+-])(\s+|$)/,"#{Mx[:meta_o]}\\1\\2#{Mx[:meta_c]}\\3")
      end
      para
    end
    def code_blocks(para)
      def ticks(para)
        block_open,block_close,text=nil,nil,nil
        if para =~/\A[`]{3}\s+.+?\n.+?\n[`]{3}(?:\s+[~-][#]|\s+\~\{.+?\}\~)?\s*\Z/m
          block_open,text,block_close=/\A([`]{3}\s+.+?)\n(.+?)\n([`]{3}(\s+[~-][#]|\s+\~\{.+?\}\~)?)\s*\Z/m.match(para)[1..3]
          ((para=~/^[`]{3}\s+table(?:~h)?\s+/) \
          and (para !~/^[`]{3}\s+table(?:~h)?\s+c\d+/)) \
          ? para
          : (para=[]; para << block_open << text << block_close)
        elsif para =~/\A[`]{3}\s+.+?\n.*?\Z/m #look at, study
          block_open,text=/\A([`]{3}(?:\s+.+?))\n(.*?)\Z/m.match(para)[1,2]
          para=[]
          if not text.to_s.empty?
            para << block_open << text
          else
            para << block_open
          end
        elsif para =~/\A.+?\n[`]{3}(?:\s+[~-][#]|\s+\~\{.+?\}\~)?\s*\Z/m
          text,block_close=/\A(.+?)\n([`]{3}(?:\s+[~-][#]|\s+\~\{.+?\}\~)?)\s*\Z/m.match(para)[1,2]
          para=[]
          if not text.to_s.empty?
            para << text.to_s << block_close
          else
            para << block_close
          end
        else para
        end
        para
      end
      def curly_braces(para)
        block_open,block_close,text=nil,nil,nil
        para=if para =~/\A(?:code|poem|alt|group|block|table)\{ .+?\n.+?\n\}(?:code|poem|alt|group|block|table)(?: [~-][#])?\s*\Z/m
          block_open,text,block_close=/\A((?:code|poem|alt|group|block|table)\{ .+?)\n(.+?)\n(\}(?:code|poem|alt|group|block|table)(?: [~-][#])?)\s*\Z/m.match(para)[1..3]
          para=[]
          para << block_open << text << block_close
        elsif para =~/\A(?:code|poem|alt|group|block|table)\{ .+?\n.+?\Z/m
          block_open,text=/\A((?:code|poem|alt|group|block|table)\{ .+?)\n(.+?)\Z/m.match(para)[1,2]
          para=[]
          if not text.to_s.empty?
            para << block_open << text
          else
            para << block_open
          end
        elsif para =~/\A.+?\n\}(?:code|poem|alt|group|block|table)(?: [~-][#])?\s*\Z/m
          text,block_close=/\A(.+?)\n(\}(?:code|poem|alt|group|block|table)(?: [~-][#])?)\s*\Z/m.match(para)[1,2]
          para=[]
          if not text.to_s.empty?
            para << text.to_s << block_close
          else
            para << block_close
          end
        else para
        end
        para
      end
      para=para =~/^```/m \
      ? ticks(para)
      : para
      para=(para =~/^(?:code|poem|alt|group|block|table)\{|^\}(?:code|poem|alt|group|block|table)/m) \
      ? curly_braces(para)
      : para
    end
    def prepare_text
      data=@data
      data_new=[],[]
      if data[0] =~ /^#!\s*(?:\/usr\/bin\/env sisu|\/usr\/bin\/sisu)/ # remove bang from top #! (however file is stripped, so will be removed provided no content precedes it)
        data[0]=data[0].gsub(/^#!\s*\/usr\/bin\/sisu/,'').
          gsub(/^#!\s*\/usr\/bin\/env sisu/,'')
      end
      if data[0] =~ /^(SiSU\s+[\d.]*|sisu-[\d.]+)$/ # SiSU identifier
        data[0]=data[0].gsub(/^(SiSU\s*[\d.]*)$/,'% \1').
          gsub(/^(sisu-[\d.]+)$/,'% \1')
      end
      data.each do |para|
        para=conditional_headings(para)
        data_new << code_blocks(para)
      end
      data_new=data_new.flatten
    end
  end
end
__END__
