# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/utils.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, debug related

=end
module SiSU_Utils
  class CodeMarker
    def initialize(line,file,color=:red)
      @line,@file,@color=line.to_s,file,color
    end
    def ansi(color=nil)
      @color=color ? color : @color
      c={}
      c[:on]=case @color
      when :red;         ANSI_C[:red]
      when :green;       ANSI_C[:green]
      when :yellow;      ANSI_C[:yellow]
      when :blue;        ANSI_C[:blue]
      when :fuchsia;     ANSI_C[:fuchsia]
      when :cyan;        ANSI_C[:cyan]
      when :inv_red;     ANSI_C[:inv_red]
      when :inv_green;   ANSI_C[:inv_green]
      when :inv_yellow;  ANSI_C[:inv_yellow]
      when :inv_blue;    ANSI_C[:inv_blue]
      when :inv_fuchsia; ANSI_C[:inv_fuchsia]
      when :inv_cyan;    ANSI_C[:inv_cyan]
      when :b_red;       ANSI_C[:b_red]
      when :b_green;     ANSI_C[:b_green]
      when :b_yellow;    ANSI_C[:b_yellow]
      when :b_blue;      ANSI_C[:b_blue]
      when :b_fuchsia;   ANSI_C[:b_fuchsia]
      when :b_cyan;      ANSI_C[:b_cyan]
      else               ANSI_C[:red]
      end
      c[:off]= ANSI_C[:off]
      #ansi_color + @line.to_s + ansi_color_off + ' ' + @file.gsub(/([^\/]+$)/,"#{ansi_color}\\1#{ansi_color_off}")
      c
    end
    def set(color=nil)
      c=ansi(color)
      file,path=File.basename(@file),File.dirname(@file)
      c[:on] + @line + c[:off] + ' ' + path + '/' "#{c[:on]}#{file}#{c[:off]}"
    end
    def set_(color=nil)
      c=ansi(color)
      c[:on] + @line + c[:off] + ' ' +
        @file.gsub(/([^\/]+$)/,"#{c[:on]}\\1#{c[:off]}")
    end
  end
  class Path
    def initialize(dir=Dir.pwd)
      @dir=dir
    end
    def base_markup
      (/(\S+?)(?:\/(?:#{Px[:lng_lst_rgx]}))?$/).match(Dir.pwd)[1]
    end
    def bmd
      base_markup
    end
  end
end
__END__
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).set(:red)
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).set(:green)
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).set(:inv_red)
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:red).set
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).set
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:inv_red).set
