# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/dbi_discrete.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: postgresql module, dbi import frame

=end
module  SiSU_DBI_Discrete                               #% database building
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  require_relative 'param'                              # param.rb
    include SiSU_Param
  require_relative 'db_dbi'                             # db_dbi.rb
    include SiSU_DbDBI
  require_relative 'shared_html_lite'                   # shared_html_lite.rb
    include SiSU_FormatShared
  require 'fileutils'
    include FileUtils::Verbose
  class SQL
    def initialize(opt)
      SiSU_Env::Load.new('dbi',true).prog
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
      @md=@particulars.md
      if @opt.cmd =~/[d]/ \
      or  @opt.mod.inspect =~/--((?:sq)?lite)/
        @sql_type='sqlite'
        maintenance_check(@opt,__FILE__,__LINE__) if @opt.cmd.inspect =~/M/
      end
      @output_path=@md.file.output_path.sqlite_discrete.dir
      @filename=@md.file.base_filename.sqlite_discrete
      @file_maint=sql_maintenance_file
      @file="#{@output_path}/#{@filename}"
    end
    def build
      prepare
      create_and_populate
    end
    def maintenance_check(opt,file,line)
      p opt.mod
      p opt.cmd
      p "at #{file} #{line}"
    end
    def prepare
      if not FileTest.directory?(@output_path)
        FileUtils::mkdir_p(@output_path)
      elsif @file
        FileUtils::rm_rf(@file)
      end
    end
    def db_exist?(db,conn)
      msg=%{no connection with sqlite database established, createdb "#{db.sqlite.db}"?}
      if (not (FileTest.file?(db.sqlite.db)) \
      or FileTest.zero?(db.sqlite.db))
        puts msg
        exit
      end
      if conn.is_a?(NilClass)
        puts msg
        exit
      end
    end
    def create_and_populate
      db=SiSU_Env::DbOp.new(@md)
      conn=db.sqlite_discrete.conn_sqlite3
      sdb=SiSU_DbDBI::Create.new(@opt,conn,@file,'sqlite')
      sdb_index=SiSU_DbDBI::Index.new(@opt,conn,@file,'sqlite')
      sdb.output_dir?
      begin
        SiSU_Screen::Ansi.new(@opt.cmd,'SQLite',"[#{@opt.f_pth[:lng_is]}] #{@opt.fno}").green_title_hi unless @opt.cmd =~/q/
        sdb.create_db
        sdb.create_table.metadata_and_text
        sdb.create_table.doc_objects
        sdb.create_table.endnotes
        sdb.create_table.endnotes_asterisk
        sdb.create_table.endnotes_plus
        sdb.create_table.urls
        sdb_index.create_indexes
        db_exist?(db,conn)
        sdb_import=SiSU_DbDBI::Import.new(@opt,conn,@file_maint,'sqlite')
        sdb_import.marshal_load
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"sqlite3 #{db.sqlite.db} database?")
        tell.puts_grey if @opt.cmd =~/v/
      rescue
        SiSU_Errors::InfoError.new($!,$@,'-d').error do
          __LINE__.to_s + ':' + __FILE__
        end
        sdb.output_dir?
      end
    end
    def read_sqlite
      begin
        @conn=@db.sqlite.conn_sqlite3
      rescue
      ensure
      end
    end
    def connect
      begin
        SiSU_Screen::Ansi.new(@opt.cmd,"DBI (#{@sql_type}) #{@opt.mod}",@opt.fns).dbi_title unless @opt.cmd =~/q/
        @db.sqlite_discrete.conn_sqlite3
      rescue
        SiSU_Errors::InfoError.new($!,$@,@cf,@opt.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def populate
    end
    def sql_maintenance_file
      file=if @opt.inspect =~/M/
        if @opt.fns and not @opt.fns.empty?
          @env=SiSU_Env::InfoEnv.new(@opt.fns) if @opt.fns
          puts "\n#{@env.processing_path.sqlite}/#{@opt.fns}.sql" if @sql_type =~/sqlite/ and @opt.cmd =~/M/
          @db=SiSU_Env::InfoDb.new
          @job="sqlite3 #{@db.sqlite.db} < #{@env.processing_path.sqlite}/#{@opt.fns}.sql"
          File.new("#{@env.processing_path.sqlite}/#{@opt.fns}.sql",'w+')
        elsif @opt.fns \
        and @opt.fns.inspect =~/create/
          nil #sort variations later
        else nil
        end
      else nil
      end
      file
    end
  end
end
__END__
