# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/dal_expand_insertions.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_DAL_Insertions
  class Insertions
    def initialize(md,data)
      @md,@data=md,data
    end
    def output_filetypes_in_cmd(cmd_shortcut,lnk=nil) #make list of file types in shortcut command (as configured), e.g. when sisu -3 is used
      cf_defaults=SiSU_Env::InfoProcessingFlag.new
      cmd_list=case cmd_shortcut.inspect
      when /0/; cf_defaults.cf_0
      when /1/; cf_defaults.cf_1
      when /2/; cf_defaults.cf_2
      when /3/; cf_defaults.cf_3
      when /4/; cf_defaults.cf_4
      when /5/; cf_defaults.cf_5
      end
      file_type_names={}
      file_type_names[:gen],file_type_names[:src]=[],[]
      file_type_names[:gen] <<= if cmd_list =~ /y/ then "~^ { document manifest }#{lnk[:manifest]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /h/ then [" { html, segmented text }#{lnk[:html_toc]}"," { html, scroll, document in one }#{lnk[:html_doc]}"]
      end
      file_type_names[:gen] <<= if cmd_list =~ /e/ then [" { epub }#{lnk[:epub]}"]
      end
      file_type_names[:gen] <<= if cmd_list =~ /p/ then [" { pdf, landscape }#{lnk[:pdf_landscape]}"," { pdf, portrait }#{lnk[:pdf_portrait]}"]
      end
      file_type_names[:gen] <<= if cmd_list =~ /o/ then " { odf:odt, open document text }#{lnk[:odt]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /b/ then " { xhtml scroll }#{lnk[:xhtml]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /x/ then " { xml, sax }#{lnk[:xml_sax]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /X/ then " { xml, dom }#{lnk[:xml_dom]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /a/ then " { plain text utf-8 }#{lnk[:txt]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /g/ then 'wiki.txt'
      end
      file_type_names[:gen] <<= if cmd_list =~ /w/ then " { concordance }#{lnk[:html_concordance]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /N/ then " { dcc, document content certificate (digests) }#{lnk[:digest]}"
      end
      file_type_names[:src] <<= if source and cmd_shortcut =~ /s/ then " { markup source text }#{lnk[:source]}"
      end
      file_type_names[:src] <<= if cmd_shortcut =~ /S/ then " { markup source (zipped) pod }#{lnk[:sisupod]}"
      end
      file_type_names[:gen]=file_type_names[:gen].flatten
      file_type_names[:src]=file_type_names[:src].flatten
      file_type_names
    end
    def by_language(linked_doc,lng,src=nil)
      @linked_doc,@lng,@src=linked_doc,lng,src
      @base_path="#{@md.file.output_path.base.url}/#{@lng}"
      def manifest
        "#{@base_path}/manifest/#{@linked_doc}.html"
      end
      def html_toc
        "#{@base_path}/html/#{@linked_doc}.html"
      end
      def html_doc
        "#{@base_path}/html/#{@linked_doc}.html"
      end
      def html_concordance
        "#{@base_path}/html/#{@linked_doc}.html"
      end
      def epub
        "#{@base_path}/epub/#{@linked_doc}.epub"
      end
      def pdf_landscape
        "#{@base_path}/pdf/#{@linked_doc}.pdf"
      end
      def pdf_portrait
        "#{@base_path}/pdf/#{@linked_doc}.pdf"
      end
      def odt
        "#{@base_path}/odt/#{@linked_doc}.odt"
      end
      def xhtml
        "#{@base_path}/xhtml/#{@linked_doc}.xhtml"
      end
      def xml_sax
        "#{@base_path}/xml/#{@linked_doc}.xml"
      end
      def xml_dom
        "#{@base_path}/xml/#{@linked_doc}.xml"
      end
      def txt
        "#{@base_path}/txt/#{@linked_doc}.txt"
      end
      def digest
        "#{@base_path}/digest/#{@linked_doc}.txt"
      end
      def source
        "#{@base_path}/src/#{@src}"
      end
      def sisupod
        "#{@base_path}/pod/#{@src}.zip"
      end
      self
    end
    def by_filetype(linked_doc,lng,src=nil)
      @linked_doc,@lng,@src=linked_doc,lng,src
      @base_path="#{@md.file.output_path.base.url}"
      def manifest
        "#{@base_path}/manifest/#{@linked_doc}.#{@lng}.html"
      end
      def html_toc
        "#{@base_path}/html/#{@linked_doc}.#{@lng}.html"
      end
      def html_doc
        "#{@base_path}/html/#{@linked_doc}.#{@lng}.html"
      end
      def html_concordance
        "#{@base_path}/html/#{@linked_doc}.#{@lng}.html"
      end
      def epub
        "#{@base_path}/epub/#{@linked_doc}.#{@lng}.epub"
      end
      def pdf_landscape
        "#{@base_path}/pdf/#{@linked_doc}.#{@lng}.pdf"
      end
      def pdf_portrait
        "#{@base_path}/pdf/#{@linked_doc}.#{@lng}.pdf"
      end
      def odt
        "#{@base_path}/odt/#{@linked_doc}.#{@lng}.odt"
      end
      def xhtml
        "#{@base_path}/xhtml/#{@linked_doc}.#{@lng}.xhtml"
      end
      def xml_sax
        "#{@base_path}/xml_sax/#{@linked_doc}.#{@lng}.xml"
      end
      def xml_dom
        "#{@base_path}/xml_dom/#{@linked_doc}.#{@lng}.xml"
      end
      def txt
        "#{@base_path}/txt/#{@linked_doc}.#{@lng}.txt"
      end
      def digest
        "#{@base_path}/digest/#{@linked_doc}.#{@lng}.txt"
      end
      def source
        "#{@base_path}/src/#{@src}"
      end
      def sisupod
        "#{@base_path}/pod/#{@src}.zip"
      end
      self
    end
    def by_filename(linked_doc,lng,src=nil)
      @linked_doc,@lng,@src=linked_doc,lng,src
      @base_path="#{@md.file.output_path.base.url}/#{@linked_doc}"
      def manifest
        "#{@base_path}/sisu_manifest.#{@lng}.html"
      end
      def html_toc
        "#{@base_path}/toc.#{@lng}.html"
      end
      def html_doc
        "#{@base_path}/scroll.#{@lng}.html"
      end
      def html_concordance
        "#{@base_path}/concordance.#{@lng}.html"
      end
      def epub
        "#{@base_path}/epub/#{@linked_doc}.#{@lng}.epub"
      end
      def pdf_landscape
        "#{@base_path}/landscape.#{@lng}.a4.pdf"
      end
      def pdf_portrait
        "#{@base_path}/portrait.#{@lng}.a4.pdf"
      end
      def odt
        "#{@base_path}/opendocument.#{@lng}.odt"
      end
      def xhtml
        "#{@base_path}/scroll.#{@lng}.xhtml"
      end
      def xml_sax
        "#{@base_path}/scroll.#{@lng}.sax.xml"
      end
      def xml_dom
        "#{@base_path}/scroll.#{@lng}.dom.xml"
      end
      def txt
        "#{@base_path}/plain.#{@lng}.txt"
      end
      def digest
        "#{@base_path}/digest.#{@lng}.txt"
      end
      def source
        "#{@base_path}/#{@src}"
      end
      def sisupod
        "#{@base_path}/#{@src}.zip"
      end
      self
    end
    def expand_insertions?
      data=@data
      tuned_file,tuned_file_tmp=[],[]
      codeblock_=false
      data.each do |para|
        codeblock_=if para =~/^code\{/
          true
        elsif para =~/^\}code/
          false
        else codeblock_
        end
        if para !~/^%+\s/ \
        and not codeblock_ \
        and para =~/\{(?:~\^\s+)?(.+?)\s\[(?:\d(?:[sS]*))\]\}(?:\.\.\/\S+?\/|\S+?\.ss[tm]\b)/
          manifest=nil
          @u=SiSU_Env::InfoEnv.new.url
          if defined? @u.remote
            if /(?<m_pre>.+?)\{(?<m_txt>.+?)\s\[(?<m_cmd>\d[sS]*)\]\}(?<m_source>(?<m_linked_doc>\S+?)\.ss[tm]\b)(?<m_note>.*)/m =~ para
              m_pre=m_pre.strip
            elsif /\{(?<m_txt>.+?)\s\[(?<m_cmd>\d[sS]*)\]\}(?<m_source>(?<m_linked_doc>\S+?)\.ss[tm]\b)(?<m_note>.*)/m =~ para
            end
            if m_linked_doc =~ /(\S+?)\/(\S+)/
              m_linked_doc,m_linked_doc_lang=$1,$2
            else
              m_linked_doc,m_linked_doc_lang=m_linked_doc,@md.opt.lng_base
            end
          else
            puts "error, does currently support relative paths (reltive paths were removed, as had problems for citation, and was not suited to all output types should possibly reconsider) #{__FILE__} #{__LINE__}"
            if /\{(?:~\^\s+)?(?<m_txt>.+?)\s\[(?<m_cmd>\d[sS]*)\]\}\.\.\/(?<m_linked_doc>\S+?)\/(?<m_note>\s+#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]})?/ =~ para
            end
          end
          lnk={}
          case @md.opt.dir_structure_by
          when :language
            lnk={
              manifest:         by_language(m_linked_doc,m_linked_doc_lang).manifest,
              html_toc:         by_language(m_linked_doc,m_linked_doc_lang).html_toc,
              html_doc:         by_language(m_linked_doc,m_linked_doc_lang).html_doc,
              epub:             by_language(m_linked_doc,m_linked_doc_lang).epub,
              pdf_landscape:    by_language(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              pdf_portrait:     by_language(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              odt:              by_language(m_linked_doc,m_linked_doc_lang).odt,
              xhtml:            by_language(m_linked_doc,m_linked_doc_lang).xhtml,
              xml_sax:          by_language(m_linked_doc,m_linked_doc_lang).xml_sax,
              xml_dom:          by_language(m_linked_doc,m_linked_doc_lang).xml_dom,
              txt:              by_language(m_linked_doc,m_linked_doc_lang).txt,
              html_concordance: by_language(m_linked_doc,m_linked_doc_lang).html_concordance,
              digest:           by_language(m_linked_doc,m_linked_doc_lang).digest,
              sisupod:          by_language(m_linked_doc,m_linked_doc_lang,source).sisupod,
              source:           by_language(m_linked_doc,m_linked_doc_lang,source).source,
            }
          when :filetype
            lnk={
              manifest:         by_filetype(m_linked_doc,m_linked_doc_lang).manifest,
              html_toc:         by_filetype(m_linked_doc,m_linked_doc_lang).html_toc,
              html_doc:         by_filetype(m_linked_doc,m_linked_doc_lang).html_doc,
              epub:             by_filetype(m_linked_doc,m_linked_doc_lang).epub,
              pdf_landscape:    by_filetype(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              pdf_portrait:     by_filetype(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              odt:              by_filetype(m_linked_doc,m_linked_doc_lang).odt,
              xhtml:            by_filetype(m_linked_doc,m_linked_doc_lang).xhtml,
              xml_sax:          by_filetype(m_linked_doc,m_linked_doc_lang).xml_sax,
              xml_dom:          by_filetype(m_linked_doc,m_linked_doc_lang).xml_dom,
              txt:              by_filetype(m_linked_doc,m_linked_doc_lang).txt,
              html_concordance: by_filetype(m_linked_doc,m_linked_doc_lang).html_concordance,
              digest:           by_filetype(m_linked_doc,m_linked_doc_lang).digest,
              sisupod:          by_filetype(m_linked_doc,m_linked_doc_lang,source).sisupod,
              source:           by_filetype(m_linked_doc,m_linked_doc_lang,source).source,
            }
          else
            lnk={
              manifest:         by_filename(m_linked_doc,m_linked_doc_lang).manifest,
              html_toc:         by_filename(m_linked_doc,m_linked_doc_lang).html_toc,
              html_doc:         by_filename(m_linked_doc,m_linked_doc_lang).html_doc,
              epub:             by_filename(m_linked_doc,m_linked_doc_lang).epub,
              pdf_landscape:    by_filename(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              pdf_portrait:     by_filename(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              odt:              by_filename(m_linked_doc,m_linked_doc_lang).odt,
              xhtml:            by_filename(m_linked_doc,m_linked_doc_lang).xhtml,
              xml_sax:          by_filename(m_linked_doc,m_linked_doc_lang).xml_sax,
              xml_dom:          by_filename(m_linked_doc,m_linked_doc_lang).xml_dom,
              txt:              by_filename(m_linked_doc,m_linked_doc_lang).txt,
              html_concordance: by_filename(m_linked_doc,m_linked_doc_lang).html_concordance,
              digest:           by_filename(m_linked_doc,m_linked_doc_lang).digest,
              sisupod:          by_filename(m_linked_doc,m_linked_doc_lang,source).sisupod,
              source:           by_filename(m_linked_doc,m_linked_doc_lang,source).source,
            }
          end
          linked_title="#{m_pre}{#{m_txt} }#{lnk[:manifest]}#{m_note}\n\n"
          tuned_file_tmp << linked_title
          output_filetypes=output_filetypes_in_cmd(cmd,lnk)
          output_filetypes[:gen].each do |o_f|
            describe = o_f
            if describe
              tuned_file_tmp << if @u.remote #to double space <:br> at beginning of entry
                "#{Mx[:nbsp]*4} #{describe} "
              else # remove ...
                "[provide document placement host location]"
              end
            end
          end
          output_filetypes[:src].each do |o_f|
            describe = o_f
            if describe
              tuned_file_tmp << if @u.remote
                "#{Mx[:nbsp]*4} #{describe} "
              else
                "[provide document placement host location]"
              end
            end
          end
          tuned_file << 'group{' << tuned_file_tmp.join("\n") << '}group'
          tuned_file_tmp=[]
        else tuned_file << para
        end
      end
      tuned_file
    end
  end
end
__END__
