# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/param_identify_markup.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: A conversion script for canned substitutions, a fairly generic
    simple tool that can be used to store other canned conversions, used here for
    altering SiSU markup

=end
module SiSU_MarkupType
  class MarkupIdentify
    @@version={}
    @@fns,@@version[:determined],@@version[:declared],@@declared_doc_type='','','','[text?]'
    attr_accessor :version,:declared_doc_type
    def initialize(content,opt)
      @cont,@opt=content,opt
    end
    def identify
      @version,@declared_doc_type=@@version,@@declared_doc_type
      if @opt.fns != @@fns
        if @cont[0] =~ /^(?:%\s+)?SiSU\s+(text|master|insert)\s+([0-9](?:\.[0-9]+){1,2})/ \
        or @cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @declared_doc_type,@version[:declared]=$1,$2
        elsif @cont[0] =~ /^(?:%\s+)?SiSU\s+([0-9](?:\.[0-9]+){1,2})/ \
        or @cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @version[:declared]=$1
        end
        @flag_2_0,@flag_66,@flag_57,@flag_38=false,false,false,false
        @cont.each_with_index do |y,i|
          if y =~/^@make:|^@classify|^\s\s?:\S+?:\s+\S/
            version=2.0.to_f
            @version[:determined]=version
            @flag_2_0=true
            break
          end
          unless @flag_38
            if y =~/^:?A~/
              version=0.38.to_f
              @version[:determined]=version
              @flag_38=true
            end
          end
          if @flag_38
            if @flag_69 \
            or y =~/^=\{.+?\}\s*$/
              version=0.69.to_f
              @flag_69=true
              @version[:determined]=version
              break
            end
            if @flag_66 \
            or y =~/[:;]\{.+?\}[:;][a-z+]/
              version=0.66.to_f
              @flag_66=true
              @version[:determined]=version
              break
            end
          end
        end
        @flag_57,@flag_38=false,false
        unless @flag_2_0 \
        or @flag_66 \
        or @flag_69
          @cont.each_with_index do |y,i|
            if @flag_57 \
            or y =~/^:?A~\?? @title/
              @version[:determined]=0.57.to_f
              @flag_57=true
              break
            end
            if @flag_38 \
            or y =~/^:?A~/
              @version[:determined]=0.38.to_f
              @flag_38=true
              break if i >= 200
              if y =~ /(?:~{\*+|~\[\*|~\[\+)\s/
                @version[:determined]=0.42 #0.38 can safely be treated as 0.42
                break
              end
            end
            if y =~/^0~/ \
            and not @flag_38
              @version[:determined]=0.16.to_f
              break
            end
          end
        end
        @@fns=@opt.fns
        @@version,@@declared_doc_type=@version,@declared_doc_type
      end
      self
    end
    def markup_version?
      def determined
        identify.version[:determined].to_f
      end
      def series
        s=case identify.version[:determined].to_s
        when /^[01]\./; '1.0'
        when /^[2]\./; '2.0'
        else '2.0'
        end
        "series #{s}"
      end
      def declared
        identify.version[:declared].to_f
      end
      self
    end
  end
end
__END__
