# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/epub_tune.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: epub generation, epub pre-processing

=end
require_relative 'param'
module SiSU_EPUB_Tune
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  require_relative 'epub_format'                        # epub_format.rb #watch
  @@line_mode=''
  @@endnote_array=[]
  @@endnote_call_counter=1
  @@table_align='<table summary='' width="96%" border="0" bgcolor="white" cellpadding="0" col="3">
<tr ...><td width="2%" align="right">
&nbsp\;</td>
<td width="94%" valign="top" align="justify">'
  @@table_align_close='</td>
<td width="4%" align="right" valign="top">
<font size="1" color="#777777">
&nbsp;&nbsp;&nbsp;</font> </td></tr></table>'
  @@counter,@@column,@columns=0,0,0
  class Output
    def initialize(data,md)
      @data,@md=data,md
      @file=SiSU_Env::FileOp.new(@md)
      @cX=SiSU_Screen::Ansi.new(@md.opt.cmd).cX
    end
    def hard_output
      @filename_tune=@file.write_file_processing.html_tune
      data=[]
      @data.each {|x| x.obj.strip; data << x if not x.obj.empty?} #1.9 array?
      data.each do |dob|
        @filename_tune.puts dob, "\n" #check
      end
    end
    def marshal
      File.open(@file.marshal.html_tune,'w') {|f| Marshal.dump(@data.to_a,f)}
    end
  end
  class CleanXHTML
    def initialize(html='')
      @html=html
    end
    def clean
      html=@html
      str=if html.is_a?(String)
        html
      else html.obj
      end
      str=str.gsub(/#{Mx[:gl_o]}(#[0-9]{3})#{Mx[:gl_c]}/u,'&\1;').
        gsub(/#{Mx[:gl_o]}#([a-z]{2,4})#{Mx[:gl_c]}/u,'&\1;').
        gsub(/<br>/u,'<br />').
        gsub(/#{Mx[:nbsp]}/u,$ep[:hsp])
    end
  end
  class Tune
    def initialize(data,md)
      @data,@md=data,md
      @vz=SiSU_Viz::Defaults.new
      @env=SiSU_Env::InfoEnv.new(@md.fns)
      @sys=SiSU_Env::SystemCall.new
      @env=SiSU_Env::InfoEnv.new(@md.fns)
      @brace_url=SiSU_Viz::Defaults.new.url_decoration
    end
    def songsheet
      begin
        @cX=SiSU_Screen::Ansi.new(@md.opt.cmd).cX
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Tune').txt_grey if @md.opt.cmd =~/[MVv]/
        data=SiSU_EPUB_Tune::Tune.new(@data,@md).amp_angle_brackets
        data=SiSU_EPUB_Tune::Tune.new(data,@md).endnotes_html
        data=SiSU_EPUB_Tune::Tune.new(data,@md).url_markup
        data=SiSU_EPUB_Tune::Tune.new(data,@md).markup
        if @md.opt.cmd =~/M/  #Hard Output Tune Optional on/off here
          data=SiSU_EPUB_Tune::Output.new(data,@md).hard_output
          SiSU_EPUB_Tune::Output.new(data,@md).marshal
        end
        SiSU_EPUB_Tune::Tune.new(@data,@md).output
      rescue
        SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def markup
      @tuned_file=[]
      @data.each do |dob|
        dob.obj=dob.obj.gsub(/#{Mx[:mk_o]}#([a-zA-Z]+)#{Mx[:mk_c]}/,'&\1;').
          gsub(/#{Mx[:mk_o]}(#[0-9]+)#{Mx[:mk_c]}/,'&\1;')
        dob.obj=dob.obj.gsub(/#{Mx[:br_line]}|#{Mx[:br_nl]}/,'<br />') unless dob.is==:table
        dob.obj=dob.obj.gsub(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'<b>\1</b>').
          gsub(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'<i>\1</i>').
          gsub(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'<u>\1</u>').
          gsub(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'<sup>\1</sup>').
          gsub(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'<sub>\1</sub>').
          gsub(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'<ins>\1</ins>').
          gsub(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'<cite>\1</cite>').
          gsub(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>').
          gsub(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,'<tt>\1</tt>'). # tt, kbd
          gsub(/#{Mx[:mk_o]}:name#(\S+?)#{Mx[:mk_c]}/,'').
          gsub(/#{Mx[:gl_bullet]}/m,"●#{$ep[:hsp]*2}").
          gsub(/#{Dx[:url_o]}/,Dx[:url_o_xml]).gsub(/#{Dx[:url_c]}/,Dx[:url_o_xml]).
          gsub(/#{Mx[:nbsp]}/,$ep[:hsp]).
          gsub(/<(p|br)>/,'<\1 />')
        dob.obj=SiSU_EPUB_Tune::CleanXHTML.new(dob.obj).clean
        @tuned_file << dob
      end
    end
    def urls(data)
      @words=[]
      map_nametags=SiSU_Particulars::CombinedSingleton.instance.get_map_nametags(@md).nametags_map #p map_nametags
      data.each do |word|
        @words << if word=~/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)/
          http_=true
          if word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
            m,u=/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/.match(word).captures
          elsif word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/
            http_=false
            m,u=/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:rel_o]}(\S+?)#{Mx[:rel_c]}/.match(word).captures
          elsif word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}image/
            m,u=/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}(image)/.match(word).captures
          end
          case m
          when /\.png|\.jpg|\.gif|c=|\s\d+x\d+/
            w,h=/\s(\d+)x(\d+)/.match(m).captures if m =~/\s\d+x\d+/
            w=%{width="#{w}"} if w
            h=%{height="#{h}"} if h
            c=m[/"(.+?)"/m,1]
            caption=%{<br /><p class="caption">#{c}</p>} if c
            png=m.scan(/\S+/)[0]
            image_path=@md.file.output_path.epub.rel_image #image_path=@env.url.images_epub
            ins=if u \
            and u.strip !~/^image$/
              %{<a href="#{u}"><img src="#{image_path}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0" /></a>#{caption}}
            else %{<img src="#{image_path}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0" />#{caption}}
            end
            word=word.gsub(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/,ins)
          else
            link=m[/(.+)/m]
            png=m.scan(/\S+/)[0].strip
            link=link.strip
            u=u.sub(/^#*/,'') #make neater
            if map_nametags[u] \
            and map_nametags[u][:segname]
              u=unless http_
                u=if u=~/^\d+$/
                  u.gsub(/^(\d+)$/,"#{map_nametags[u][:segname]}#{Sfx[:xhtml]}#o\\1") if u !~/\//
                else
                  u.gsub(/(\S+)/,"#{map_nametags[u][:segname]}#{Sfx[:xhtml]}#\\1") if u !~/\//
                end
              else u
              end
            elsif u =~/^:/
              u=u.gsub(/^:/,"#{@env.url.root}/")
            elsif u =~/^\.\.\//
              u=u.gsub(/^\.\.\//,"#{@env.url.root}/")
            elsif u =~/https?:\/\//
            else p "NOT FOUND name_tags: #{u}"
            end
            ins=%{<a href="#{u}">#{link}</a>}
            word=word.gsub(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/,ins).
              gsub(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/,ins)
          end
          word
        else word
        end
        word
      end
      @words=@words.join(' ')
    end
    def url_markup
      data=@data
      @tuned_file=[]
      data.each do |dob|
        unless dob.is==:code
          if dob.obj =~/<::\s+/ #watch
            dob.obj=dob.obj.gsub(/<::\s+(\S+?)\s+!>/,
              %{<img src="#{@env.url.images_epub}/c_\\1.png" alt="\\1" width="14" height="14" align="bottom" border="0" />})
          end
          if dob.obj =~/<:image\s+/
            dob.obj=dob.obj.gsub(/<:image\s+(http\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+>/,
                %{<a href="\\1"><img src="#{@env.url.images_epub}/\\2" \\3 \\4 naturalsizeflag="0" align="bottom" border="0" /></a>}).
              gsub(/<:image\s+(http\S+)\s+(\S+)\s+>/,
                %{<a href="\\1"><img src="#{@env.url.images_epub}/\\2" naturalsizeflag="0" align="bottom" border="0" /></a>}).
              gsub(/<:image\s+(\S+)\s+(\S+)\s+(\S+)\s+>/,
                %{<img src="#{@env.url.images_epub}/\\1" \\2 \\3 naturalsizeflag="0" align="bottom" border="0" />}).
              gsub(/<:image\s+(\S+)\s+>/,
                %{<img src="#{@env.url.images_epub}/\\1" naturalsizeflag="0" align="bottom" border="0" />})
          end
          if dob.obj =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)/
            @word_mode=dob.obj.scan(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}|image)[()\[\]]*[,.;:!?'"]{0,2}|(?:#{Mx[:gl_o]}\S+?#{Mx[:gl_c]})+|[^#{Mx[:lnk_o]}#{Mx[:lnk_c]}]+/mu)
            words=urls(@word_mode)
            dob.obj=dob.obj.gsub(/.+/m,words)
          end
          dob.obj=dob.obj.gsub(/\\copyright/i,%{<sup>&copy;</sup>})
          dob.obj=if (dob.obj !~/\<:ad\s+\.\.\//)
            dob.obj.gsub(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*!\>/,
              %{\n<center><a href="http:\/\/\\1" target="external"><img src="#{@env.url.images_epub}/\\2" alt="\\3" /></a></center>\n})
          else
            dob.obj.gsub(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*\>/,
              %{\n<center><a href="\\1" target="_top"><img src="#{@env.url.images_epub}/\\2" alt="\\3" /></a></center>\n})
          end
          dob.obj=dob.obj.gsub(/!pick/,%{<img border="0" height="15" width="15" src="#{@env.url.images_epub}/#{@vz.icon_choice}" alt="stellar" />}).
            gsub(/!new/,%{#{$ep[:hsp]}<img border="0" height="15" width="15" src="#{@env.url.images_epub}/#{@vz.icon_new}" alt="new" />}).
            gsub(/<:h(.{1,7}?)>/,'<a href="#h\1">\1</a>').
            gsub(/<:to(\d{1,7}?)>/,%{<a href="#to\\1">to#{$ep[:hsp]}\{#{$ep[:hsp]}\\1#{$ep[:hsp]}\}</a> }).
            gsub(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,'<a href="\1" target="_top">\1</a>'). #http ftp matches escaped, no decoration
            gsub(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,%{#{@brace_url.xml_open}<a href="mailto:\\1">\\1</a>#{@brace_url.xml_close}}).
            gsub(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,%{#{@brace_url.xml_open}<a href="\\1" target="_top">\\1</a>#{@brace_url.xml_close}}) #http ftp matches with decoration
          if dob.obj =~/..\/\S+/ \
          and dob.obj !~/(\"..\/\S+?\"|>\s*..\/\S+<)/
            dob.obj=dob.obj.gsub(/(\.\.\/\S+)/,'<a href="\1">\1</a>')
          end
          dob.obj=dob.obj.gsub(/<a href="\.\.\//,%{<a href="#{@vz.url_site}/})
        else
          dob.obj=dob.obj.gsub(/</m,'&lt;').gsub(/>/m,'&gt;')
        end
        @tuned_file << dob
      end
    end
    def amp_angle_brackets
      data,data_new=@data,[]
      data.each do |dob|
        dob.obj=dob.obj.
          gsub(/&/u,'&amp;').
          gsub(/</u,'&lt;').gsub(/>/u,'&gt;')
        data_new << dob
      end
      data_new
    end
    def endnotes_html
      data=@data
      @tuned_file=[]
      a,s='_a','_s'
      ast,pls='&#042;','&#043;'
      data.each do |dob|
        unless dob.is ==:code
          dob.obj=dob.obj.gsub(/(#{Mx[:en_a_o]}|#{Mx[:en_b_o]})(\d+)\s+(.+?)(#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/,
              %{#{Mx[:nbsp]}<a href="#note\\2">#{Mx[:nbsp]}<sup id="note_ref\\2">\\2</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
              %{\\1\\2 <a href="#note_ref\\2">#{Mx[:nbsp]}<sup id="note\\2">\\2.</sup></a> \\3 \\4}). #endnote- note- (careful may have switched)
            gsub(/(#{Mx[:en_b_o]})[*](\d+)\s+(.+?)(#{Mx[:en_b_c]})/,
              %{#{Mx[:nbsp]}<a href="#note_astx\\2">#{Mx[:nbsp]}<sup id="note_ref_astx\\2">#{ast}\\2</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
              %{\\1#{ast}\\2 <a href="#note_ref_astx\\2">#{Mx[:nbsp]}<sup id="note_astx\\2">#{ast}\\2.</sup></a> \\3 \\4}). #endnote- note- (careful may have switched)
            gsub(/(#{Mx[:en_b_o]})[+](\d+)\s+(.+?)(#{Mx[:en_b_c]})/,
              %{#{Mx[:nbsp]}<a href="#note_plus\\2">#{Mx[:nbsp]}<sup id="note_ref_plus\\2">#{pls}\\2</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
              %{\\1#{pls}\\2 <a href="#note_ref_plus\\2">#{Mx[:nbsp]}<sup id="note_plus\\2">#{pls}\\2.</sup></a> \\3 \\4}) #endnote- note- (careful may have switched) # double-check there may here be a bug
          if dob.obj =~/#{Mx[:en_a_o]}([*+]+)\s+.+?#{Mx[:en_a_c]}/
            m=$1.length.to_i
            dob.obj=dob.obj.gsub(/(#{Mx[:en_a_o]})[*]+\s+(.+?)(#{Mx[:en_a_c]})/,
                %{#{Mx[:nbsp]}<a href="#note#{a*m}">#{Mx[:nbsp]}<sup id="note_ref#{a*m}">#{ast*m}</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
                %{\\1#{ast*m} <a href="#note_ref#{a*m}">#{Mx[:nbsp]}<sup id="note#{a*m}">#{ast*m}</sup></a> \\2 \\3}). #endnote- note- (careful may have switched)
              gsub(/(#{Mx[:en_a_o]})([+]+)\s+(.+?)(#{Mx[:en_a_c]})/,
                %{#{Mx[:nbsp]}<a href="#note#{s*m}">#{Mx[:nbsp]}<sup id="note_ref#{s*m}">#{pls*m}</sup>#{Mx[:nbsp]}</a> } +  #note- endnote-
                %{\\1#{pls*m} <a href="#note_ref#{s*m}">#{Mx[:nbsp]}<sup id="note#{s*m}">#{pls*m}</sup></a> \\2 \\3}) #endnote- note- (careful may have switched)
          end
        end
        @tuned_file << dob
      end
    end
    def output
      data=@data
      @tuned_file=[]
      data.each do |dob|
        dob.obj=dob.obj.strip.chomp
        @tuned_file << dob
      end
      @tuned_file << "\n<EOF>" if (@md.fns =~/\.sst0/) #remove
      @tuned_file
    end
  end
end
__END__
