# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/db_select.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DbSelect
  class Case
    def initialize(opt,conn='',sql_type='pg')
      @opt,@conn,@sql_type=opt,conn,sql_type
      @db=SiSU_Env::InfoDb.new
      @file_maint=sql_maintenance_file
      @sdb=SiSU_DbDBI::Create.new(@opt,@conn,@file_maint,@sql_type)      # db_dbi.rb
      @sdb_index=SiSU_DbDBI::Index.new(@opt,@conn,@file_maint,@sql_type) # db_dbi.rb
      @sdb_no=SiSU_DbDBI::Drop.new(@opt,@conn,@db,@sql_type)       # db_dbi.rb
      if @opt.mod.inspect =~/update|import/
        @sdb_import=SiSU_DbDBI::Import.new(@opt,@conn,@file_maint,@sql_type)
        @sdb_remove_doc=SiSU_DbDBI::Remove.new(@opt,@conn,@file_maint,@sql_type)
      elsif @opt.mod.inspect =~/remove/
        @sdb_remove_doc=SiSU_DbDBI::Remove.new(@opt,@conn,@file_maint,@sql_type)
      end
    end
    def db_exist?
      if @sql_type=='sqlite' \
      and (not (FileTest.file?(@db.sqlite.db)) or FileTest.zero?(@db.sqlite.db))
        puts %{no connection with #{@sql_type} database established, createdb "#{@db.sqlite.db}"?}
        exit
      end
      if @conn.is_a?(NilClass)
        db=@sql_type=='sqlite' \
        ? @db.sqlite.db
        : @db.psql.db
        puts %{no connection with #{@sql_type} database established, createdb "#{db}"?}
        exit
      end
    end
    def sql_maintenance_file
      file=if @opt.inspect =~/M/
        if @opt.fns and not @opt.fns.empty?
          @env=SiSU_Env::InfoEnv.new(@opt.fns) if @opt.fns
          puts "\n#{@env.processing_path.sqlite}/#{@opt.fns}.sql" if @sql_type =~/sqlite/ and @opt.cmd =~/M/
          @db=SiSU_Env::InfoDb.new
          @job="sqlite3 #{@db.sqlite.db} < #{@env.processing_path.sqlite}/#{@opt.fns}.sql"
          File.new("#{@env.processing_path.sqlite}/#{@opt.fns}.sql",'w+')
        elsif @opt.fns \
        and @opt.fns.inspect =~/create/
          nil #sort variations later
        else nil
        end
      else nil
      end
      file
    end
    def cases
      @opt.mod.each do |mod|
        case mod
        when /^--createdb$/
          @sdb.output_dir?
          begin
            @sdb.create_db
          rescue; @sdb.output_dir?
          end
        when /^--(?:init(?:ialize)?|create(?:all)?)$/
          @sdb.output_dir?
          begin
            @sdb.create_table.metadata_and_text
            @sdb.create_table.doc_objects
            @sdb.create_table.endnotes
            @sdb.create_table.endnotes_asterisk
            @sdb.create_table.endnotes_plus
            @sdb.create_table.urls
            @sdb_index.create_indexes
          rescue
            SiSU_Errors::InfoError.new($!,$@,'-D').error; @sdb.output_dir? do
              __LINE__.to_s + ':' + __FILE__
            end
          end
        when /^--createtables?$/
          @sdb.output_dir?
          begin
            @sdb.create_table.metadata_and_text
            @sdb.create_table.doc_objects
            @sdb.create_table.endnotes
            @sdb.create_table.endnotes_asterisk
            @sdb.create_table.endnotes_plus
            @sdb.create_table.urls
            @sdb_index.create_indexes
          rescue; @sdb.output_dir?
          end
        when /^--recreate$/
          @sdb.output_dir?
          begin
            @sdb_no.drop.tables
            @sdb.create_table.metadata_and_text
            @sdb.create_table.doc_objects
            @sdb.create_table.endnotes
            @sdb.create_table.endnotes_asterisk
            @sdb.create_table.endnotes_plus
            @sdb.create_table.urls
            @sdb_index.create_indexes
          rescue; @sdb.output_dir?
          end
        when /^--cr(eate)?lex$/
          @sdb.output_dir?
          begin
            @sdb.create_table.doc_objects
          rescue; @sdb.output_dir?
          end
        when /^--cr(eate)?metadata$/
          @sdb.output_dir?
          begin
            @sdb.create_table.metadata_and_text
          rescue; @sdb.output_dir?
          end
        when /^--import$/
          db_exist?
          @sdb_import.marshal_load
          tell=case @sql_type
          when /sqlite/; SiSU_Screen::Ansi.new(@opt.cmd,"sqlite3 #{@db.sqlite.db} database?")
          when /pg/;     SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.psql.db} database?")
          else '???'
          end
          tell.puts_grey if @opt.cmd =~/v/
        when /^--update$/
          db_exist?
          @sdb_remove_doc.remove
          @sdb_import.marshal_load
          tell=case @sql_type
          when /sqlite/; SiSU_Screen::Ansi.new(@opt.cmd,"sqlite3 #{@db.sqlite.db} database?")
          when /pg/;     SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.psql.db} database?")
          else '???'
          end
          tell.puts_grey if @opt.cmd =~/v/
        when /^--remove$/
          db_exist?
          @sdb_remove_doc.remove
        when /^--index$/
          db_exist?
          @sdb_index.create_indexes
        when /^--droptable(s)?$/
          db_exist?
          @sdb_no.drop.tables
        when /^--dropindex(es)?$/
          db_exist?
          @sdb_no.drop.indexes
        when /^--(?:dropall|drop)$/
          db_exist?
          @sdb_no.drop.tables
        when /^--(?:db=)?(?:(?:sq)?lite|pg(?:sql)?|my(?:sql)?)$/
        when /^--(?:v\d+|dev)$/
        else
        end
        if @opt.cmd =~/M/ \
        and @opt.cmd  =~/d/
          puts @job
        end
      end
      if @opt.act[:psql][:set]==:on \
      and @opt.mod.inspect !~/--(?:createdb|init(?:ialize)?|create(?:all)?|createtables?|recreate|cr(eate)?lex|cr(eate)?metadata|import|update|remove|index|droptable(s)?|dropindex(es)?|dropall|drop)/
        SiSU_Screen::Ansi.new(@opt.cmd,"--pg requires further instruction").warn unless @opt.cmd =~/[q]/
      end
      begin
      rescue; @sdb.output_dir?
      end
    end
  end
end
__END__
