# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/html_scroll.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html scroll generation, processing

=end
module SiSU_HTML_Scroll
  require_relative 'shared_html'                        # shared_html.rb
  require_relative 'html'                               # html.rb
  require_relative 'shared_metadata'                    # shared_metadata.rb
  require_relative 'html_promo'                         # html_promo.rb
  class Scroll
    def initialize(md='',data='',endnotes='')
      @md,@data,@endnotes=md,data,endnotes
      @vz=SiSU_Viz::Defaults.new
    end
    def songsheet
      begin
        scr=SiSU_HTML_Scroll::Scroll.new(@md,@data,@endnotes).markup
        scr[:tails]=SiSU_HTML_Scroll::Scroll.new(@md).tails
        scr
      rescue
        SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
  protected
    def markup
      data=@data
      @rcdc=false
      @scr={ body: [], metadata: [], owner_details: [] }
      data.each do |dob|
        dob.obj=dob.obj.gsub(/#{@md.file.output_path.html_seg.rel_image}/m,@md.file.output_path.html_scroll.rel_image)
        if defined? dob.name and dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          dob.obj=dob.obj.gsub(/(Document Information(?: \(metadata\))?)/,
            '\1<a name="docinfo"></a>')
        end
        if dob.obj =~/^Metadata$/ \
        and dob.lv =='B'
          dob.obj=dob.obj.gsub(/Metadata/,'')
        end
        if defined? dob.name \
        and dob.name =~/^metadata/ \
        and dob.lv =='1' \
        and dob.obj =~/SiSU Metadata, document information/
          @rcdc=true
        end
        dob.obj=dob.obj.gsub(/href="[a-z0-9._-]+(#\S+?")/m,'href="\1'). # internal document links
          gsub(/href="#{Xx[:segment]}/m,'href="')
        if dob.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]})/
          unless dob.is ==:code
            dob.obj=dob.obj.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
          end
          if defined? dob.ocn
            @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,dob.ocn)
          end
          sto=SiSU_HTML_Format::FormatTextObject.new(@md,dob)
          para_html=if dob.is==:heading
            x=if dob.ln==1
              sto.heading_body1
            elsif dob.ln==2
              sto.heading_body2
            elsif dob.ln==3
              sto.heading_body3
            elsif dob.ln==4
              sto.heading_body4
            elsif dob.ln==5
              sto.heading_body5
            elsif dob.ln==6
              sto.heading_body6
            end
          elsif dob.is==:break \
          and dob.from==:markup
            '<br /><hr width=90% /><br />'
          elsif dob.is==:heading_insert
            x=if dob.ln==1
              unless dob.obj.empty?
                sto.heading_body1
              end
            elsif dob.ln==2
              unless dob.obj.empty?
                sto.heading_body2
              end
            elsif dob.ln==3
              unless dob.obj.empty?
                sto.heading_body3
              end
            elsif dob.ln==4 \
            and dob.obj !~/^(?:Endnotes|Index|Metadata|Manifest)$/
              unless dob.obj.empty?
                sto.heading_body4
              end
            elsif dob.ln==4 \
            and dob.obj=='Endnotes'
              sto.heading_body4
              @endnotes.join("\n")
            elsif dob.ln==4 \
            and dob.obj=='Index'
              sto.heading_body4
              book_idx=SiSU_Particulars::CombinedSingleton.instance.get_idx_html(@md.opt).html_idx
              book_idx.each do |x| #takes book index prepared for segments & strips segment identifying info
                x.gsub!(/<a href="\S+?\.html#(\d+)">(\1(?:-\d+)?)<\/a>/,
                  '<a href="#\1">\2</a>')
              end
              book_idx.join("\n")
            elsif dob.ln==5
              unless dob.obj.empty?
                sto.heading_body5
              end
            elsif dob.ln==6
              unless dob.obj.empty?
                sto.heading_body6
              end
            end
          elsif dob.is==:para
            if dob.indent \
            and dob.hang \
            and dob.indent =~/[0-9]/ \
            and dob.hang =~/[0-9]/
              if dob.bullet_
                (dob.indent =~/[1-9]/) \
                ? sto.format('li',"i#{dob.indent}")
                : sto.format('li','bullet')
              elsif dob.indent == dob.hang
                sto.format('p',"i#{dob.indent}")
              elsif dob.indent != dob.hang
                sto.format('p',"h#{dob.hang}i#{dob.indent}")
              else sto.para
              end
            else sto.para
            end
          elsif dob.is==:block
            sto.block
          elsif dob.is==:group
            sto.group
          elsif dob.is==:alt
            sto.alt
          elsif dob.is==:verse
            sto.verse
          elsif dob.is==:code
            sto.code
          elsif dob.is==:table
            sto.table
          elsif dob.is==:break
          end
          if dob =~/<a name="n\d+">/ \
          and dob =~/^(?:\^~\d+\s|<!e[:_]\d+!>)/ # hmmm re-adjusted 200507, for alt endnote which should again be matched ^~ ... not in response to problem though
            dob=''
          end
          unless @rcdc
            @scr[:body] << para_html unless para_html =~/\A\s*\Z/
          end
        end
      end
      @scr
    end
    def tails
      scr_tail=[]
      format_head_scroll=SiSU_HTML_Format::HeadToc.new(@md)
      ads=SiSU_HTML_Promo::Ad.new(@md)
      scr_tail << format_head_scroll.scroll_tail << ads.div.close << ads.display << format_head_scroll.html_close
      scr_tail
    end
  end
end
__END__
