# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/cgi_sql_sqlite.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: generates naive cgi search form for search of sisu database (sqlite)

=end
module  SiSU_CGI_SQLite                                                            #% database building documents
  require_relative 'sysenv'                             # sysenv.rb
  require_relative 'cgi_sql_common'                     # cgi_sql_common.rb
    include SiSU_CGI_SQL
  class SearchSQLite < CGI_Common
    def initialize(opt,webserv)
      @opt,@webserv=opt,webserv
      @cX=SiSU_Screen::Ansi.new(opt.cmd).cX
      @env=SiSU_Env::InfoEnv.new('',opt)
      @image_src="#{@env.url.webserv_cgi(@opt)}/_sisu/image_sys"
      @common=SiSU_CGI_SQL::CGI_Common.new(@webserv,@opt,@image_src,@env)
      @cgi_file_name="#{Db[:name_prefix_db]}by_#{opt.dir_structure_by.to_s}_sqlite.cgi"
      @name_of_sqlite_db_file='sisu_sqlite.db'
    end
    def sqlite
      serve=[]
      Dir.foreach(@env.path.webserv) do |x|
        if x !~/^\./ \
        and FileTest.directory?("#{@env.path.webserv}/#{x}")
          if FileTest.file?("#{@env.path.webserv}/#{x}/#{@name_of_sqlite_db_file}")
            serve << x unless x =~/^_\S+/
          end
        end
      end
      serve=serve.sort
      f1,f2,f3='','',''
      serve.each do |x|
        f1 << %{              <option value="#{Db[:name_prefix]}#{x}">#{x}</option>\n}
      end
      f2 <<  %{          selected_db=case cgi['db']\n}
      serve.each do |x|
        f2 << %{           when /#{Db[:name_prefix]}#{x}/; '<option value="#{Db[:name_prefix]}#{x}">#{x}</option>'\n}
      end
      f2 << "          end\n"
      f3 << %{          db_name='#{@name_of_sqlite_db_file}'\n}
      f3 << %{          db_sqlite=case cgi['db']\n}
      serve.each do |x|
        f3 << %{          when /#{Db[:name_prefix]}#{x}/;                      "#{@env.path.webserv}/#{x}/\#{db_name}"\n}
      end
      f3 << %{           else  '#{@env.path.webserv}/#{serve[0]}/\#{db_name}'\n          end\n}
      if FileTest.writable?('.')
        output=File.open(@cgi_file_name,'w')
        output << header0 << header1 << header_desc << header2 << f1 << buttons1 << buttons2 << search_request << search_statement << search_statement_common << search_query1 << @common.pages << search_query2 << @common.tail << @common.main1 << f2 << f3 << dbi_connect << @common.main2 << @common.dir_structure << @common.main3
        puts <<-WOK
            generated sample search form: #{@cX.green}#{@cgi_file_name}#{@cX.off}
            default database name:     #{@cX.green}#{Db[:name_prefix]}#{@env.path.stub_pwd}#{@cX.off} (#{@env.path.stub_pwd})
            cgi & db host on:          #{@cX.blue}#{@env.url.webserv_base_cgi(@opt)}#{@cX.off}
              to modify use:           #{@cX.brown}sisu --db-sqlite --webserv-search='#{@env.url.webserv_base_cgi(@opt)}'#{@cX.off}
            sisu output on:            #{@cX.blue}#{@env.url.webserv_files_from_db(@opt)}#{@cX.off}
              to modify use:           #{@cX.brown}sisu --db-sqlite --webserv-output='#{@env.url.webserv_files_from_db(@opt)}'#{@cX.off}
            cgi search form link name: #{@cX.green}#{@env.url.cgi_sample_search_form_name(@opt)}#{@cX.off}
              to modify use:           #{@cX.brown}sisu --db-sqlite --cgi-search-form-name='#{@env.url.cgi_sample_search_form_name(@opt)}'#{@cX.off}
            #{@cX.fuschia}(settings priority: command line; sisurc.yml; else defaults)#{@cX.off}

            #{@cX.fuschia}NOTE it is first necessary to create the database and tables and populate it#{@cX.off}

            sisu --sqlite --dropall                          # removes existing postgresql db & tables
            sisu --sqlite --createall -v                     # creates postgresql db & tables
            sisu --sqlite --update -v *.sst  *.ssm           # populate the db
            sisu --sample-search-form --sqlite               # creates the postgresql search form
                                                             # this should be done after creating the db
                                                             # to be searched
            sisu --webrick &                                 # starts ruby webrick web server

            # if necessary make the directory '/usr/lib/cgi-bin'
            # here we copy the postgresql search form to cgi-bin
            # (copy #{@cgi_file_name} to your cgi directory)
            # set file permissions to 755, &
            # make symbolic link to #{@cgi_link_name}
        WOK
        a=case @webserv
        when /pwd/; ''
        else <<-WOK

              sudo cp -vi #{Dir.pwd}/#{@cgi_file_name} /usr/lib/cgi-bin/.; \\
              cd /usr/lib/cgi-bin && \\
                sudo chmod -v 755 #{@cgi_file_name}; \\
                sudo rm -vi #{@env.url.cgi_sample_search_form_name(@opt)}; \\
                sudo ln -sf #{@cgi_file_name} #{@env.url.cgi_sample_search_form_name(@opt)}; \\
              cd -
          WOK
        end
        b='(to create and populate sisu sqlite database see "man sisu" and in particular the -d flag)'
        SiSU_Screen::Ansi.new(@opt.cmd,a,b).warn
        a=<<-WOK

              #{@env.webserv_base_cgi(@opt)}/cgi-bin/#{@cgi_link_name}

        WOK
        SiSU_Screen::Ansi.new(@opt.cmd,a).print_blue
      else puts "failed in attempt to write #{@cgi_file_name} to present directory, is directory writable?"
      end
    end
    def header0
      <<-WOK_SQL
#!/usr/bin/env ruby
=begin
#{about}
 * Description: generates naive cgi search form for search of sisu database (sqlite)
#{gpl}
=end
      require 'cgi'
      require 'fcgi'
      require 'dbi'
      @stub_default='sisu_sqlite'
      @image_src='#{@image_src}'
      @hosturl_cgi='#{@env.url.webserv_base_cgi(@opt)}/cgi-bin'
      @hosturl_files='#{@env.url.webserv_files_from_db(@opt)}'
      @db_name_prefix='#{Db[:name_prefix]}'
      @base='#{@env.url.webserv_base_cgi(@opt)}/cgi-bin/#{@env.url.cgi_sample_search_form_name(@opt)}' #fix sqlite
      WOK_SQL
    end
    def search_statement
      <<-'WOK_SQL'
      class DBI_SearchString
        def initialize(l,t,q,cse=false)
          @l,@t,@q=l,t,q
        end
        def string
          search={ search: [], flag: false }
          if @t =~/\S+/ or @q =~/\S+/
            if @t =~/\S+/    then unescaped_search=CGI.unescape(@t)
            elsif @q =~/\S+/ then unescaped_search=CGI.unescape(@q)
            end
            search_construct=[]
            unescaped_search=unescaped_search.gsub(/\s*(AND|OR)\s*/,"%' \) \\1 #{@l} LIKE \( '%").
              gsub(/(.+)/,"#{@l} LIKE \( '%\\1%' \)")
            search_construct << unescaped_search
            search_construct=search_construct.join(' ')
            search[:search]                    << search_construct
            search[:flag]=true
            search
          end
          search
        end
      end
      WOK_SQL
    end
    def search_query1
      <<-'WOK_SQL'
          @search_text,@search_endnotes='',''
          @search_text=search[:text].flatten.join(' AND ')
          @search_text=@search_text.gsub(/(doc_objects\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\)\s+(?:(?:AND|OR)\s+doc_objects\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\))+)/,'(\1)')
          @search_endnotes=search[:endnotes].flatten.join(' AND ')
          @search_endnotes=@search_endnotes.gsub(/(endnotes\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\)\s+(?:(?:AND|OR)\s+endnotes\.clean\s+LIKE\s+\(\s*'%[^']+%'\s*\))+)/,'(\1)')
        end
      WOK_SQL
    end
    def search_query2
      <<-'WOK_SQL'
        def sql_select_body
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:body]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, metadata_and_text.notes_suffix, doc_objects.body, doc_objects.seg, doc_objects.ocn, metadata_and_text.tid FROM doc_objects, metadata_and_text WHERE #{@search_text} AND doc_objects.metadata_tid = metadata_and_text.tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, doc_objects.ocn}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:body] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_endnotes
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:endnotes]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, endnotes.body, endnotes.nr, endnotes.ocn, endnotes.metadata_tid FROM metadata_and_text, endnotes WHERE #{@search_endnotes} AND metadata_and_text.tid = endnotes.metadata_tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, endnotes.nr}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:endnotes] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_body_format
          %{<font color="#666666" size="2">#{sql_select_body}</font>}
        end
        def sql_select_endnotes_format
          %{<font color="#666666" size="2">#{sql_select_endnotes}</font>}
        end
        def contents
          @conn.select_all(sql_select_body)
        end
        def endnotes
          @conn.select_all(sql_select_endnotes)
        end
      end
      WOK_SQL
    end
    def dbi_connect
      <<-'WOK_SQL'
          @dbi="DBI:SQLite3:#{db_sqlite}" #sqlite3 ?
          @conn=DBI.connect(@dbi)
      WOK_SQL
    end
  end
end
__END__
