# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/xml.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: xml output (sax style) processing

=end
module SiSU_XML_SAX
  require_relative 'defaults'                           # defaults.rb
    include SiSU_Viz
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'shared_xml'                         # shared_xml.rb
    include SiSU_XML_Munge
  require_relative 'xml_format'                         # xml_format.rb
    include SiSU_XML_Format
  require_relative 'rexml'                              # rexml.rb
    include SiSU_Rexml
  require_relative 'shared_metadata'                    # shared_metadata.rb
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      begin
        @env,@md,@dal_array=@particulars.env,@particulars.md,@particulars.dal_array
        unless @opt.cmd =~/q/
          path=@env.path.output_tell
          loc=@env.url.output_tell
          tool=if @opt.cmd =~/[MV]/; "#{@env.program.web_browser} file://#{@md.file.output_path.xml_sax.dir}/#{@md.file.base_filename.xml_sax}\n\t#{@env.program.xml_viewer} file://#{@md.file.output_path.xml_sax.dir}/#{@md.file.base_filename.xml_sax}"
          elsif @opt.cmd =~/v/; "#{@env.program.web_browser} file://#{@md.file.output_path.xml_sax.dir}/#{@md.file.base_filename.xml_sax}"
          else "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
          end
          @opt.cmd=~/[MVvz]/ \
          ? SiSU_Screen::Ansi.new(@opt.cmd,'XML SAX',tool).green_hi_blue
          : SiSU_Screen::Ansi.new(@opt.cmd,'XML SAX',tool).green_title_hi
          SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"file://#{@md.file.output_path.xml_sax.dir}/#{@md.file.base_filename.xml_sax}").flow if @opt.cmd =~/[MV]/
        end
        SiSU_XML_SAX::Source::Songsheet.new(@particulars).song
      rescue
        SiSU_Errors::InfoError.new($!,$@,@opt.cmd,@opt.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        #file closed in songsheet
        SiSU_Env::CreateSite.new(@opt.cmd).cp_css
      end
    end
    private
    class Songsheet
      def initialize(particulars)
        @env,@md,@dal_array,@particulars=particulars.env,particulars.md,particulars.dal_array,particulars
        @file=SiSU_Env::FileOp.new(@md)
      end
      def song
        begin
          SiSU_XML_SAX::Source::Scroll.new(@particulars).songsheet
          SiSU_XML_SAX::Source::Tidy.new(@md,@file.place_file.xml_sax.dir).xml if @md.opt.cmd =~/[vVM]/ # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@file.place_file.xml_sax.dir).xml if @md.opt.cmd =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue
          SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
            __LINE__.to_s + ':' + __FILE__
          end
        ensure
        end
      end
    end
    class Scroll
      require_relative 'shared_txt'                     # shared_txt.rb
        include SiSU_TextUtils
      require_relative 'css'                            # css.rb
      require_relative 'shared_xhtml'                   # decide use, whether xml rather than xhtml
      @@xml={ body: [], open: [], close: [], head: [] }
      def initialize(particulars)
        @env,@md,@dal_array=particulars.env,particulars.md,particulars.dal_array
        @vz=SiSU_Viz::Defaults.new
        @trans=SiSU_XML_Munge::Trans.new(@md)
        @sys=SiSU_Env::SystemCall.new
      end
      def songsheet
        pre
        @data=markup(@dal_array)
        post
        publish
      end
    protected
      def embedded_endnotes(dob='')
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/,
            '<endnote><number>\1</number><note>\2</note></endnote> ').
          gsub(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)#{Mx[:en_b_c]}/,
            '<endnote><symbol>\1</symbol><note>\2</note></endnote> ').
          gsub(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)#{Mx[:en_a_c]}/,
            '<endnote><symbol>\1</symbol><note>\2</note></endnote> ')
      end
      def extract_endnotes(dob='')
        notes=dob.obj.scan(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})([\d*+]+\s+.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/)
        notes.flatten.each do |e|
          s=e.to_s
          util=SiSU_TextUtils::Wrap.new(s,70)
          wrap=util.line_wrap
          wrap=wrap.gsub(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
#{Ax[:tab]*1}<endnote notenumber="\\1">
#{Ax[:tab]*2}<number>\\1</number>
#{Ax[:tab]*2}<note>
#{Ax[:tab]*3}\\2
#{Ax[:tab]*2}</note>
#{Ax[:tab]*1}</endnote>
WOK
).
            gsub(/^([*+]\d+)\s+(.+?)\s*\Z/m, <<WOK
#{Ax[:tab]*1}<endnote symbol="\\1">
#{Ax[:tab]*2}<symbol>\\1</symbol>
#{Ax[:tab]*2}<note>
#{Ax[:tab]*3}\\2
#{Ax[:tab]*2}</note>
#{Ax[:tab]*1}</endnote>
WOK
).
            gsub(/^([*+]+)\s+(.+?)\s*\Z/m, <<WOK
#{Ax[:tab]*1}<endnote symbol="\\1.length">
#{Ax[:tab]*2}<symbol>\\1</symbol>
#{Ax[:tab]*2}<note>
#{Ax[:tab]*3}\\2
#{Ax[:tab]*2}</note>
#{Ax[:tab]*1}</endnote>
WOK
)
          @endnotes << wrap
        end
      end
      def xml_head
        metadata=SiSU_Metadata::Summary.new(@md).xml_sax.metadata
        @@xml[:head] << metadata
      end
      def xml_sc(md='')
        sc=if @md.sc_info
          <<WOK
    <source_control>
      <meta>filename:</meta>
      <sc class="sourcefile">
        #{@md.sc_filename}
      </sc><br />
      <meta>version number:</meta>
      <sc class="number">
        #{@md.sc_number}
      </sc><br />
      <meta>version date:</meta>
      <sc class="date">
        #{@md.sc_date}
      </sc><br />
    </source_control>
WOK
        else ''
        end
        @@xml[:sc]=sc
      end
      def xml_structure(dob,type='norm')
        if dob.is==:heading
          lv=dob.ln
          n=dob.ln - 1
          n3=dob.ln + 2
        else lv=nil
        end
        extract_endnotes(dob)
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_a_c]}/,'<en>\1</en>'). #footnote/endnote clean
          gsub(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        #if defined? dob.obj
        #t_ograph="#{dob.obj}"
        util=SiSU_TextUtils::Wrap.new(dob.obj,70)
        wrapped=util.line_wrap
        #end
        @@xml[:body] << if defined? dob.ocn; %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        else                              "#{Ax[:tab]*0}<object>"
        end
        @@xml[:body] << "#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>" if defined? dob.ocn
        @@xml[:body] << if lv; %{#{Ax[:tab]*1}<text class="h#{lv}">\n#{Ax[:tab]*2}#{wrapped}\n#{Ax[:tab]*1}</text>}
        else                   %{#{Ax[:tab]*1}<text class="#{type}">\n#{Ax[:tab]*2}#{wrapped}\n#{Ax[:tab]*1}</text>} # main text, contents, body KEEP
        end
        @@xml[:body] << @endnotes if @endnotes
        ##@@xml[:body] << "#{Ax[:tab]*1}<text>#{dob[@regx,2]}</text>" if dob[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
        @endnotes=[]
      end
      def block_structure(dob='')
        extract_endnotes(dob)
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_a_c]}/,'<en>\1</en>'). #footnote/endnote clean
          gsub(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        dob=@trans.markup_block(dob)
        dob.obj=dob.obj.strip
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="block">#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
        @@xml[:body] << @endnotes if @endnotes
        @endnotes=[]
      end
      def group_structure(dob='')
        extract_endnotes(dob)
        dob.obj=dob.obj.gsub(/#{Mx[:en_a_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_a_c]}/,'<en>\1</en>'). #footnote/endnote clean
          gsub(/#{Mx[:en_b_o]}([\d*+]+)\s+(?:.+?)#{Mx[:en_b_c]}/,'<en>\1</en>') #footnote/endnote clean
        dob=@trans.markup_group(dob)
        dob.obj=dob.obj.strip
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="group">#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
        @@xml[:body] << @endnotes if @endnotes
        @endnotes=[]
      end
      def poem_structure(dob='')
        dob=@trans.markup_group(dob)
        #dob.obj.gsub(/\s\s/,'&#160;&#160;')
        dob.obj=dob.obj.strip
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="verse">#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def code_structure(dob='')
        dob=@trans.markup_group(dob)
        dob.obj=dob.obj.gsub(/\s\s/,'&#160;&#160;').strip
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="code">#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{dob.obj}#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
      end
      def table_structure(dob)
        table=SiSU_XHTML_Shared::TableXHTML.new(dob)
        @@xml[:body] << %{#{Ax[:tab]*0}<object id="#{dob.ocn}">}
        @@xml[:body] << %{#{Ax[:tab]*1}<ocn>#{dob.ocn}</ocn>}
        @@xml[:body] << %{#{Ax[:tab]*1}<text class="table">#{Ax[:tab]*1}}
        @@xml[:body] << %{#{Ax[:tab]*2}#{table.table.obj}}
        @@xml[:body] << %{#{Ax[:tab]*1}</text>}
        #@@xml[:body] << %{#{tab*1}</text>}
        @@xml[:body] << "#{Ax[:tab]*0}</object>"
       #@@xml[:body] << %{#{Ax[:tab]*0}<object id="#{ocn}">}
       #@@xml[:body] << %{#{Ax[:tab]*1}#{table}\n#{Ax[:tab]*1}} # unless lv  # main text, contents, body KEEP
       #@@xml[:body] << "#{Ax[:tab]*0}</object>"
       #@endnotes=[]
      end
      def markup(data)
        xml_sc(@md)
        @endnotes,@level,@cont,@copen,@xml_contents_close=[],[],[],[],[]
        @rcdc=false
        xml_head
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @xml_contents_close[x]='' }
        data.each do |dob|
          @trans.char_enc.utf8(dob) if @sys.locale =~/utf-?8/i #% utf8
          dob=@trans.markup(dob)
          if @rcdc==false \
          and (dob.is ==:meta \
          and dob.obj =~/Document Information/)
            @rcdc=true
          end
          if dob.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            if defined? dob.ocn #look to move to format section
              ocn=((dob.ocn.to_s =~/\d+/) ? dob.ocn : nil)
              @p_num=SiSU_XML_Format::ParagraphNumber.new(@md,ocn)
            end
            if not @rcdc
              if defined? dob.ocn \
              and dob.ocn.to_s =~/\d+/
                x=SiSU_XML_Format::FormatSeg.new(@md,dob)
                if dob.is==:heading
                  xml_structure(dob)
                  dob.obj=case dob.ln
                  when 1; x.heading_body1
                  when 2; x.heading_body2
                  when 3; x.heading_body3
                  when 4; x.heading_body4
                  when 5; x.heading_body5
                  when 6; x.heading_body6
                  end
                else
                  if dob.is==:verse
                    poem_structure(dob)
                  elsif dob.is==:group
                    group_structure(dob)
                  elsif dob.is==:block
                    block_structure(dob)
                  elsif dob.is==:code
                    code_structure(dob)
                  elsif dob.is==:table # FIX, check css, will need to modify
                    table_structure(dob)
                  elsif dob.is ==:para \
                  and dob.indent.to_s =~/[1-9]/ \
                  and dob.bullet_==true
                    xml_structure(dob,"indent_bullet#{dob.indent}")
                  elsif dob.is ==:para \
                  and dob.indent.to_s =~/[1-9]/ \
                  and dob.indent == dob.hang
                    xml_structure(dob,"indent#{dob.indent}")
                  elsif dob.is ==:para \
                  and dob.hang.to_s =~/[0-9]/ \
                  and dob.indent != dob.hang
                    xml_structure(dob,"hang#{dob.hang.to_s}_indent#{dob.indent.to_s}")
                  else xml_structure(dob)
                  end
                end
              elsif dob.obj =~/(#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
              elsif dob.obj =~/MetaData/
                txt_obj={ txt: '<br /><a name="metadata">MetaData</a>' }
                format_scroll=FormatScroll.new(@md,txt_obj)
                dob.obj=format_scroll.bold_para
              elsif dob.obj =~/(Owner Details)/
#               txt_obj={ txt: '<br /><a name="owner.details">Owner Details</a>' }
#               format_scroll=FormatScroll.new(@md,txt_obj)
#               @@xml[:owner_details]=format_scroll.bold_para
                dob.obj=''
              end
              if dob.obj =~/<a name="n\d+">/ \
              and dob.obj =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/ # -endnote
                dob.obj=''
              end
              if dob.obj =~/.*<:#>.*$/ #investigate removal
                dob.obj=if dob.obj =~ /#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]}/
                  txt_obj={ txt: dob }
                  format_text=FormatTextObject.new(@md,txt_obj)
                  format_text.scr_inden_ocn_e_no_paranum
                end
              end
            else #
            end
            dob.obj=dob.obj.gsub(/#{Mx[:pa_o]}:\S+#{Mx[:pa_c]}/,'') if dob.obj
          end
        end
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          @@xml[:body] << "#{Ax[:tab]*5}</content>\n#{Ax[:tab]*y}</contents#{v}>" if @level[x]==true
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{Ax[:tab]*y}</heading#{x}>" if @level[x]==true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{Ax[:tab]*y}</level #{x}>" if @level[x]==true }
      end
      def pre
        rdf=SiSU_XML_Tags::RDF.new(@md)
        dir=SiSU_Env::InfoEnv.new
        @@xml[:head],@@xml[:body]=[],[]
        stylesheet=SiSU_Style::CSS_HeadInfo.new(@md,'xml_sax').stylesheet
        encoding=if @sys.locale =~/utf-?8/i; '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else                                 '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
#{stylesheet.css_head_xml}
#{rdf.comment_xml}
<document>
WOK
        @@xml[:head] << '<head>'
        @@xml[:body] << '<body>'
      end
      def post
        @@xml[:head] << @@xml[:sc]
        @@xml[:head] << '</head>'
        @@xml[:body] << '</body>'
        @@xml[:close] = '</document>'
      end
      def publish
        content=[]
        content << @@xml[:open] << @@xml[:head] << @@xml[:body] << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail] << @@xml[:close]
        content=content.flatten.compact
        Output.new(content,@md).xml
        @@xml={}
      end
    end
    class Output
      def initialize(data,md)
        @data,@md=data,md
        @file=SiSU_Env::FileOp.new(@md)
      end
      def xml
        SiSU_Env::FileOp.new(@md).mkdir
        filename_xml=@file.write_file.xml_sax
        @data.each do |str|
          str=str.gsub(/\A\s+\Z/m,'')
          filename_xml.puts str unless str.empty?
        end
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,file)
        @md,@file=md,file
        @prog=SiSU_Env::InfoProgram.new
      end
      def xml
        if @prog.tidy !=false #note values can be other than true
          if @md.opt.cmd =~/[VM]/
            unless @md.opt.cmd =~/q/
              SiSU_Screen::Ansi.new(@md.opt.cmd,'invert','Using XML Tidy','check document structure').colorize
              tell=SiSU_Screen::Ansi.new(@md.opt.cmd,'invert','','')
              tell.grey_open
            end
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy=SiSU_Env::SystemCall.new(@file,tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.opt.cmd =~/q/
          end
        end
      end
    end
  end
end
__END__
