# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/html_format.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html formating, css template

=end
module SiSU_HTML_Format
  include SiSU_Viz
  class ParagraphNumber
    def initialize(md,ocn)
      @md,@ocn=md,ocn.to_s
      @ocn ||=''
    end
    def ocn_display
      make=SiSU_Env::ProcessingSettings.new(@md)
      if make.build.ocn?
        ocn_class='ocn'
        if @ocn.to_i==0 \
        or @ocn.empty?
          %{<label class="ocn_off">&nbsp;</label>}
        else
          @ocn.gsub(/^(\d+|)$/,
            %{<label class="#{ocn_class}"><a name="#{@ocn}" href="##{@ocn}" class="lnk#{ocn_class}">\\1</a></label>})
        end
      else
        %{<label class="ocn_off">&nbsp;</label>}
      end
    end
    def name
      (@ocn==nil || @ocn.empty?) ? '' : %{<a name="#{@ocn}"></a>}
    end
    def id #w3c? "tidy" complains about numbers as identifiers ! annoying
      (@ocn==nil || @ocn.empty?) ? '' : %{id="o#{@ocn}"}
    end
    def goto
      (@ocn==nil || @ocn.empty?) ? '' : %{<a href="##{@ocn}">}
    end
  end
  class HeadInformation
    require_relative 'css'                              # css.rb
    require_relative 'shared_xml'                       # shared_xml.rb
    include SiSU_Viz
    attr_reader :md,:rdf,:vz
    def initialize(md)
      @md=md
      # DublinCore 1 - title
      @vz=SiSU_Viz::Defaults.new
      @seg_name_html=(SiSU_HTML::Source::Seg.new.seg_name_html || [])
      @seg_name_html_tracker=(SiSU_HTML::Source::Seg.new.seg_name_html_tracker || [])
      @tocband_scroll,@tocband_segtoc=nil,nil
      @stylesheet=SiSU_Style::CSS_HeadInfo.new(md).stylesheet
      @o_str ||=SiSU_Env::ProcessingSettings.new(md).output_dir_structure
      @index,@metalink='index','#metadata'
      @toc=@md.file.base_filename.html_segtoc
    end
    def url_path_image_sys
      (@o_str.dump_or_redirect?) \
      ? './image'
      : "#{Xx[:html_relative2]}_sisu/image_sys"
    end
    def icon
      def up
        'arrow_up_red.png'
      end
      def next
        'arrow_next_red.png'
      end
      def previous
        'arrow_prev_red.png'
      end
      def dot_clear
        'dot_clear.png'
      end
      def dot_white
        'dot_white.png'
      end
      def dot
        dot_white
      end
      self
    end
    def png_nav
      def toc
        %{<img border="0" width="22" height="22" src="#{url_path_image_sys}/#{icon.up}" alt="toc" />}
      end
      def pre
        %{<img border="0" width="22" height="22" src="#{url_path_image_sys}/#{icon.previous}" alt="&lt;&lt;&nbsp;previous" />}
      end
      def nxt
        %{<img border="0" width="22" height="22" src="#{url_path_image_sys}/#{icon.next}" alt="next&nbsp;&gt;&gt;" />}
      end
      def dot_toc
        %{<img border="0" width="100%" height="20" src="#{url_path_image_sys}/#{icon.dot}" alt="&#094;" />}
      end
      def dot_pre
        %{<img border="0" width="100%" height="20" src="#{url_path_image_sys}/#{icon.dot}" alt="&lt;" />}
      end
      def dot_nxt
        %{<img border="0" width="100%" height="20" src="#{url_path_image_sys}/#{icon.dot}" alt="&gt;" />}
      end
      self
    end
    def doc_types(page=:seg) #used in toc & seg_nav_band
      wgt=SiSU_HTML_Format::Widget.new(@md)
      %{
<table summary="segment navigation available documents types: toc,doc,pdf,concordance" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.manifest(page)}
  #{wgt.search}
</tr></table>}
    end
    def rdf
      SiSU_XML_Tags::RDF.new(md)
    end
    def doc_type
      %{<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">\n}
    end
    def table_close
      %{  </font>
#{@vz.table_close}}
    end
    def button_home(page=:seg)
      button=%{ <table summary="home button / home information" border="0" cellpadding="3" cellspacing="0">\n <tr><td align="left" bgcolor="#ffffff">\n}
      if @md.make.home_button_image.is_a?(Hash)
        image_path=if page==:manifest
          @md.file.output_path.manifest.rel_image
        elsif  page==:scroll
          @md.file.output_path.html_scroll.rel_image
        else
          @md.file.output_path.html_seg.rel_image
        end
        dir=SiSU_Env::FileOp.new(@md)
        button +=%{   <p class="tiny_left"><a href="#{@md.make.home_button_image[:link]}" target="_top"><img border="0" src="#{image_path}/#{@md.make.home_button_image[:home_button]}"  width="#{@md.make.home_button_image[:w]}" height="#{@md.make.home_button_image[:h]}" alt="home icon --&gt;" /></a></p>\n}
      elsif @md.home_button_links.is_a?(Array)
        @md.home_button_links.each do |links|
          button +=%{  <p class="tiny_left"><a href="#{links[:url]}/" target="_top">\n    #{links[:say]}\n  </a></p>\n}
        end
      end
      button +=%{ </td></tr>\n </table>}
      button
    end
    def html_close #moved
    %{</body>
</html>}
    end
  end
  class Widget < HeadInformation
    def initialize(md)
      super(md)
      @md=md
      @cf_defaults=SiSU_Env::InfoProcessingFlag.new
      @env=SiSU_Env::InfoEnv.new(md.fns)
      @file=SiSU_Env::FileOp.new(md)
      @o_str ||=SiSU_Env::ProcessingSettings.new(md).output_dir_structure
      @make=SiSU_Env::ProcessingSettings.new(@md)
    end
    def home
      %{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="../index.html" target="_top">
  #{@vz.nav_txt_homepage}</a>
</td>
}
    end
    def scroll(text)
      if @md.fns =~ /\.(?:-|ssm\.)?sst$/
        scroll=%{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{Xx[:html_relative1]}html/#{@file.base_filename.html_scroll}" target="_top">
    #{text}
  </a>
</td>
}
      end
    end
    def seg(text)
      %{<td align="center" bgcolor="#99CC66">
  <a href="#{@md.file.base_filename.html_segtoc}" target="_top">
    #{text}
  </a>
</td>
}
    end
    def search
      if @make.build.html_search_form?
        env=SiSU_Env::InfoEnv.new(@md.fns,@md)
        env.widget.search_form('sisusearch',nil,nil,true)
      else ''
      end
    end
    def manifest(page=:seg)
      if @make.build.links_to_manifest? \
      and not @o_str.dump_or_redirect?
        manifest_lnk=if @file.output_dir_structure.by_language_code? \
        or @file.output_dir_structure.by_filetype?
          "#{Xx[:html_relative1]}manifest/#{@file.base_filename.manifest}"
        else @file.base_filename.manifest
        end
        if page==:manifest
          manifest_lnk="#{@md.file.output_path.manifest.url}/#{@file.base_filename.manifest}"
          brace_url=SiSU_Viz::Defaults.new.url_decoration
          %{<td align="center" bgcolor=#{@vz.color_band2}>
  <font face="#{@vz.font_fonts}" size="2">
  #{brace_url.xml_open}<a href="#{manifest_lnk}" target="_top">#{@md.file.output_path.manifest.url}/#{@file.base_filename.manifest}</a>#{brace_url.xml_close}
  </font>
</td>}
        else
          %{<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{manifest_lnk}" target="_top">
    #{@vz.nav_txt_manifest}
  </a>
</td>}
        end
      else ''
      end
    end
    def pdf #retired 2.7.9
      pdf=if @md.programs[:pdf] \
      and @cf_defaults.cf_0 =~/p/
        %{
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{Xx[:html_relative1]}pdf/#{@file.base_filename.pdf_p}" target="_top">
    #{@vz.nav_txt_pdf_portrait}
  </a>
</td>
<td align="center" bgcolor=#{@vz.color_band2}>
  <a href="#{Xx[:html_relative1]}pdf/#{@file.base_filename.pdf_l}" target="_top">
    #{@vz.nav_txt_pdf_landscape}
  </a>
</td>
}
      else ''
      end
    end
  end
  class XML
  end
  class HeadToc < HeadInformation
    def initialize(md)
      super(md)
      @md=md
      @o_str ||=SiSU_Env::ProcessingSettings.new(md).output_dir_structure
      @make=SiSU_Env::ProcessingSettings.new(@md)
      @file=SiSU_Env::FileOp.new(@md)
    end
    def scroll_head_navigation_band
      if @make.build.html_top_band?
        search_and_manifest=<<WOK
<td align="center" width="60%">
  #{make_scroll_search_form_and_manifest_link}
</td>
WOK
        %{<table summary="table of contents scroll navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{button_home(:scroll)}
</td>
<td width="75%" align="center">
  #{doc_types}
</td>
<td width="20%">
  &nbsp;
#{@vz.table_close}
<p />}
      else ''
      end
    end
    def concordance_navigation_band
      if @make.build.html_top_band?
        %{<table summary="concordance navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{button_home}
</td>
<td width="75%" align="center">
  #{doc_types}
</td>
<td width="5%" align="right">
  &nbsp;<a href="toc.html" target="_top" alt="-&gt;">
      #{png_nav.toc}
    </a>&nbsp;
#{@vz.table_close}
<p />}
      else ''
      end
    end
    def seg_head_navigation_band(page=:seg)
      if page==:manifest
        nxt=(@file.output_dir_structure.by_language_code? \
        || @file.output_dir_structure.by_filetype?) \
        ? "../html/#{@md.fnb}/toc#{@md.lang_code_insert}#{Sfx[:html]}"
        : "toc#{@md.lang_code_insert}#{Sfx[:html]}"
        firstseg=%{<a href="#{nxt}" target="_top" alt="-&gt;">
        #{png_nav.nxt}</a>}
      elsif @md.firstseg =~/\S+/
        firstseg=%{<a href="#{@md.firstseg}#{@md.lang_code_insert}#{Sfx[:html]}" target="_top" alt="-&gt;">
      #{png_nav.nxt}</a>}
      end
      %{<table summary="table of contents segment navigation band" id="toc" width="100%" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
#{button_home(page)}
</td>
<td width="75%" align="center">
  #{doc_types(page)}
</td>
<td width="5%" align="right">
  &nbsp;#{firstseg}&nbsp;
#{@vz.table_close}
<p />}
    end
    def manifest_link(text)
#     @file=SiSU_Env::FileOp.new(@md) if @md
  %{<font size=2>
    <a href="#{@md.file.base_filename.manifest}" target="_top">#{text}</a>
  </font>}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.file.base_filename.html_concordance}" target="_top">
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def make_scroll_search_form_and_manifest_link
      wgt=SiSU_HTML_Format::Widget.new(@md)
      scroll=%{<td align="center" bgcolor=#{@vz.color_band2}>
  #{@vz.nav_txt_doc_link}
</td>
}
      %{<table summary="toc segment and scroll with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{wgt.manifest}
  #{wgt.search}
</tr></table>}
    end
    def make_scroll_seg_pdf
      manifest=scroll=seg=''
      wgt=SiSU_HTML_Format::Widget.new(@md)
      seg=%{<td align="center" bgcolor=#{@vz.color_band2}>
  #{@vz.nav_txt_toc_link}
</td>
}
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.manifest}
  #{wgt.search}
</tr></table>}
    end
    def make_concordance
      manifest=scroll=seg=''
      wgt=SiSU_HTML_Format::Widget.new(@md)
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@vz.color_band2}>
  #{wgt.manifest}
  #{wgt.search}
</tr></table>}
    end
    def head
      rdf=SiSU_XML_Tags::RDF.new(@md)
      %{#{doc_type}
<head>
  <title>
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{rdf.metatag_html}
#{@stylesheet.css_head}
</head>
#{@vz.color_body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>}
    end
    def concordance
      if @md.concord_make
      %{#{@vz.margin_css}
  <h4 class="toc">
    <a href="./#{@md.file.base_filename.html_concordance}">
      <i>Concordance</i>
    </a>
  </h4>
#{@vz.table_close}}
      else
      %{#{@vz.margin_css}
#{@vz.table_close}}
      end
    end
    def links_guide_vertical_open
#     @file=SiSU_Env::FileOp.new(@md) if @md
      url=((defined? @vz.url_hp) && @vz.url_hp =~/^https?:\/\/\S+$/ ? @vz.url_hp : @vz.url_home)
      %{
<div id="vertical_links">
  <ul id="vertical">
  <li class="refbold">
    <a href="#{url}">
      #{@vz.txt_hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.file.base_filename.manifest}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_horizontal_open
#     @file=SiSU_Env::FileOp.new(@md) if @md
      url=((defined? @vz.url_hp) && @vz.url_hp =~/^https?:\/\/\S+$/ ? @vz.url_hp : @vz.url_home)
      %{
<div id="horizontal_links">
  <ul id="horizontal">
  <li class="refbold">
    <a href="#{url}">
      #{@vz.txt_hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.file.base_filename.manifest}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_open(type='horizontal')
      (type=='vertical') \
      ? links_guide_vertical_open
      : links_guide_horizontal_open
    end
    def links_guide_close
      insert=''
      insert=if @md.sfx_src =~/s?/
        link='http://sisudoc.org'                          #get from defaults
        url='sisudoc.org'
        name='SiSU electronic documents'                   #get from defaults
        insert= %{
  <li class="ref">
    <a href="#{link}" alt="#{name}" target="_top">
      #{url}
    </a>
  </li>
  </ul>
</div>
}
      end
      %{ #{insert}
<!- quick ref -!>}
    end
    def prefix_a
    end
    def rights
      def all
        rights=@md.rights.all.gsub(/^\s*Copyright\s+\(C\)/,'Copyright <sup>&copy;</sup>&nbsp;')
        %{<p class="small_left">Rights: #{rights}</p>
<p />}
      end
      self
    end
    def prefix_b
      %{<p class="small_left">Prefix: #{@md.prefix_b}<p />}
    end
    def scroll_head_title_banner_open
      icon=@md.icon ? %{<center>\n#{@md.icon}\n</center>} : ''
      %{#{icon}
#{@vz.banner_instrument_cover_band_scr}}
    end
    def seg_head_title_banner_open
      icon=@md.icon ? %{<center>\n#{@md.icon}\n</center>} : ''
      %{#{icon}
#{@vz.banner_instrument_cover_band_seg}}
    end
    def make_scroll
      concord=concordance_link(@vz.nav_txt_concordance)
      %{<table summary="toc scroll" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white" border="0">
  #{@vz.nav_txt_doc_link}
</td>
<td align="center" bgcolor="white">
   #{concord}
#{@vz.table_close}}
    end
    def make_seg
      concord=concordance_link(@vz.nav_txt_concordance)
      %{<table summary="toc segment" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white">
  #{@vz.nav_txt_toc_link}
</td>
<td align="center" bgcolor="white">
  <font size=2>
   #{concord}
#{@vz.table_close}}
    end
    def manifest #check structure
      if not @o_str.dump_or_redirect?
        manifest=manifest_link(@vz.nav_txt_manifest)
        %{#{@vz.margin_txt_3}
  #{@vz.paragraph_font_small}
   #{manifest}
    </font>
#{@vz.table_close}}
      else ''
      end
    end
    def concordance #check structure
      concord=concordance_link(@vz.nav_txt_concordance)
      %{#{@vz.margin_txt_3}
  #{@vz.paragraph_font_small}
   #{concord}
    </font>
#{@vz.table_close}}
    end
    def metadata
      %{#{@vz.margin_css}
  <h4 class="toc">
    <a href="#{@metalink}">
      <i>MetaData</i>
    </a>
  </h4>
#{@vz.table_close}}
    end
    def seg_tail
      %{
<div class="main_column">
<p>&nbsp;<p>
<table summary="toc segment tail" bgcolor=#{@vz.color_band1}>
<tr><td width="20%">
  #{@vz.banner_band}
</td>
<td width="60%">
  <center>
    #{@tocband_segtoc}
  </center>
</td></tr>
</table>
<p>&nbsp;</p>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</div>
</div>
</div>
}
    end
    def scroll_tail #debug
      nav=scroll_head_navigation_band
      %{
<div class="main_column">
#{nav}
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</div>
}
    end
    def seg_navigation_tail #this is a bug area, look up and "tidy"
      %{
<div class="main_column">
<p>&nbsp;</p>
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</div>
</div>
</div>
}
    end
  end
  class HeadSeg < HeadInformation
    def initialize(md)
      super(md)
    end
    def title_banner(title,subtitle,creator)
    end
    def dot_control_pre_next
      pre="#{@seg_name_html[@seg_name_html_tracker-1]}#{@md.lang_code_insert}#{Sfx[:html]}"
      up=@toc
      nxt="#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.lang_code_insert}#{Sfx[:html]}"
      if nxt=~/sisu_manifest\.html/
        @file=SiSU_Env::FileOp.new(@md) if @md
        if @file.output_dir_structure.by_language_code? \
        or @file.output_dir_structure.by_filetype?
          nxt=nxt.gsub(/sisu_manifest\.html/,"../../manifest/#{@file.base_filename.manifest}")
        end
      end
      %{<table summary="segment hidden control pre and next" width="100%" border="0" cellpadding="0" bgcolor=#{@vz.color_grey_pale} align="center">
<tr><td align="left">
  <a href="#{pre}" target="_top">
    #{png_nav.dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{up}" target="_top">
    #{png_nav.dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{nxt}" target="_top">
    #{png_nav.dot_nxt}
  </a>
#{@vz.table_close}}
    end
    def dot_control_pre
      pre="#{@seg_name_html[@seg_name_html_tracker-2]}#{@md.lang_code_insert}#{Sfx[:html]}"
      up=@toc
      nxt="#{@md.file.base_filename.html_segtoc}"
      %{<table summary="segment hidden control pre" width="100%" border="0" cellpadding="0" bgcolor=#{@vz.color_grey_pale} align="center">
<tr><td align="left">
  <a href="#{pre}" target="_top">
    #{png_nav.dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{up}" target="_top">
    #{png_nav.dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{nxt}" target="_top">
    #{png_nav.dot_nxt}
  </a>
#{@vz.table_close}}
    end
    def toc_nav(f_pre=false,f_nxt=false,use=1)
      pre=nxt=''
      toc=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@toc}" target="_top">
    #{png_nav.toc}
  </a>
</td>}
      pre=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@seg_name_html[@seg_name_html_tracker-use]}#{@md.lang_code_insert}#{Sfx[:html]}" target="_top">
    #{png_nav.pre}
  </a>
</td>} if f_pre==true
      nxt=%{<td align="center" bgcolor=#{@vz.color_band1}>
  <a href="#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.lang_code_insert}#{Sfx[:html]}" target="_top">
    #{png_nav.nxt}
  </a>
</td>} if f_nxt==true
      if nxt =~/sisu_manifest.html/
        @file=SiSU_Env::FileOp.new(@md) if @md
        if @file.output_dir_structure.by_language_code? \
        or @file.output_dir_structure.by_filetype?
          nxt=nxt.gsub(/sisu_manifest\.html/,"../../manifest/#{@file.base_filename.manifest}")
        end
      end
      %{<table summary="segment navigation pre/next" border="0" cellpadding="3" cellspacing="0">
<tr>
#{pre}
#{toc}
#{nxt}
<td>
#{@vz.table_close}}
    end
    def toc_next2
      pre,nxt=false,true
      toc_nav(false,true).dup
    end
    def toc_pre_next2
      toc_nav(true,true).dup
    end
    def toc_pre2
      toc_nav(true,false,2).dup
    end
    def manifest_link(text)
  %{<font size=2>
    <a href="#{@md.file.base_filename.manifest}" target="_top">
      #{text}
    </a>
  </font>}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.file.base_filename.html_concordance}" target="_top">
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def navigation_table
      %{<table summary="navigation segment table" width=#{@vz.table_width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width="#{@@indent['leve_1']}" align="right">
</td>
<td valign="top">
  <font size=2>}
    end
    def navigation_table1
      %{<table summary="navigation segment table1" width=#{@vz.table_width_1} border="0" cellpadding=#{@vz.table_cellpad_box} bgcolor=#{@vz.color_table1} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def navigation_table2
      %{<table summary="navigation segment table2" width=#{@vz.table_width_2} border="0" cellpadding=#{@vz.table_cellpad_box} bgcolor=#{@vz.color_table2} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def credit
      %{
<div class="main_column">
#{@vz.credits_splash}
#{@vz.credits_sisu}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits" id="credits"></a>
</div></div>
}
    end
    def navigation_band(segtocband,seg_table_top_control) #change name to navigation_band_banner
      %{<table summary="segment navigation band with banner" bgcolor=#{@vz.color_band1} width="100%"><tr>
<td width="20%" align="left">
#{button_home}
</td>
<td width="75%" align="center">
  #{doc_types}
</td>
<td width="5%" align="right">
  #{segtocband}
</td></tr>
</table>
#{seg_table_top_control}}
    end
    def navigation_band_bottom(segtocband,seg_table_top_control) #change name to navigation_band_bannerless
      %{
<div class="main_column">
  <table summary="segment navigation band" bgcolor=#{@vz.color_band1} width="100%"><tr>
  <td width="70%" align="center">
    #{doc_types}
  </td>
  <td width="5%" align="right">
    #{segtocband}
  </td></tr>
  </table>
  #{seg_table_top_control}
</div>
}
    end
    def endnote_mark
%{
<p class="center" id="endnotes">
  <hr class="endnote" />
</p>}
    end
    def endnote_section_open
%{
<div class="endnote">
}
    end
    def endnote_section_close
%{
</div>
} #revisit
    end
    def head_seg
      rdf=SiSU_XML_Tags::RDF.new(@md)
      %{#{doc_type}
<head>
  <title>
    #{@seg_name_html[@seg_name_html_tracker]} -
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{rdf.metatag_html}
#{@stylesheet.css_head_seg}
</head>
#{@vz.color_body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>}
    end
    def title_banner(title,subtitle,creator)
      %{
<div class="summary">
  <p class="tiny">
    #{title}
  </p>
  <p class="tiny">
    #{subtitle}
  </p>
  <p class="tiny">
    #{creator}
  </p>
  <p class="tiny">
    copy @
    <a href="#{@vz.url_home}">
      #{@vz.txt_home}
    </a>
  </p>
</div>
}
    end
  end
  class HeadScroll < HeadToc
    def initialize(md)
      super(md)
    end
    def toc_owner_details
      %{#{@vz.margin_txt_3}
#{@vz.paragraph_font_small}
  <a href="#owner.details">
    Owner Details
    <font size="1" color="#777777">
      &nbsp;&nbsp;&nbsp;
    </font>
  </a>
  </font>
#{@vz.table_close}}
    end
  end
  class FormatTextObject
    @vz=SiSU_Viz::Defaults.new
    attr_accessor :md,:t_o,:txt,:ocn,:format,:table,:link,:linkname,:paranum,:p_num,:headname,:banner,:url
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.is_a?(Hash)
        @txt            =t_o[:txt]            || nil
        @ocn            =t_o[:ocn]            || nil
        @ocn_display    =t_o[:ocn_display]    || nil
        @headname       =t_o[:headname]       || nil
        @trailer        =t_o[:trailer]        || nil
        @endnote_part_a =t_o[:endnote_part_a] || nil
        @endnote_part_b =t_o[:endnote_part_b] || nil
        @lnk_url        =t_o[:lnk_url]        || nil
        @lnk_txt        =t_o[:lnk_txt]        || nil
        @format         =t_o[:format]         || nil
      elsif t_o.class.inspect =~/^(?:#<)?SiSU_DAL_DocumentStructure/
        @dob=t_o if defined? t_o.is
        @named=nametags_seg(@dob)
        @txt=((defined? t_o.obj) ? t_o.obj : nil)
        @ocn=((defined? t_o.ocn) ? t_o.ocn.to_s : nil)
        @headname=((t_o.is==:heading and defined? t_o.name) ? t_o.name : nil)
      else
        if @md.opt.cmd =~/M/
          p t_o.class
          p caller
        end
      end
      @headnamed= (@headname ? %{<a name="h#{@headname}" id="h#{@headname}"></a>} : nil)
      if @txt and not @txt.empty?
        @txt=@txt.gsub(/#{Mx[:mk_o]}[-~]##{Mx[:mk_c]}/,'')
      end
      @p_num=ParagraphNumber.new(@md,@ocn)
      @vz=SiSU_Viz::Defaults.new
      @make=SiSU_Env::ProcessingSettings.new(@md)
    end
    def nametags_scroll(dob)
      tags=''
      if defined? dob.tags \
      and dob.tags.length > 0 # insert tags "hypertargets"
        dob.tags.each do |t|
          tags=tags +%{<named id="#{t}" />}
        end
      end
      tags
    end
    def nametags_seg(dob) #FIX
      tags=''
      if defined? dob.tags \
      and dob.tags.length > 0 # insert tags "hypertargets"
        dob.tags.each do |t|
          tags=tags +%{<a name="#{t}" ></a>}
        end
      end
      tags
    end
    def headname #check whether used
      hn=if @t_o.is ==:heading \
      and not @t_o.name.empty? #determine use
        hn=(@t_o.is ==:heading) \
        ? (%{<a name="h#{@t_o.name}" id="h#{@t_o.name}"></a>})
        : (%{<a name="#{@t_o.name}" id="#{@t_o.name}"></a>})
      else nil
      end
      hn
    end
    def endnote_body
      %{
<p class="endnote">
  #{@txt}
</p>
}
    end
    def endnote_body_indent
      %{
  <p class="endnote_indent">
    #{@txt}
  </p>
}
    end
    def no_paranum
      %{
<div class="substance">
  <label class="ocn">&nbsp;</label>
  <p class="norm">
    #{@txt}
  </p>
</div>
}
    end
    def para_form_css(tag,attrib)                                                    # regular paragraphs shaped here
      ul=ulc=''
      ul,ulc="<ul>\n  ","\n  </ul>" if @tag =~/li/
      %{
<div class="substance">
  #{@p_num.ocn_display}
  #{ul}<#{tag} class="#{attrib}" #{@p_num.id}>
    #{@named}#{@txt}
  </#{tag}>#{ulc}
</div>
}
    end
    def para
      para_form_css('p','norm')
    end
    def block
      para_form_css('p','block')
    end
    def group
      para_form_css('p','group')
    end
    def alt
      para_form_css('p','alt')
    end
    def verse
      para_form_css('p','verse')
    end
    def code
      para_form_css('p','code')
    end
    def center
      para_form_css('p','center')
    end
    def bold
      para_form_css('p','bold')
    end
    def bullet
      para_form_css('li','bullet')
    end
    def table
      @txt=if @t_o.obj !~/^<table\s/
        table=SiSU_HTML_Shared::TableHTML.new(@t_o) #move, make happen earlier
        @txt=table.table.obj
      else @txt
      end
      para_form_css('p','norm')
    end
    def format(tag,attrib)
      para_form_css(tag,attrib)
    end
    def heading_normal(tag,attrib)
      section_break=(tag=~/h[1-4]/) \
      ? '<br /><hr width=90% /><br />'
      : ''
      %{#{section_break}
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name}
    #{@named}<a name="h#{@headname}">#{@txt}</a>
  </#{tag}>
</div>
}
    end
    def heading_body
      heading_normal('p','norm')
    end
    def heading_body1
      heading_normal('h1','norm')
    end
    def heading_body2
      heading_normal('h2','norm')
    end
    def heading_body3
      heading_normal('h3','norm')
    end
    def heading_body4
      heading_normal('h4','norm')
    end
    def heading_body5
      heading_normal('h5','norm')
    end
    def heading_body6
      heading_normal('h6','norm')
    end
    def title_heading(tag,attrib)
      cl=(@make.build.html_minitoc?) \
      ? 'content'
      : 'content0'
      %{
<div class="#{cl}">
<#{tag} class="#{attrib}">
    #{@named}#{@txt}
  </#{tag}>
</div>
}
    end
    def title_heading1
      title_heading('h1','tiny')
    end
    def title_heading2
      title_heading('h2','tiny')
    end
    def title_heading3
      title_heading('h3','tiny')
    end
    def title_heading4
      ''
    end
    def seg_heading_sub(tag,attrib)
      @txt=@txt.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name} #{@headnamed}
    #{@named}#{@txt}
  </#{tag}>
</div>
}
    end
    def seg_heading4
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <h1 class="norm" #{@p_num.id}>#{@p_num.name}
    #{@txt}
  </h1>
</div>
}
    end
    def seg_heading5
      seg_heading_sub('p','bold')
    end
    def seg_heading6
      seg_heading_sub('p','bold')
    end
    def dl #check :trailer
      "<dl><b>#{@txt}</b> #{@trailer}</dl>"
    end
    def table_css_end
      '</table>
    </p>
  </div>'
    end
    def gsub_body #fix
      @txt=case @txt
      when /^\((i+|iv|v|vi+|ix|x|xi+)\)/
        @txt.gsub(/^\((i+|iv|v|vi+|ix|x|xi+)\)/,'<b>(\1)</b>')
      when /^\(?(\d|[a-z])+\)/
        @txt.gsub(/^\((\d+|[a-z])+\)/,'<b>(\1)</b>')
      when /^\s*\d{1,3}\.\s/
        @txt.gsub(/^\s*(\d+\.)/,'<b>\1</b>')
      when /^\s*[A-Z]\.\s/
        @txt.gsub(/^\s*([A-Z]\.)/,'<b>\1</b>')
      else @txt
      end
    end
    def bold_para
      %{#{@vz.margin_txt_0}
  <p class="bold">
    #{@txt}
  </p>
#{@vz.margin_num_css}
  &nbsp;&nbsp;&nbsp;
#{@vz.table_close}}
    end
    def bold_heading
      @txt=@txt.gsub(/[1-9]~(\S+)/,'<a name="\1"></a>').
        gsub(/[1-9]~/,'')
      %{<p class="bold">
    #{@txt}
  </p>
#{@vz.margin_num_css}
  &nbsp;&nbsp;&nbsp;
#{@vz.table_close}}
    end
    def toc_head_copy_at
      %{<p class="center">#{@txt}</p>\n}
    end
    def center
      %{<p class="center">#{@txt}</p>\n}
    end
    def bold
      %{<p class="bold">#{@txt}</p>\n}
    end
    def center_bold
      %{<p class="centerbold">#{@txt}</p>\n}
    end
  end
  class FormatScroll < FormatTextObject
    def initialize(md,txt)
      super(md,txt)
      @vz=SiSU_Viz::Defaults.new
    end
  end
  class FormatSeg < FormatTextObject
    def initialize(md,txt)
      super(md,txt)
    end
    def navigation_toc_lev1_advert
      %{#{@banner.home_button}\n
<center>
#{@txt}
#{@two}
</a></center><p />}
    end
    def navigation_toc_lev1
      %{#{@banner.nav_toc}}
    end
    def navigation_toc_lev2                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 2">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{@vz.font_face}>
    <b>#{@txt}</b>
  </font>
  </p>
#{@vz.table_close}}
    end
    def navigation_toc_lev3                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 3">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{@vz.font_face}>
    <b>#{@txt}</b>
  </font>
  </p>
#{@vz.table_close}}
    end
    def navigation_toc_lev4
      %{<table summary="navigation segment level 4">
<tr><td width ="80">
</td>
<td>
<p>
  #{@txt}
</p>
#{@vz.table_close}}
    end
    def navigation_toc_lev5
    end
    def navigation_toc_lev6
    end
    def endnote_seg_body(fn='')  #FIX                                                #url construction keep within single line... BUG WATCH 200408
      fn='doc' if fn.to_s.empty? #you may wish to reconsider, sends to 'doc' where no segment info
      %{
  <p class="endnote">
    #{@endnote_part_a}#{fn}#{@md.lang_code_insert}#{Sfx[:html]}#{@endnote_part_b}
  </p>
}
    end
    def clean(txt)
      txt=txt.gsub(/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/,'').
        gsub(/#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]}/,'')
    end
    def subtoc_lev(tag,attrib)
      @txt=clean(@txt)
      txt=if @txt \
      and @txt =~/<\/?i>|<a\s+name="\S+?">/mi
        @txt.gsub(/<\/?i>|<a\s+name="\S+?">/mi,'') #removes name markers from subtoc, go directly to substantive text
      else @txt
      end
      note=''
      if txt =~/(#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})/m # had \s* at end
        note=$1
        note=note.gsub(/[\n\s]+/m,' ')
        txt=txt.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ').
          gsub(/<a[\n\s]+name="-\d+"[\n\s]+href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;/m,'')
      end
      %{<#{tag} class="#{attrib}">
    <a href="##{@ocn}"><i>#{txt}</i></a> #{note}
  </#{tag}>}
    end
    def subtoc_lev5
      subtoc_lev('h5','subtoc') if @txt
    end
    def subtoc_lev6
      subtoc_lev('h6','subtoc') if @txt
    end
    def heading_sub(tag,attrib)
      @txt=@txt.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <#{tag} class="#{attrib}" #{@p_num.id}>#{@p_num.name} #{@headnamed}
    #{@txt}
  </#{tag}>
</div>
}
    end
    def heading5
      heading_sub('p','bold')
    end
    def heading6
      heading_sub('p','bold')
    end
    def heading4
      %{
<div class="substance">
  #{@p_num.ocn_display}
  <h1 class="norm" #{@p_num.id}>#{@p_num.name}
    #{@t_o[:format]}
    #{@txt}
  </h1>
</div>
}
    end
    def navigation_heading4
      %{<table summary="navigation segment heading 4" width=100% bgcolor="#08163f" border="0">
<tr><td align="center">
<p class="bold">
  #{@txt}
</p>
#{@vz.table_close}}
    end
    def navigation_heading5
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_heading6
      %{<p class="bold">
  #{@txt}
</p>}
    end
    def navigation_center
      "<center>#{@txt}</center>"
    end
  end
  class FormatToc < FormatTextObject
    def initialize(md,txt)
      super(md,txt)
    end
    def links_guide
      %{  <li class="doc">
    <a href="#{@lnk_url}" target="_top">
      #{@lnk_txt}
    </a>
  </li>
}
    end
    def lev(tag,attrib)
      if @txt
        %{<#{tag} class="#{attrib}">
    #{@txt}
  </#{tag}>
}
      else ''
      end
    end
    def lev1
      lev('h1','toc')
    end
    def lev2
      lev('h2','toc')
    end
    def lev3
      lev('h3','toc')
    end
    def lev4
      lev('h4','toc')
    end
    def lev5
      lev('h5','toc')
    end
    def lev6
      lev('h6','toc')
    end
    def lev0 #docinfo
      lev('h0','toc')
    end
    def strip_endnotes(txt)
      txt=txt.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
      txt
    end
    def mini_lev1
      @txt=strip_endnotes(@txt)
      lev('h1','minitoc')
    end
    def mini_lev2
      @txt=strip_endnotes(@txt)
      lev('h2','minitoc')
    end
    def mini_lev3
      @txt=strip_endnotes(@txt)
      lev('h3','minitoc')
    end
    def mini_lev4
      @txt=strip_endnotes(@txt)
      lev('h4','minitoc')
    end
    def mini_lev5
      @txt=strip_endnotes(@txt)
      lev('h5','minitoc')
    end
    def mini_lev6
      @txt=strip_endnotes(@txt)
      lev('h6','minitoc')
    end
    def mini_lev0 #docinfo
      lev('h0','minitoc')
    end
    def mini_tail
  %{
  <h4 class="minitoc">
    <a href="sisu_manifest.html">Manifest (alternative outputs)</a>
  </h4>
}
    end
    def mini_concord_tail
  %{
  <h4 class="minitoc">
    <a href="concordance.html">Concordance (wordlist)</a>
  </h4>
  <h4 class="minitoc">
    <a href="sisu_manifest.html">Manifest (alternative outputs)</a>
  </h4>
}
    end
  end
  class FormatStr
    def initialize(md,str)
      @str=str
    end
    def center
      %{<p class="center">#{@str}</p>\n}
    end
    def bold
      %{<p class="bold">#{@str}</p>\n}
    end
    def center_bold
      %{<p class="centerbold">#{@str}</p>\n}
    end
    def endnote_body
      %{
<p class="endnote">
  #{@str}
</p>
}
    end
  end
end
__END__
