# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v4/db_remove.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DbRemove
  class Remove
    def initialize(opt,conn,file,sql_type)
      @opt,@conn,@file,@sql_type=opt,conn,file,sql_type
      @md=SiSU_Param::Parameters.new(@opt).get
      @fnb=@md.fnb
      @db=SiSU_Env::InfoDb.new
    end
    def remove
      driver_sqlite3=if @sql_type=='sqlite'
        (@conn.inspect.match(/^(.{10})/)[1]==@db.sqlite.conn_sqlite3.inspect.match(/^(.{10})/)[1]) \
        ? true
        : false
      end
      del_id=if driver_sqlite3
        remove_selected=%{
          SELECT tid
          FROM metadata_and_text
          WHERE src_filename = '#{@opt.fns}'
          AND metadata_and_text.language_document_char = '#{@opt.lng}'
        ;}
        @conn.get_first_value(remove_selected).to_i
      else
        remove_selected=%{
          SELECT metadata_and_text.tid
          FROM metadata_and_text
          WHERE metadata_and_text.src_filename = '#{@opt.fns}'
          AND metadata_and_text.language_document_char = '#{@opt.lng}'
        ;}
        x=@conn.select_one(remove_selected)
        x ? (x.join.to_i) : nil
      end
      if del_id
        sql_entry=[
          "DELETE FROM endnotes WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM endnotes_asterisk WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM endnotes_plus WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM doc_objects WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM urls WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM metadata_and_text WHERE metadata_and_text.tid = '#{del_id}';",
        ]
        if driver_sqlite3
          @conn.transaction
          sql_entry.each do |s|
            @conn.execute(s)
          end
          @conn.commit if driver_sqlite3
        else
          sql_entry.each do |s|
            @conn.execute(s)
          end
        end
        if @opt.cmd =~/M/
          @file.puts sql_entry if @opt.cmd =~/M/
        end
      else
        SiSU_Screen::Ansi.new(@opt.cmd,"no such file in database #{@db.psql.db}::#{@opt.fns}").puts_grey if @opt.cmd =~/vVM/
      end
    end
  end
end
__END__
