# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/xml_md_oai_pmh_dc.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: summary of generated outputs and metadata

=end
module SiSU_XML_Metadata
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  require_relative 'param'                              # param.rb
    include SiSU_Param
  class OAI_PMH
    def initialize(opt)
      @md=SiSU_Param::Parameters.new(opt).get
      @oai_pmh=[]
    end
    def read
      output
    end
    def pre
<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<oai_dc:dc
  xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/
  http://www.openarchives.org/OAI/2.0/oai_dc.xsd">
WOK
    end
    def body
      if defined? @md.title.full \
      and @md.title.full=~/\S+/                                               # DublinCore 1 - title
        @oai_pmh << %{  <dc:title xml:lang="en">#{@md.title.full}</dc:title>\n}
      end
      if defined? @md.creator.author \
      and @md.creator.author=~/\S+/                                           # DublinCore 2 - creator/author (author)
        txt=meta_content_clean(@md.creator.author)
        @oai_pmh << %{  <dc:author>#{txt}</dc:author>\n}
      end
      if defined? @md.classify.subject \
      and @md.classify.subject=~/\S+/                                         # DublinCore 3 - subject (us library of congress, eric or udc, or schema???)
        txt=meta_content_clean(@md.classify.subject)
        @oai_pmh << %{  <dc:subject>#{txt}</dc:subject>\n}
      end
      if defined? @md.notes.description \
      and @md.notes.description=~/\S+/                                        # DublinCore 4 - description
        txt=meta_content_clean(@md.notes.description)
        @oai_pmh << %{  <dc:description>#{txt}</dc:description>\n}
      end
      if @md.publisher                                                        # DublinCore 5 - publisher (current copy published by)
        txt=meta_content_clean(@md.publisher)
        @oai_pmh << %{  <dc:publisher>#{txt}</dc:publisher>\n}
      end
      if defined? @md.creator.contributor \
      and @md.creator.contributor=~/\S+/                                      # DublinCore 6 - contributor
        txt=meta_content_clean(@md.creator.contributor)
        @oai_pmh << %{  <dc:contributor>#{txt}</dc:contributor>\n}
      end
      if defined? @md.date.published \
      and @md.date.published=~/\S+/                                           # DublinCore 7 - date year-mm-dd
        @oai_pmh << %{  <dc:date>#{@md.date.published}</dc:date>\n}
      end
      if defined? @md.date.created \
      and @md.date.created=~/\S+/                                             # DublinCore 7 - date.created
        @oai_pmh << %{  <dc:date_created>#{@md.date.created}</dc:date_created>\n}
      end
      if defined? @md.date.issued \
      and @md.date.issued=~/\S+/                                              # DublinCore 7 - date.issued
        @oai_pmh << %{  <dc:date_issued>#{@md.date.issued}</dc:date_issued>\n}
      end
      if defined? @md.date.available \
      and @md.date.available=~/\S+/                                           # DublinCore 7 - date.available
        @oai_pmh << %{  <dc:date_available>#{@md.date.available}</dc:date_available>\n}
      end
      if defined? @md.date.valid \
      and @md.date.valid=~/\S+/                                               # DublinCore 7 - date.valid
        @oai_pmh << %{  <dc:date_valid>#{@md.date.valid}</dc:date_valid>\n}
      end
      if defined? @md.date.modified \
      and @md.date.modified=~/\S+/                                            # DublinCore 7 - date.modified
        @oai_pmh <<  %{  <dc:date_modified>#{@md.date.modified}</dc:date_modified>\n}
      end
      if @md.type                                                             # DublinCore 8 - type
        txt=meta_content_clean(@md.type)
        @oai_pmh << %{  <dc:type>#{txt}</dc:type>\n}
      end
      if defined? @md.classify.format \
      and @md.classify.format=~/\S+/                                          # DublinCore 9 - format
        txt=meta_content_clean(@md.classify.format)
        @oai_pmh << %{  <dc:format>#{txt}</dc:format>\n}
      end
      if defined? @md.classify.identifier \
      and @md.classify.identifier=~/\S+/                                      # DublinCore 10 - identifier
        txt=meta_content_clean(@md.classify.identifier)
        @oai_pmh << %{  <dc:identifier>#{txt}</dc:identifier>\n}
      end
      if defined? @md.original.source \
      and @md.original.source=~/\S+/                                          # DublinCore 11 - source
        txt=meta_content_clean(@md.original.source)
        @oai_pmh << %{  <dc:source>#{txt}</dc:source>\n}
      end
      if defined? @md.title.language \
      and @md.title.language=~/\S+/                                           # DublinCore 12 - language (English)
        @oai_pmh << %{  <dc:language>#{@md.title.language}</dc:language>\n}
      end
      if defined? @md.original.language \
      and @md.original.language=~/\S+/
        @oai_pmh << %{  <dc:language>#{@md.original.language}</dc:language>\n}
      end
      if defined? @md.classify.relation \
      and @md.classify.relation=~/\S+/                                        # DublinCore 13 - relation
        txt=meta_content_clean(@md.relation)
        @oai_pmh << %{  <dc:relation>#{txt}</dc:relation>\n}
      end
      if defined? @md.classify.coverage \
      and @md.classify.coverage=~/\S+/                                        # DublinCore 14 - coverage
        txt=meta_content_clean(@md.classify.coverage)
        @oai_pmh << %{  <dc:coverage>#{txt}</dc:coverage>\n}
      end
      if defined? @md.rights.all \
      and @md.rights.all=~/\S+/                                               # DublinCore 15 - rights
        txt=meta_content_clean(@md.rights.all)
        @oai_pmh << %{  <dc:rights>#{txt}</dc:rights>\n}
      end
      if defined? @md.classify.keywords \
      and @md.classify.keywords=~/\S+/
        txt=meta_content_clean(@md.classify.keywords)
        @oai_pmh << %{  <dc:keywords>#{txt}</dc:keywords>\n}
      end
      @oai_pmh
    end
    def meta_content_clean(content='')
      unless content.nil?
        content=content.tr('"',"'")
      end
      content
    end
    def post
      '</oai_dc:dc>'
    end
    def output
      SiSU_Env::FileOp.new(@md).mkdir
      oai_pmh=SiSU_Env::FileOp.new(@md,@md.fn[:oai_pmh]).mkfile #implement in param
      oai_pmh << pre
      body.each do |x|
        oai_pmh << x
      end
      oai_pmh << post
    end
  end
end
__END__
http://www.openarchives.org/pmh/
http://www.openarchives.org/OAI/2.0/openarchivesprotocol.htm#dublincore
http://es.dublincore.org/documents/usageguide/elements.shtml
http://dublincore.org/documents/dces/
see also http://dublincore.org/documents/dcmes-xml/
#http://www.openarchives.org/OAI/2.0/openarchivesprotocol.htm#dublincore
#sample implementation, e.g. 2
<?xml version="1.0" encoding="UTF-8"?>
<oai_dc:dc
    xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/
    http://www.openarchives.org/OAI/2.0/oai_dc.xsd">
  <dc:title xml:lang="en">Grassmann's space analysis</dc:title>
  <dc:author>Hyde, E. W. (Edward Wyllys)</dc:author>
  <dc:subject>LCSH:Ausdehnungslehre; LCCN QA205.H99</dc:subject>
  <dc:publisher>J. Wiley &amp; Sons</dc:publisher>
  <dc:date>Created: 1906; Available: 1991</dc:date>
  <dc:type>text</dc:type>
  <dc:identifier>http://resolver.library.cornell.edu/math/1796949
     </dc:identifier>
  <dc:language>english</dc:language>
  <dc:rights xml:lang="en">Public Domain</dc:rights>
</oai_dc:dc>
