# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/texinfo.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: texinfo processing

=end
module SiSU_TexInfo
  require_relative 'html'                               # html.rb
  require_relative 'param'                              # param.rb
    include SiSU_Param
  include SiSU_Viz
  #include Stamp ... needed removed arbitrarily 2005w05/1 (warnings about undefined flags)
  require_relative 'texinfo_format'                     # texinfo_format.rb
  include SiSU_TexInfoFormat
  @tex_file=[]
  @@tabular="{tabular}"
  @@table_pagebreak_counter,@@tex_endnote_call_counter,@@tex_table_flag,@@tex_counter,@@tex_column,@@tex_columns,@@counting=0,0,0,0,0,0,0
  @@column_instruct,@@tex_line_mode,@@tex_word_mode,@@start_table,@@line_mode='','','','',''
  @@n,@@copyright,@@tableheader=nil,nil,nil
  @@tex_col_w=[]
  @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
  class Source
    include SiSU_Param
    include SiSU_Viz
    include SiSU_TexInfo
    def initialize(opt)
      @opt=opt
      @md=SiSU_Param::Parameters.new(@opt).get
      @env=SiSU_Env::InfoEnv.new(@opt.fns)
      @vz=SiSU_Env::GetInit.instance.skin
    end
    def directories
      begin
        case @opt.fns
        when /\.(?:-|ssm\.)?sst$/
          Dir.mkdir(@env.path.output) unless FileTest.directory?("#{@env.path.output}")
          Dir.mkdir(@env.processing_path.texi) unless FileTest.directory?(@env.processing_path.texi)
        end
      rescue
        SiSU_Screen::Ansi.new(opt,$!,$@).rescue do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def read
      song
    end
    def song
      begin
        tool=(@opt.cmd =~/[MVv]/) \
        ?  "#{@env.program.texinfo} #{@md.file.output_path.texinfo.dir}/#{@md.file.base_filename.info}"
        : "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
        tell=@opt.cmd=~/[MVvz]/ \
        && @opt.cmd !~/q/ \
        ? SiSU_Screen::Ansi.new(@opt.cmd,'TexInfo',tool).green_hi_blue
        : SiSU_Screen::Ansi.new(@opt.cmd,'TexInfo',tool).green_title_hi
        tell
        @md=SiSU_Param::Parameters.new(@opt).get
        directories
        @marshalfile=SiSU_Env::InfoFile.new(@opt.fns).marshal.dal_content
        if FileTest.file?(@marshalfile)==true
          File.open(@marshalfile) { |f| @@tuned_file=Marshal.load(f)}
          #tell.meta_verse_skipped if @opt.cmd =~/[vVM]/
        else
          tex_array=IO.readlines(@opt.fns,'')
          SiSU_Metaverse.songsheet(tex_array)
        end
        tex_array=@@tuned_file
        TeXinfoMake.new(@md,tex_array).songsheet
        tex_array=''
      rescue; STDERR.puts SiSU_Screen::Ansi.new(@opt.cmd,$!,$@).rescue
      ensure
      end
    end
  end
  class TeXinfoMake
    include SiSU_Param
    include SiSU_TexInfoFormat
    @@tex_1='(?:.+?)+~' #?? debug
    @@tabular="{tabular}"
    @@tex_pattern_margin_number="\\\\marginpar.+?\s+"
    def initialize(md,data)
      @md,@data=md,data
      @env=SiSU_Env::InfoEnv.new(@md.fns)
      @vz=SiSU_Env::GetInit.instance.skin
      @f=SiSU_Env::FileOp.new(@md)
    end
    def songsheet
      begin
        data=@data
        data=pre(data)
        data=endnote(data)
        data,head=markup(data)
        objs_txt=tail(data)
        doc_txt=[head,objs_txt]
        output(doc_txt)
        makeinfo #KEEP reinstate when fixed #%
        place_info
      rescue; STDERR.puts SiSU_Screen::Ansi.new(@md.opt.cmd,$!,$@).rescue
      ensure
      end
    end
    def pre(data)
      data_new=[]
      data.each do |dob|
        # DEBUG 2003w16 this is a kludge, because i could not get parameters
        # from param, Sort out ... revert to more elegant solution
        if dob.is =='table'
          @@flag['tables']='y' # KLUDGE get from param
        end
        dob.obj=dob.obj.gsub(/<:p[bn]>/,'').
          gsub(/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,'\1(\2 [linked to:] \3)').
          gsub(/(^|#{Mx[:gl_c]}|\s)\{(.+?)\}((?:https?|file):\/\/\S+)/,'\1(\2 [linked to:] \3)')
        do_mono=SiSU_TexInfoFormat::Texinfo.new(@md,dob)
        dob.obj=do_mono.spec_char(dob.obj)
        data_new << dob
      end
      data_new
    end
    def endnote(data)
      data_new=[]
      data.each do |dob|
        if dob.of==:para \
        || dob.of==:block
          dob.obj=dob.obj.gsub(/\s*#{Mx[:en_a_o]}(?:\d+)\s+(.+?)#{Mx[:en_a_c]}/m,' @footnote{ \1} ').
            gsub(/\s*#{Mx[:en_a_o]}(\*+)\s+(.+?)#{Mx[:en_a_c]}/m,' @footnote{ \1} ')
        end
        data_new << dob
      end
      data_new
    end
    def poem
      data,data_new=@data,[]
      @tex_file=[]
      @@counting=0
      data.each do |dob|
        if dob.is ==:code
          @@flag['code']=true
          @@counting=1
        end
        if dob.is ==:verse
          @@flag['poem']=1
        end
        if @@flag['code']
          if @@flag['code'] \
          && (dob.obj =~ /#{Mx[:gr_o]}code[-_](?:end|close)#{Mx[:gr_c]}/) #watch change not tested 200501 #fix
            @@flag['code']=false
          end
          if @@flag['code'] \
          && (dob.obj =~ /\S/)
            sub_array=dob.obj.dup
            @@line_mode=sub_array.scan(/.+/)
            Tune.code_lines(@@line_mode)
            dob.obj=@@line_mode.join
          end
        elsif @@flag['poem']==1
          if @@flag['poem']==1 \
          && (dob.obj =~ /#{Mx[:gr_o]}verse[-_](?:end|close)#{Mx[:gr_c]}/) #watch change not tested 200501 #fix
            @@flag['poem']=0
          end
          if @@flag['poem']==1 \
          && (dob.obj =~ /\S/)
            sub_array=dob.obj.dup
            @@line_mode=sub_array.scan(/.+/)
            Tune.code_lines(@@line_mode)
            dob.obj=@@line_mode.join
          end
        end
        @tex_file << dob.obj
        data_new << dob
      end
      data_new
    end
    def code_lines
      data,data_new=@data,[]
      data.each do |line|
        if (line =~ /\S/) \
        && (line !~ /#{Mx[:gr_o]}(code|verse).+/) #fix
          line=if @@flag['code']
            line.gsub(/^\s*(.+)/m,"\\noindent \\marginpar\[left-text\]{\\begin{tiny}#{@@counting}\\end{tiny}}\\1\\")
            @@counting+=1 if @@flag['code']
          else line.gsub(/(.+)/m,'\noindent\1')
          end
        end
        data_new << line
      end
    end
    def tables
      data,data_new=@data,[]
      @tex_file=[]
      @@tableheader=0
      data.each do |dob|
        if dob.obj =~ /#{Mx[:tc_p]}|#{Mx[:gr_o]}T/ui #fix
          do_mono=SiSU_TexInfoFormat::Texinfo.new(@md,dob)
          dob.obj=do_mono.longtable # using longtable latex package
        end
        @tex_file << dob.obj
        data_new << dob
      end
      data_new
    end
    def markup(data)
      data_new=[]
      @tex_file=[]
      @row_break='\\\\\\'
      @break_page="#{@row_break}\n#{@row_break} \n"
      md={}
      @tex_file << SiSU_TexInfoFormat::Texinfo.new(@md).head
      mono=SiSU_TexInfoFormat::Texinfo.new(@md)
      @tex_file << mono.topnode(@md.title.full)
      texinfo_menu=[]
      n_menu,n_submenu=0,0
      @submenu,@subsubmenu={},{}
      data.each do |dob|
        if dob.is ==:heading \
        && (dob.ln.to_s =~ /^[1-3]$/)
          toc=SiSU_TexInfoFormat::Texinfo.new(@md,dob)
          texinfo_menu << toc.menu
        elsif dob.is ==:heading \
        && (dob.ln.to_s =~ /^[4-6]$/)
          toc=SiSU_TexInfoFormat::Texinfo.new(@md,dob)
          texinfo_menu << toc.menu
          case dob.ln
          when 4
            n_menu+=1
            @submenu[n_menu]=[]
          when 5
            n_submenu+=1
            @subsubmenu[n_menu]=[]
            @submenu[n_menu] << toc.menu
          when 6
            n_submenu+=1
            @subsubmenu[n_submenu]=[]
            @subsubmenu[n_submenu] << toc.menu
          end
        else
          dob.obj=dob.obj.gsub(/\s*(?:<:?br>|<br \/>)\s*/,"\n\n")
        end
        data_new << dob
      end
      data=data_new
      texinfo_menu=texinfo_menu.compact
      texinfo_menu << "* Dublin Core::"
      @tex_file << texinfo_menu
      @tex_file << "* Index::\n" +
        "@end menu\n\n" +
        "@c %% 5\n\n"
      n_menu,n_submenu=0,0
      @@do_submenu,@@do_subsubmenu=1,1
      data_new=[]
      data.each do |dob|
        mono=SiSU_TexInfoFormat::Texinfo.new(@md,dob)
        if dob.is==:heading
          case dob.ln
          when 1; dob=mono.level1
          when 2; dob=mono.level2
          when 3; dob=mono.level3
          when 4;
            dob=mono.level4
            n_menu+=1
            @@do_submenu,@@do_subsubmenu=1,1
          when 5;
            n_submenu+=1
            @@do_subsubmenu=1
            if @@do_submenu==1
              menu=SiSU_TexInfoFormat::TeXinfoTxt.new(@md,dob,@submenu[n_menu])
              dob.obj="#{menu.submenu}#{mono.level5.obj}"
              @@do_submenu=0
            else dob=mono.level5
            end
          when 6;
            if @@do_submenu==1
              menu=SiSU_TexInfoFormat::TeXinfoTxt.new(@md,dob,@submenu[n_menu])
              dob.obj="#{menu.subsubmenu}#{mono.level6.obj}"
              @@do_subsubmenu=0
            else
              dob=mono.level6
            end
          end
        else
          if dob.obj !~/\S/
            dob.obj=nil
          else
            if dob.is==:para \
            && (dob.obj !~/##{dob.ocn}/)
              dob.obj="#{dob.obj} ##{dob.ocn}"
            end
          end
        end
        #%case with endnotes
        dob.obj=dob.obj.gsub(/\s*[0-8]\\+(\S+)?\s+/,' ') if dob.obj
        data_new << dob
      end
      [data_new, @tex_file]
    end
    def number_titles
      data,data_new=@data,[]
      @tex_file=[]
      input=%{#{@md.markup}}[/(num_top\s*=\s*(\d?))?/m,2] # else default usually 4  # this was a bit of a trick required to pass nil to input if nothing matched... #puts input
      num_top=input.to_i
      t_no1=0;  t_no2=0;  t_no3=0;  t_no4=0;
      no1=num_top; no2=(num_top + 1); no3=(num_top + 2);  no4=(num_top + 3);
      data.each do |dob|
        if (@md.markup =~ /num_top/i) \
        && (dob.obj !~ /#{Rx[:meta]}/)
          if (dob.obj =~ /^[1-6]\\+(?:~\S+)?\s*<!h-.+?-!>/) \
          && (dob.obj !~ /<:\d-endnotes>/)
            header=dob.obj[/<!h-(.+?)-!>/m, 1].gsub(/-/m,'.')
            dob.obj=dob.obj.gsub(/^(?:[1-6]\\+(?:~\S+)|<:([12356]|4-.+?-)>)\s*<!h-.+?-!>/,
              "\\1 #{header} ")
          end
        elsif dob.obj=~ /<!h!>|<!h\d!>|<!h.+?!>|<!!h.+?!>/
          if dob.obj=~ /<!h-.+?-!>/
            dob.obj=dob.obj.gsub(/<!h-(.+?)-!>/,'\1 ')
          end
        end
        @tex_file << dob.obj
      end
      data_new << dob
    end
    def tail(data)
      tex=SiSU_TexInfoFormat::Texinfo.new(@md)
      objs_txt=[]
      data.each do |dob|
        if dob.obj \
        && (dob.is !=:structure \
        && dob.is !=:comment)
           objs_txt << dob.obj if dob.obj
        end
      end
      objs_txt << tex.dublincore << tex.tail
      objs_txt
    end
    def output(data)
      filename_texinfo=%{#{@env.processing_path.texi}/#{@md.fnb}.texinfo}
      file_texinfo=File.new(filename_texinfo,'w+')
      puts filename_texinfo if @md.opt.cmd =~/M/
      data.each {|s| (file_texinfo.puts s,"\n") if s}
      file_texinfo.close
    end
    def makeinfo
      if @md.fns =~/\.(?:-|ssm\.)?sst$/
        m=/(.+?)\.((?:-|ssm\.)?sst)$/.match(@md.fns)
        fnb,sfx=m[1],m[2]
        pwd=Dir.pwd
        case sfx
        when /(?:-|ssm\.)?sst$/
          @env=SiSU_Env::InfoEnv.new(@md.fns,@md.opt.cmd)
          Dir.chdir(@env.processing_path.texi)
          texinfo=SiSU_Env::SystemCall.new("#{fnb}.texinfo")
          texinfo.makeinfo
        end
        Dir.chdir(pwd)
      end
      def place_info
        unless FileTest.directory?(@f.output_path.texinfo.dir)
          FileUtils::mkdir_p(@f.output_path.texinfo.dir)
        end
        info_src=%{#{@env.processing_path.texi}/#{@md.fnb}.info}
        FileUtils::cp(info_src, @f.place_file.info.dir)
      end
    end
  end
end
__END__
