# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/help.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: interactive infomation/help

=end
module SiSU_Help
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Screen
  require_relative 'param'                              # param.rb
  class Help
     require_relative 'i18n'                             # i18n.rb
    def initialize(request='',color='')
      @request,@color=request,color
      @cX=(color =~/color_off/) \
      ? (SiSU_Screen::Ansi.new('k').cX)
      : (SiSU_Screen::Ansi.new('yes').cX)
      fns='help_example_dummy_file_name.sst'
      @env=SiSU_Env::InfoEnv.new(fns)
      @db=SiSU_Env::InfoDb.new
      m=/.+\/(?:src\/)?(\S+)/im # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
      @output_stub=Dir.pwd[m,1]
    end
    def help_request
      begin
        gotten=nil
        regx=/^(list|com(?:mands)?|mod(?:ifiers)|markup|syntax|example(?:_v1|_v2)?|head(?:ers?)?|(?:heading|title|level|structure)s?|endnotes|footnotes|tables?|customise|skin|dir(?:ectories)?|paths?|lang(?:uage)?|modules|setup|conf(?:ig(?:ure)?)?|standards?|li[cs]en[sc]e|scratch|install|termsheet|dublin(?:core)?|dc|customise|styles?|appearance|theme|env(ironment)?|dir(?:ector(?:y|ies))?|metaverse|abstract|features|summary|(?:short)?cuts?|sisu|about|ext(?:ernal)?(?:_?prog(?:rams)?)?)|utf-?8|plaintext|html|xml|xhtml|epub|odf|odt|opendocument|css|pdf|latex|tex|(?:tex)?info|search|(?:hyper)?est(?:raier)?|searchform|cgi|sql|db|pg|postgresql|pg?sql|sqlite|convert|php|webrick|sitemaps?|ya?ml|ansi|colors|-[AabcDdEeFHhIMmNnopqrRSstUuVvwXxyZz0-9]|-[Ddcv]|-[CcFLSVvW]/
      help_info=%{#{@cX.blue_hi}SiSU help#{@cX.off} #{@cX.ruby}~#{@cX.off} #{@request}}
      help_list=%{#{@cX.blue}sisu --help#{@cX.off} #{@cX.cyan}type keyword else "enter" to exit help:\n\tkeywords include:#{@cX.off} #{@cX.brown}list, (com)mands, short(cuts), (mod)ifiers, (env)ironment, markup, syntax, headers, headings, endnotes, tables, example, customise, skin, (dir)ectories, path, (lang)uage, db, install, setup, (conf)igure, convert, termsheet, search, sql, features, license#{@cX.off} \n}
      help_prompt=%{#{@cX.fuschia}exit, [or carriage return to exit help] #{@cX.off}\n#{@cX.blue_hi}SiSU help#{@cX.off} #{@cX.ruby}~#{@cX.off} }
        until gotten =~/exit|quit|bye|q|^\s*$/ \
        and ( @request.nil? or @request.empty? )
          @help=Help.new(@request,@color)
          if @request
            puts help_info
            gotten=@request
            @request=nil
          end
          case gotten
          when /h((?:elp)| )|~/i
            @help.summary
            help_@request
          when /list/;                                     @help.summary
          when /com(mands)?/;                              @help.commands
          when /mod(ifiers)?/;                             @help.modifiers
          when /markup|syntax/;                            @help.markup
          when /example\b/;                                @help.example_v2
          when /example_v1/;                               @help.example_v1
          when /example(_v2)?/;                            @help.example_v2
          when /(?:heading|title|level)s?|structure/;      @help.headings
          when /head(ers?)?/;                              @help.headers
          when /dublin(core)?|dc/;                         @help.dublin_core
          when /(?:foot|end)notes/;                        @help.endnotes
          when /tables?/;                                  @help.tables
          when /customise|skin/;                           @help.customise
          when /modules/;                                  @help.modules
          when /env(ironment)?/;                           @help.environment
          when /dir(ector(y|ies))?/;                       @help.directories
          when /paths?/;                                   @help.path
          when /setup/;                                    @help.setup
          when /conf(?:ig(?:ure)?)?/;                      @help.configure
          when /standards?/;                               @help.standards
          when /lang(?:uage)?/;                            @help.languages
          when /li[cs]en[sc]e/;                            @help.license
          when /scratch/;                                  @help.scratch
          when /install/;                                  @help.install
          when /(?:--)?termsheet/;                         @help.termsheet
          when /customise|styles?|appearance|theme/;       @help.customise
          when /metaverse/;                                @help.dal
          when /(?:--)?plaintext|(?:--)?te?xt|-[aAeE]/;    @help.plaintext
          when /utf-?8/i;                                  @help.utf8
          when /(?:--)?html|-[hH]/;                        @help.html
          when /css/;                                      @help.css
          when /(?:--)?xhtml|-b/;                          @help.xhtml
          when /(?:--)?xml|-[xX]/;                         @help.xml
          when /(?:--)?odf|(?:--)?odt|opendocument|-o/;    @help.odf
          when /(?:--)?epub|-e/;                           @help.epub
          when /php/;                                      @help.php
          when /(?:--)?pdf|-p/;                            @help.pdf
          when /latex|tex/;                                @help.latex
          when /(tex)?info/;                               @help.texinfo
          when /lout/;                                     @help.lout
          when /concordance|index|-w/;                     @help.concordance
          when /search\b/;                                 @help.help_search
          when /(?:hyper)?est(?:raier)?/;                  @help.hyperestraier
          when /db|database|sql|postgresql|(?:--)?sqlite|(?:--)?pg|pg?sql|-[dD]/; @help.sql
          when /searchform|cgi/;                           @help.cgi
          when /convert/;                                  @help.convert
          when /(?:--)?webrick|-W/;                        @help.webrick
          when /abstract|features|summary|about|sisu/;     @help.abstract
          when /ext(?:ernal)?(?:_?prog(?:rams)?)?/;        @help.external_programs
          when /ya?ml/;                                    @help.yaml
          when /sitemaps?/;                                @help.sitemap
          when /(?:short)?cuts?/;                          @help.shortcuts
          when /ansi|colors?/;                             SiSU_Screen::Ansi.new('c').colors
          else                                             @help.summary
          end
          print help_list
          print help_prompt
          gotten=nil
          gotten=gets
        end
      rescue
        #STDERR.puts Ansi.new($!, $@).rescue
        # dies silently... for now, silence of use in connection with "sisu ~ commands" etc.
      ensure
      end
    end
    def summary
      print <<WOK
    SiSU, Copyright (C) 1997 - 2013 Ralph Amissah
    License GPL version 3 or Later. This program comes with ABSOLUTELY NO WARRANTY;
    This is free software, and you are welcome to redistribute it under the conditions of the GPL3 or later.
    For more license detail type/enter: "sisu --help license"

for help type 'sisu --help', 'sisu --help [help request]', 'man sisu', (or see the system or online documentation)

typing "sisu" on its own or "sisu --help", should give you this sisu help summary and the sisu (interactive help mode) help prompt, from which help on each keyword can be obtained.

alternatively typing #{@cX.orange}sisu --help#{@cX.off} #{@cX.green}[keyword]#{@cX.off} at the command prompt will provide the sisu help page requested and return to the command prompt (if nothing is found it will print this page and return to the command prompt)

  Keywords (related to using SiSU)
      #{@cX.green}help#{@cX.off} or #{@cX.green}list#{@cX.off}   this sisu help summary
      #{@cX.green}commands#{@cX.off}       sisu --help commands
      #{@cX.green}environment#{@cX.off}    sisu --help env
    ------------------------------------------
    Preparing Documents for SiSU
      #{@cX.green}markup#{@cX.off}         sisu --help markup     (an incomplete overview)
      #{@cX.green}headers#{@cX.off}        sisu --help headers    (document-wide instructions, meta-data)
      #{@cX.green}structure#{@cX.off}      sisu --help structure  (document structure, headings, tables of contents)
      #{@cX.green}endnotes#{@cX.off}       sisu --help endnotes
      #{@cX.green}tables#{@cX.off}         sisu --help tables
      #{@cX.green}example 1.0#{@cX.off}    sisu --help example_v1
      #{@cX.green}example 2.0#{@cX.off}    sisu --help example
    ------------------------------------------
      #{@cX.green}search#{@cX.off}         sisu --help search
    ------------------------------------------
      #{@cX.green}customise#{@cX.off}      sisu --help customise
    ------------------------------------------
    SiSU's License
      #{@cX.green}license#{@cX.off}        sisu --help license

for help type 'sisu --help', 'sisu --help [help request]', 'man sisu', (or see the system or online documentation)
WOK
     # #{@cX.cyan}sisu_convert#{@cX.off}   program for initial (very basic and partial) conversion to sisu file format (html and word97 supported)
  end
  def abstract
    print <<WOK
Features:
#{@cX.cyan}(i)#{@cX.off} minimal markup requirement
#{@cX.cyan}(ii)#{@cX.off} single file marked up for multiple outputs
#{@cX.cyan}(iii)#{@cX.off} markup is simpler than html
#{@cX.cyan}(iv)#{@cX.off} the simple syntax is mnemonic, influenced by mail/messaging/wiki markup practices
#{@cX.cyan}(v)#{@cX.off} human readable, and easily writable
#{@cX.cyan}(vi)#{@cX.off} multiple outputs include amongst others: html; pdf via LaTeX; (structured) XML; sql - currently PostgreSQL and sqlite; plaintext, (also texinfo)
#{@cX.cyan}(vii)#{@cX.off} all text objects (headings and paragraphs) are numbered identically, for citation purposes, in all outputs (html, pdf, sql etc.)
#{@cX.cyan}(viii)#{@cX.off} creates organised directory/file structure for output
#{@cX.cyan}(ix)#{@cX.off} easily mapped with its clearly defined structure, with all text objects numbered, you know in advance where in each document output type, a bit of text will be found (eg. from an sql search, you know where to go to find the prepared html output or pdf etc.)... there is more
#{@cX.cyan}(x)#{@cX.off} use of Dublin Core and other meta-tags to permit the addition of some semantic information on documents, and making easy integration of rdf/rss feeds etc.
#{@cX.cyan}(xi)#{@cX.off} very easily skinnable, document appearance on a project/site wide, or document instance level easily controlled/changed
#{@cX.cyan}(xii)#{@cX.off} in many cases a regular expression may be used (once in the document header) to define all or part of a documents structure obviating or reducing the need to provide structural markup within the document
#{@cX.cyan}(xiii)#{@cX.off} is a batch processor for handling large document sets, ... though once generated they need not be re-generated, unless changes are made to the desired presentation of a particular output type
#{@cX.cyan}(xiv)#{@cX.off} possible to pre-process, which permits the easy creation of standard form documents, and templates/term-sheets
#{@cX.cyan}(xv)#{@cX.off} extremely modular, (thanks in no small part to Ruby) another output format required, write another module....
#{@cX.cyan}(xvi)#{@cX.off} easy to update output formats (eg html, xhtml, latex/pdf produced can be updated in program and run against whole document set)
#{@cX.cyan}(xvii)#{@cX.off} easy to add, modify, or have alternative syntax rules for input, should you need to
#{@cX.cyan}(xviii)#{@cX.off} "Concordance" wordmap, consisting of all the words in a document and their (text object) locations within the text
#{@cX.cyan}(xix)#{@cX.off} tied to revision control system, only code and marked up file need be backed up, to be sure of the much larger document set
#{@cX.cyan}(xx)#{@cX.off} syntax highlighting files for markup, primarily (g)vim so far.

SiSU was developed in relation to legal documents, and so is strong across a wide variety of texts (law, literature...), though weak on formulae/statistics, it does handle images. An assumption has been document sets that are to be preserved and maintained over time (also a result of the legal text origin). SiSU has been developed and used over a number of years, and the requirements to cover a wide range of documents have been thoroughly explored.

There is more detailed information available on it from:
  #{@cX.blue}http://www.jus.uio.no/sisu#{@cX.off}
 *  plaintext
 *  html
 *  XML (structured)
 *  LaTeX/pdf
 *  texinfo
 *  sql (at present postgresql & sqlite)

A couple of sample inputs and outputs:

The markup for "War and Peace" (chosen because it is a large text & to test the use of SiSU on Project Gutenberg's plaintext), this is the markup, very little after the headers (there is an insert of their legal notices). Took no time at all, it is a particularly simple text to markup though
A simple document                                                              and a more demanding document
         #{@cX.blue}http://www.jus.uio.no/sisu/sample/war.and.peace.leo.tolstoy.er20      http://www.jus.uio.no/sisu/sample/autonomy.markup1.er30#{@cX.off}
Some resulting outputs:
  html   #{@cX.blue}http://www.jus.uio.no/sisu/war.and.peace.leo.tolstoy/                 http://www.jus.uio.no/sisu/autonomy.markup1/#{@cX.off}
                                                                               #{@cX.blue}http://www.jus.uio.no/sisu/autonomy.markup1/doc#{@cX.off}
  pdf    #{@cX.blue}http://www.jus.uio.no/sisu/war.and.peace.leo.tolstoy/portrait         http://www.jus.uio.no/sisu/autonomy.markup1/portrait
         #{@cX.blue}http://www.jus.uio.no/sisu/war.and.peace.leo.tolstoy/landscape        http://www.jus.uio.no/sisu/autonomy.markup1/landscape#{@cX.off}
  plaintext  #{@cX.blue}http://www.jus.uio.no/sisu/war.and.peace.leo.tolstoy/doc.txt          http://www.jus.uio.no/sisu/autonomy.markup1/doc.txt#{@cX.off}
WOK
    end
    def commands
      print <<WOK

 #{@cX.ruby}-a#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces plaintext with Unix linefeeds. Without markup, (object numbers are omitted), has footnotes at end of each para‐ graph that contains them. Modifier options available: --footnotes (default) or --endnotes and for linefeeds --unix (default) or --msdos

 #{@cX.ruby}-b#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces xhtml/XML output for browser viewing (sax parsing)

 #{@cX.ruby}-C#{@cX.off} initialise shared output directory (config files such as css and dtd files are not updated if they already exist unless modifier is used) #{@cX.ruby}-C --init=site#{@cX.off} configure/initialise site more extensive than -C on its own, shared output directory files/force update, existing shared output config files such as css and dtd files are updated if this modifier is used. in a new markup document working directory should initialise the corresponding output directory, though SiSU will automatically do this, the first time it is run (for processing) in a given directory.

 #{@cX.ruby}-c#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} screen toggle ansi screen colour on or off depending on default set (unless -c flag is used: if sisurc colour default is set to ´true´, output to screen will be with colour, if sisurc colour default is set to ´false´ or is undefined screen output will be without colour)

 #{@cX.ruby}-D#{@cX.off} #{@cX.green}[instruction]#{@cX.off} #{@cX.green}[filename]#{@cX.off} database instruction, see database section below

 #{@cX.ruby}-d#{@cX.off} #{@cX.green}[instruction]#{@cX.off} #{@cX.green}[filename]#{@cX.off} database instruction, see database section below [only -D currently available]

 #{@cX.ruby}-F#{@cX.off} generate examples of (naive) cgi search form for sqlite and pgsql depends on your already having used sisu to populate an sqlite and/or pgsql database, (the sqlite version scans the output directories for existing sisu_sqlite databases, so it is first necessary to create them, before generating the search form) see -d -D and the database section below. If the optional parameter webrick is passed, the cgi examples created will be set up to use the default port set for use by the webrick server, (otherwise the port is left blank and the system setting used, usually 80). The samples are dumped in the present work directory which must be writable, (with screen instructions given that they be copied to the cgi-bin directory).

 #{@cX.ruby}-H#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces html (css version) (creates html (using css)), with url link suffixes (.html .pdf etc.) omitted ("Hide"). For web servers that are confireud so as not to require file extensions to locate and serve files. [behaviour switched see -h]

 #{@cX.ruby}-h#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces html (hardlinks i.e. with name suffixes in links/local urls). html, with internal document links that include the document suffix, ie whether it is .html or .pdf (required for browsing directly off a file system, and works with most web servers). [behaviour switched see -H]

 #{@cX.ruby}-I#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces texinfo file with its myriad of possibilities

 #{@cX.ruby}-L#{@cX.off} prints license information

 #{@cX.ruby}-M#{@cX.off} #{@cX.green}[filename/wildcard/url]#{@cX.off} maintenance mode, files created for processing are not deleted, and their locations are indicated (also see -V)

 #{@cX.ruby}-m#{@cX.off} #{@cX.green}[filename/wildcard/url]#{@cX.off} create (new)metaVerse (used in all subsequent processing). Produce a meta file, the first step in processing, and the file all subsequent processing utilize. (Should usually be run together with other commands to ensure that the lated version of markup source document is used, i.e. add -m flag to other flags required).

 #{@cX.ruby}-N#{@cX.off} #{@cX.green}[filename/wildcard/url]#{@cX.off} document content certificate as md5 digest tree of document produced (as digest.txt), the digest for the document, and digests for each object contained within the document (together with information on software versions that produced it). Try -mNV for verbose digest output to screen

 #{@cX.ruby}-n#{@cX.off} #{@cX.green}[filename/wildcard/url]#{@cX.off} skip meta-markup (building of "metaverse"), this skips the equivalent of -m

 #{@cX.ruby}-p#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces LaTeX pdf (portrait & landscape). Default paper size is set in config file, or document header, or provided with additional command line parameter, e.g. --papersize='a4' preset sizes include: 'A4', U.S. 'letter' and 'legal' and book sizes 'A5' and 'B5' (system defaults to A4).

 #{@cX.ruby}-q#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} quiet, less output to screen

 #{@cX.ruby}-r#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} copies sisu output files to remote host using scp (default). This requires that sisurc.yml has been provided with information on hostname and user name, and that you have your "keys" and ssh agent in place.

 #{@cX.ruby}-S#{@cX.off} #produces a sisupod, a zipped sisu directory of markup files including sisu markup source files and the directories local configuration file, images and skins. Note: this only includes the configuration files or skins contained in ./_sisu not those in ~/.sisu The resulting tar gzip file has a .zip suffix added to the markup source directory name. To tar and gzip individual files see the -Z [filename/wildcard] option. Note: (this option is tested only with zsh)

 #{@cX.ruby}-S#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces a sisupod a zipped sisu of the content assocated with the specified sisu markup documnt, i.e. including sisu markup source file, (and associated documents if a master file, or available in multilingual versions), together with related images and skin. The resulting zipped file has a .zip suffix added to the markup source file name by default, though a .ssp suffix is also recognised. The directory structure of the unzipped file is understood by sisu, and sisu commands can be run within it. SiSU commands can be run against a sisupod contained in a local directory, or provided as a url on a remote site. As there is a security issue with skins provided by other users, they are not applied unless the flag --trust or --trusted is added to the command instruction, it is recommended that file that are not your own are treated as untrusted. This provides a convenient way of packing documents files for sending Note: if you wish to send multiple files, it quickly becomes more space efficient to tar and gzip the sisu markup directory, (without the _sisu_processing subdirectory) rather than the individual files for sending). See the -S option without [filename/wildcard]

 #{@cX.ruby}-T#{@cX.off} #{@cX.green}[filename/wildcard (*.termsheet.rb)]#{@cX.off} standard form document builder, preprocessing feature

 #{@cX.ruby}-t#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces plaintext with Unix linefeeds. Without markup, (object numbers are omitted), has footnotes at end of each para‐ graph that contains them. Modifier options available: --footnotes (default) or --endnotes and for linefeeds --unix (default) or --msdos

 #{@cX.ruby}-U#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} prints url list/map for the available processing flags options and resulting files that could be requested, (can be used to get a list of processing options in relation to a file, together with information on the output that would be produced), -u provides url mapping for those flags requested for processing. The default assumes sisu_webrick is running and provides webrick url mappings where appropriate, but these can be switched to file system paths in sisurc.yml

 #{@cX.ruby}-u#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} provides url mapping of output files for the flags requested for processing, also see -U

 #{@cX.ruby}-V#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} on its own provides SiSU version and environment information (sisu --help env)

 #{@cX.ruby}-V#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} even more verbose than -v the -V flag provides some additional information, also see -M

 #{@cX.ruby}-v#{@cX.off} on its own, provides SiSU version information.

 #{@cX.ruby}-v#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} provides more verbose output of what is being built, where it is being built (and error messages if any), as with -u flag provides a url mapping of files created for each of the processing flag requests

 #{@cX.ruby}-X#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces XML output with deep document structure, in the nature of dom

 #{@cX.ruby}-x#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces XML output (sax parsing)

 #{@cX.ruby}-W#{@cX.off} #{@cX.green}[port]#{@cX.off} starts ruby´s webrick webserver, points at sisu output directories (default port is set)

 #{@cX.ruby}-w#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces concordance, a rudimentary index of all the words in a document

 #{@cX.ruby}-Z#{@cX.off} Zap, if used with other processing flags #{@cX.green}deletes output files#{@cX.off} of the type about to be processed, prior to processing. If -Z is used as the lone processing related flag (or in conjunction with a combination of -[mMvVq]), will remove the related document output directory.

 #{@cX.ruby}-z#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} produces php (zend) [feature disabled, depreciated]

 #{@cX.ruby}--harvest#{@cX.off} #{@cX.green}*.ss[tm]#{@cX.off} makes two lists of sisu output based on the sisu markup documents in a directory: list of author and authors works (year and titles), and; list by topic with titles and author. Makes use of header metadata fields (author, title, date, topic_register). Can be used with -M and -R flags.

 #{@cX.ruby}databases#{@cX.off}

 #{@cX.ruby}dbi - database interface -D or --pgsql set for postgresql -d or --sqlite set for sqlite#{@cX.off}

 #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--create#{@cX.off} creates empty postgresql db and required tables & indexes (rb.dbi) [#{@cX.ruby}-d --create#{@cX.off} sqlite equivalent] it may be necessary to first run sisu #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--createdb#{@cX.off}

 #{@cX.ruby}-Di#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} or #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--import#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} imports data specified to postgresql db (rb.dbi) [#{@cX.ruby}-d --import#{@cX.off} sqlite equivalent]

 #{@cX.ruby}-Du#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} or #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--update#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} updates/imports specified data to postgresql db (rb.dbi) [#{@cX.ruby}-d --update#{@cX.off} sqlite equivalent]

 #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--remove#{@cX.off} #{@cX.green}[filename/wildcard]#{@cX.off} removes specified data to postgresql db (rb.dbi) [#{@cX.ruby}-d --remove#{@cX.off} sqlite equivalent]

 #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--dropall#{@cX.off} kills data" and drops (postgresql) db, tables & indexes [#{@cX.ruby}-d --dropall#{@cX.off} sqlite equivalent]

 #{@cX.ruby}-D#{@cX.off} #{@cX.ruby}--recreate#{@cX.off} kills data" and drops (postgresql or sqlite) db, tables & indexes, then creates an empty db with tables and indexes [#{@cX.ruby}-d --recreate#{@cX.off} sqlite equivalent]

  also see command #{@cX.green}shortcuts#{@cX.off}, and shorthand mappings for multiple flags
WOK
    end
    def shortcuts
      cf_defaults=SiSU_Env::InfoProcessingFlag.new
      print <<WOK

 #{@cX.ruby}Shorthand for multiple flags#{@cX.off}

        #{@cX.ruby}--update#{@cX.off}  #{@cX.green}[filename/wildcard]#{@cX.off} Checks  existing file output and runs the flags required to update this output. This means that if only html and pdf output  was  requested  on previous  runs, only the -hp files will be applied, and only these will be generated this time, together with the summary.  This  can  be  very convenient, if you offer different outputs of different files, and just want to do the same again.

       #{@cX.ruby}-0#{@cX.off} to #{@cX.ruby}-5#{@cX.off} #{@cX.green}[filename or wildcard]#{@cX.off}
       #{@cX.green}Default shorthand mappings#{@cX.off} (note that the defaults can be changed in the #{@cX.green}sisurc.yml#{@cX.off} file):

                                                  (these can be turned off if unavailable in sisurc.yml under program_set:)
  #{@cX.green}processing shortcut defaults set to:#{@cX.off}
  color defaut set (on==true)                    #{@cX.blue}#{cf_defaults.color}#{@cX.off}
  sisu -0 (also just "sisu")                     #{@cX.blue}#{cf_defaults.cf_0}#{@cX.off}
  sisu -1                                        #{@cX.blue}#{cf_defaults.cf_1}#{@cX.off}
  sisu -2                                        #{@cX.blue}#{cf_defaults.cf_2}#{@cX.off}
  sisu -3                                        #{@cX.blue}#{cf_defaults.cf_3}#{@cX.off}
  sisu -4                                        #{@cX.blue}#{cf_defaults.cf_4}#{@cX.off}
  sisu -5                                        #{@cX.blue}#{cf_defaults.cf_5}#{@cX.off}
  defaults may be changed in active sisurc.yml file under 'flag:'

       add -v for verbose mode and -c (color toggle), e.g.
       sisu -2vc [filename  or  wildcard]
WOK
    end
    def modifiers
      print <<WOK

 #{@cX.ruby}Command flag modifiers#{@cX.off}

  #{@cX.ruby}--no-ocn#{@cX.off} [with -h -H or -p] switches off object citation numbering. Produce  output without identifying numbers in margins of html or LaTeX/pdf output.

  #{@cX.ruby}--no-annotate#{@cX.off} strips output text of editor endnotes~[* square brackets ]~ denoted by asterisk or dagger/plus sign

  #{@cX.ruby}--no-asterisk#{@cX.off} strips output text of editor endnotes~[* square brackets ]~ denoted by asterisk

  #{@cX.ruby}--no-dagger#{@cX.off} strips output text of editor endnotes~[+ square brackets ]~ denoted by dagger/plus sign

WOK
    end
    def misc
      <<WOK
  #{@cX.cyan}misc#{@cX.off}
  #{@cX.green}-s#{@cX.off} [filename or wildcard]          #{@cX.green}spellcheck#{@cX.off} (aspell previously ispell
  \t#{@cX.green}mailer examples#{@cX.off}
  from vim mail.er10 (not gvim) issue command
  \t:! ruby -S mailer.rb instruction/landscape|a4l|portrait|a4p/ email@address/alias subject line
  \t:! ruby -S mailer.rb a4l ralph@amissah.com testing continues
  from vim mail.er10 use your vim alias \\mail or \\mutt (modify command line as required)
  #{@cX.green}feeds rss/rdf#{@cX.off}
  #{@cX.blue}-R #{@cX.off} (yaml|rss)  extraction of semantic data into yaml file for auto build of xml feeds (rss, rdf) #{@cX.fuschia}[work area]#{@cX.off}
  #{@cX.green}-R #{@cX.off} yaml  extraction of semantic data into yaml file for auto build of xml feeds (rss, rdf)
  #{@cX.green}-R #{@cX.off} rss   creates rss2.0 feed
WOK
    end
    def markup
      print <<WOK
sisu
  Note: files for SiSU should be in UTF-8 character encoding.

  #{@cX.cyan}Data text markup#{@cX.off} (alternative to available html subset)
  #{@cX.green}% SiSU 2.00#{@cX.off}          [statement on first line of document, declared file-type identifier, SiSU markup document, markup used is version 0.38]

  #{@cX.green}A~#{@cX.off} heading/title    [levels A to C available (and beneath that 1 to 6)]

  #{@cX.green}1~#{@cX.off}filename heading   [segmentation level, levels 1 to 6 available]

  #{@cX.green}!{#{@cX.off}emphasis#{@cX.green}}!#{@cX.off}
  #{@cX.green}*{#{@cX.off}bold text#{@cX.green}}*#{@cX.off}
  #{@cX.green}_{#{@cX.off}underscore#{@cX.green}}_#{@cX.off}
  #{@cX.green}/{#{@cX.off}italics#{@cX.green}}/#{@cX.off}
  #{@cX.green}"{#{@cX.off}citation#{@cX.green}}"#{@cX.off}
  #{@cX.green}^{#{@cX.off}superscript#{@cX.green}}^#{@cX.off}
  #{@cX.green},{#{@cX.off}subscript#{@cX.green}},#{@cX.off}
  #{@cX.green}+{#{@cX.off}inserted text#{@cX.green}}+#{@cX.off}
  #{@cX.green}-{#{@cX.off}strikethrough#{@cX.green}}-#{@cX.off}

  ------------------------------------------
  #{@cX.cyan}Indentation and bullets#{@cX.off}

  #{@cX.green}_1#{@cX.off}                     indent paragraph one level

  #{@cX.green}_2#{@cX.off}                     indent paragraph two steps

  #{@cX.green}_*#{@cX.off}                     bullet text

  #{@cX.green}_1*#{@cX.off}                    bullet text, first indent

  ------------------------------------------
  #{@cX.cyan}Numbered List#{@cX.off} (not to be confused with headings/titles, (document structure))

  #{@cX.green}##{@cX.off} numbered list        numbered list 1., 2., 3, etc.

  #{@cX.green}_##{@cX.off} numbered list       numbered list indented second level a., b., c., d., etc.

  ------------------------------------------
  #{@cX.cyan}Endnotes#{@cX.off}

  #{@cX.green}~{#{@cX.off}footnote/endnote#{@cX.green}}~#{@cX.off}    endnote#{@cX.green}~{#{@cX.off}self contained endnote marker & endnote in one#{@cX.green}}~#{@cX.off}
  #{@cX.green}~{*#{@cX.off}asterisk footnote/endnote#{@cX.green}}~#{@cX.off}
  editor's annotations, square bracket notes
  #{@cX.green}~[*#{@cX.off}numbered asterisk footnote/endnote series#{@cX.green}]~#{@cX.off}
  #{@cX.green}~[+#{@cX.off}numbered dagger/plus sign footnote/endnote series#{@cX.green}]~#{@cX.off}
  ---
  alternative endnote pair notation
  #{@cX.green}~^#{@cX.off}                                           endnote marker
  #{@cX.green}^~#{@cX.off} endnote text following the paragraph in which the marker occurs

  ------------------------------------------
  #{@cX.cyan}Links#{@cX.off}

    http://url.org                           on its own would be automatically marked up and hyperlinked to itself
    #{@cX.green}{#{@cX.off} [text to link] #{@cX.green}}#{@cX.off}http://url.org
    #{@cX.green}{#{@cX.off}image.png#{@cX.green}}#{@cX.off}http://url.org
    #{@cX.green}{#{@cX.off}image.png#{@cX.green}}#{@cX.off}image    #{@cX.green}{#{@cX.off}tux.png 64#{@cX.green}x#{@cX.off}80#{@cX.green}}#{@cX.off}image
  Linked image example
    #{@cX.green}{#{@cX.off} SiSU Geek Writer #{@cX.green}}#{@cX.off}http://www.jus.uio.no/sisu/                   url example
    #{@cX.green}{#{@cX.off}tux.png 64#{@cX.green}x#{@cX.off}80 "a better way" #{@cX.green}}#{@cX.off}http://www.jus.uio.no/sisu/    image example with all options (width x height)
    Note: png and jpg support only (no gif support)

  shortcut - hyper-linked text with endnote providing the url information
    #{@cX.green}{~^#{@cX.off} [text to link] #{@cX.green}}#{@cX.off}http://url.org         maps to   #{@cX.green}{#{@cX.off} [text to link] #{@cX.green}}#{@cX.off}http://url.org #{@cX.green}~{#{@cX.off} http://url.org #{@cX.green}}~#{@cX.off}
     produces hyper-linked text within a document/paragraph, with an endnote providing the url for the text location used in the hyperlink

  shortcut:
    #{@cX.green}{#{@cX.off} [text to link] #{@cX.green}[3sS]}#{@cX.off}markup_source_filename.sst
    if  a  server host name has been provided/configured, will provide a list of available output types that would be generated using the shortcut command and the markup file provided, i.e. output generated using the command (as configured):
       "sisu -3sS markup_source_filename.sst"
    using server host, directory stub, filename to compose the link.

  ------------------------------------------
  adding fixed names in html, manual location marker/tagging
  #{@cX.green}*~[name]#{@cX.off}           <a name="[name]">

  ------------------------------------------
  #{@cX.green}~##{@cX.off}         unnumbered paragraph (place marker at end of paragraph)
  #{@cX.green}-##{@cX.off}         unnumbered paragraph, delete when not required (place marker at end of paragraph) [used in dummy headings, eg. for segmented html]

  ------------------------------------------
  manual page breaks (LaTeX/pdf)
  #{@cX.green}<:pb>#{@cX.off}  page  break,  which  breaks a page, starting a new page in single column text and a new column in double column text
  #{@cX.green}<:pn>#{@cX.off} page new, which starts a new page, in both single and double column text (leaving an empty column in double column text if necessary).
  Note: page breaks are usually introduced to pdfs either as header instructions, indicating that pages should break at given levels

  ------------------------------------------
  #{@cX.cyan}Composite documents#{@cX.off}

    It is possible to build a document by creating a master document that requires other documents. The documents required may complete documents that could be generated independently, or they could be markup snippets, prepared so as to be easily available to be placed within another text. If the calling document is a master document (built mainly from other documents), it should be named with the suffix #{@cX.blue}.ssm#{@cX.off} Within this document you would provide information on the other documents that should be included within the text. These may be other documents that would be processed in a regular way, or markup bits prepared only for inclusion within a master document #{@cX.blue}.sst#{@cX.off} regular markup file, or #{@cX.blue}.ssi#{@cX.off} (insert/information) A secondary file of the composite document is built prior to processing with the same prefix and the suffix #{@cX.blue}.ssm.sst#{@cX.off}

    #{@cX.cyan}#basic sisu markup alternatives#{@cX.off}
      #{@cX.green}{#{@cX.off}filename.ssi#{@cX.green}}require#{@cX.off}
      #{@cX.green}<< {#{@cX.off}filename.ssi#{@cX.green}}#{@cX.off}

    #{@cX.cyan}#using textlink alternatives#{@cX.off}
      #{@cX.green}|#{@cX.off}filename.ssi#{@cX.green}|@|^|require#{@cX.off}
      #{@cX.green}<< |#{@cX.off}filename.ssi#{@cX.green}|@|^|#{@cX.off}

    #{@cX.cyan}#using thlnk alternatives#{@cX.off}
      #{@cX.green}<url:#{@cX.off}filename.ssi#{@cX.green}>require#{@cX.off}
      #{@cX.green}<< <url:#{@cX.off}filename.ssi#{@cX.green}>#{@cX.off}

  #{@cX.cyan}Composite documents - remote parts#{@cX.off}
    Composite documents may be built from remote parts, by using the composite document syntax with a url. This makes sense using either sisu regular syntax (which is just a convenient way of marking up), or thlnk syntax, which also recognises remote urls, and permits hyperlinking ascii to the url location.

  #{@cX.cyan}Remote documents#{@cX.off}
    SiSU will download and process remote locations if a url is provided instead of a filename. [this at present works only for sisu markup files without images]

  ------------------------------------------
  #{@cX.green}%#{@cX.off}#{@cX.off}       add a comment to text, that will be removed prior to processing (place marker at beginning of line)
  #{@cX.green}\\#{@cX.off}#{@cX.off}       escape a sepcial character, whether general: { } < > or contextual special characters, (in combination with  other  characters) ~  - _ / % ^ and occasionally ! # + ,
  #{@cX.green}%%#{@cX.off}#{@cX.off}      same as above but recognised by vim folds for placing fold in document text, in addition to headers and headings
  ------------------------------------------

  #{@cX.ruby}More HELP on Markup#{@cX.off} markup help is available on:
    document wide instructions: headers (document structure)
    general text markup: headings; endnotes; tables (which also includes a note on preformatted text)
  configuration and customisation
    document or site wide customisation: customise; skin
WOK
      help_markup
#  {../_sisu/image/tux.png http://www.jus.uio.no/sisu/ w=64 c=\"a better way\" }:image        depreciated image eg
#  <!image http://www.jus.uio.no/sisu/ ../_sisu/image/tux.png  width=\"64\" height=\"80\" !>   old form
    end
    def example
      help_markup
    end
    def example_v1
      print <<WOK
% SiSU 1.0

@title: Working Sample Document

@subtitle: Demonstrating markup

@creator: Ralph Amissah

@date:

@markup: num_top=4

@bold: [regular expression of words/phrases to be made bold]

@italics: [regular expression of words/phrases to italicise]

@links: { SiSU }http://www.jus.uio.no/sisu { FSF }http://www.fsf.org

A~ A Sample Document

B~ just for fun

1~ This is Chapter One or Article One

Ordinary Text follows here. The Title would be a Chapter or Article depending on the type of document you were working to produce.

1~ This would be Chapter Two or Article Two

And so on.

Assuming sisu is configured properly so it has been instructed where to put the work files and ouput files, you would generate this text once saved, with the suffix .sst if saved as example.sst, by typing sisu -mhwxp example.sst while in the directory in which the file is saved.

_1 -m initial processing, -h html (css based), -w concordance for html, -x xml, -p pdf output, generated via latex, there are of course additional options

_1 for a listing type: sisu ~ commands

_1 for an outline of sisu markup type: sisu ~ markup

The example ends here.
WOK
    help_markup
  end
    def example_v2
      print <<WOK
% SiSU 2.0

@title: Working Sample Document
 :subtitle: Demonstrating markup

@creator:
 :author: Amissah, Ralph

@date:
 :published: 2010-09-18

@rights:
 :copyright: Ralph Amissah

@make:
 :num_top: 1
 :bold: [regular expression of words/phrases to be made bold]
 :italics: [regular expression of words/phrases to italicise]

@links:
 { SiSU }http://www.jus.uio.no/sisu { FSF }http://www.fsf.org

A~ @title @author

B~ just for fun

1~ This is Chapter One or Article One

Ordinary Text follows here. The Title would be a Chapter or Article depending on the type of document you were working to produce.

1~ This would be Chapter Two or Article Two

And so on.

Assuming sisu is configured properly so it has been instructed where to put the work files and ouput files, you would generate this text once saved, with the suffix .sst if saved as example.sst, by typing sisu -mhwxp example.sst while in the directory in which the file is saved.

_1 --dal initial processing, --html (css based), --concordance (html), --epub, --odt, --pdf output, generated via LaTeX, there are of course additional options

_1 for a listing type: sisu ~ commands

_1 for an outline of sisu markup type: sisu ~ markup

The example ends here.
WOK
    help_markup
  end
  def headers
    print <<WOK
Header tags appear at the beginning of a document and provide meta information on the document (such as the Dublin Core), or information as to how the document as a whole is to be processed.
All header instructions take either the form #{@cX.green}@headername:#{@cX.off} followed on the next line by an indented sub-category header if any #{@cX.green}:sub-headername:#{@cX.off}.
#{@cX.green}@indentifier:#{@cX.off} information or instructions
where the #{@cX.green}"identifier"#{@cX.off} is a tag recognised by the program, and the #{@cX.green}"information"#{@cX.off} or #{@cX.green}"instructions"#{@cX.off} belong to the tag/indentifier specified
 Note: a header where used should only be used once; all  headers  apart from #{@cX.ruby}@title:#{@cX.off} are optional.

#{@cX.ruby}@title:#{@cX.off} My Title - This is now the Title of the Document and used as such
  #{@cX.cyan}:subtitle:#{@cX.off} The Subtitle if any

#{@cX.ruby}@creator:#{@cX.off}
  #{@cX.cyan}:author:#{@cX.off} Surname, Other names (if more than one author separate author names with a semi colon, if name is of an institution just write name or the name contains a comma enclose in quotation marks)
  #{@cX.cyan}:contributor:#{@cX.off}
  #{@cX.cyan}:translator:#{@cX.off} [or :translated_by:]
  #{@cX.cyan}:illustrator:#{@cX.off} [or :illustrated_by:]
  #{@cX.cyan}:prepared_by:#{@cX.off} [or :digitized_by:]

#{@cX.ruby}@date:#{@cX.off}
  #{@cX.cyan}:published:#{@cX.off}
  #{@cX.cyan}:created:#{@cX.off}
  #{@cX.cyan}:issued:#{@cX.off}
  #{@cX.cyan}:available:#{@cX.off}
  #{@cX.cyan}:valid:#{@cX.off}
  #{@cX.cyan}:modified:#{@cX.off}

#{@cX.ruby}@rights:#{@cX.off}
  #{@cX.cyan}:copyright:#{@cX.off} Author's name, all rights reserved
  #{@cX.cyan}:license:#{@cX.off} public domain, copyleft, creative commons variant, etc.

#{@cX.ruby}@classify:#{@cX.off}
  #{@cX.cyan}:topic_register:#{@cX.off} [e.g.:] text markup language; application:text processing;output:html|xml|latex|pdf|sql
  #{@cX.cyan}:subject:#{@cX.off} (whatever your subject)
  #{@cX.cyan}:keywords:#{@cX.off}
  #{@cX.cyan}:coverage:#{@cX.off}
  #{@cX.cyan}:relation:#{@cX.off}
  #{@cX.cyan}:type:#{@cX.off}
  #{@cX.cyan}:identifier:#{@cX.off}
  #{@cX.cyan}:loc:#{@cX.off} [Library of Congress classification]
  #{@cX.cyan}:dewey:#{@cX.off} [Dewey classification]
  #{@cX.cyan}:isbn:#{@cX.off}
  #{@cX.cyan}:oclc:#{@cX.off}

#{@cX.ruby}@notes:#{@cX.off}
  #{@cX.cyan}:description:#{@cX.off}
  #{@cX.cyan}:abstract:#{@cX.off}
  #{@cX.cyan}:comment:#{@cX.off}
  #{@cX.cyan}:history:#{@cX.off}
  #{@cX.cyan}:prefix:#{@cX.off}
  #{@cX.cyan}:suffix:#{@cX.off}

#{@cX.ruby}@publisher:#{@cX.off}

#{@cX.ruby}@language:#{@cX.off} [or @language.document:] [country code for language if available, or language, English, en is the default setting] (en - English, fr - French, de - German, it - Italian, es - Spanish, pt - Portuguese, sv - Swedish, da - Danish, fi - Finnish, no - Norwegian, is - Icelandic, nl - Dutch, et - Estonian, hu - Hungarian, pl - Polish, ro - Romanian, ru - Russian, el - Greek, uk - Ukranian, tr - Turkish, sk - Slovak, sl - Slovenian, hr - Croatian, cs - Czech, bg - Bulgarian ) [however, encodings are not available for all of the languages listed.]

#{@cX.ruby}@language.original:#{@cX.off}
original language in which the work was published

#{@cX.ruby}@links:#{@cX.off}
  { SiSU }http://www.jus.uio.no/sisu/
  { FSF }http://www.fsf.org

#{@cX.ruby}@make:#{@cX.off}
  #{@cX.cyan}:breaks:#{@cX.off} new=:B; break=1
  #{@cX.cyan}:bold:#{@cX.off} [regular expression of words/phrases to be made bold]
  #{@cX.cyan}:italics:#{@cX.off} [regular expression of words/phrases to italize]
  #{@cX.cyan}:headings:#{@cX.off} PART; CHAPTER; Section; Article;
     #{@cX.grey}% optional, document structure can be defined by words to match or regular expression (the regular expression is assumed to start at the beginning of a line of text i.e. ^) default markers A~ to C~ and 1~ to 6~ can be used within text instead, without this header tag, and may be used to supplement the instructions provided in this header tag if provided#{@cX.off}
  #{@cX.cyan}:papersize:#{@cX.off} (A4|US_letter|book_B5|book_A5|US_legal)
  #{@cX.cyan}:markup:#{@cX.off} num_top=4 [various markup instructions, eg: num_top=4 headings tobe numbered, starting at heading level 4... the default is to provide 3 levels, as in 1 level 4, 1.1 level 5, 1.1.1 level 6, markup to be merged within level]
  #{@cX.cyan}:promo:#{@cX.off} sisu, ruby, search_libre_docs, open_society [places content in right pane in html, makes use of list.yml and promo.yml, commented out sample in  document  sample:  free_as_in_freedom.richard_stallman_crusade_for_free_software.sam_williams.sst]

#{@cX.grey}% header ends here, NB only @title: is mandatory [this would be a comment]#{@cX.off}

#{@cX.blue}A~#{@cX.off} Top level heading [this is usually the same as the title @title: ]

#{@cX.blue}B~#{@cX.off} Second level heading [this is a heading level divider]

#{@cX.blue}C~#{@cX.off} Third level heading [this is a heading level divider]

#{@cX.blue}1~#{@cX.off} Top level heading preceding substantive text of document or sub-heading 5, the heading level that would normally be marked 1. or 2. or 3. etc. in a document

#{@cX.blue}2~#{@cX.off} Second level heading preceding substantive text of document or sub-heading 6, the heading level that would normally be marked 1.1 or 1.2 or 1.3 or 2.1 etc in a document

#{@cX.blue}3~#{@cX.off} Third level heading preceding substantive text of document, that would normally be marked 1.1.1 or 1.1.2 or 1.2.1 or  2.1.1 etc. in a document

WOK
      help_markup
    end
    def customise
      print <<WOK
    There are a number of files that control the appearance of a site or a document i.e.

    #{@cX.blue}(i)#{@cX.off} files that control #{@cX.green}site-wide appearance#{@cX.off}:

        #{@cX.green}defaults.rb#{@cX.off}  initial values used by program, not necessary to change

        skins are placed in a configuration directory beneath the markup directory ./_sisu/skin/doc or in ~/.sisu/skin/doc
        if a skin is also to be used for a directory or site wide presentations, rather than being called for a single document then a softlink is placed from ~/.sisu/skin/dir or ~/.sisu/skin/site respectively to the relevant skin within ~/.sisu/skin/doc

        rules for skin loading are in #{@cX.green}sysenv.rb#{@cX.off}
        the skin loading heuristics / hierarchy is currently as follows:

          a. if there is a skin requested within a document, thent that skin is used
            0~skin skin_lm (would load skin ~/.sisu/skin/doc/skin_lm.rb)

          b. use it if there is a "dir" skin with the same name as the source directory "stub" i.e.
            if working in a directory called /home/myhome/workdir/lm
            then if ~/.sisu/skin/dir/skin_lm.rb were found it would be used and skin_lm.rb would be a softlink to the relevant skin in the document skin directory (where all the actual skins are kept)

          x. [additionally though discouraged a special rule can be set up in sysenv  AddSkin.select (which could override b if desired)]

        #{@cX.green}skin_site_#{@cX.off}#{@cX.cyan}[name of site skin in use]#{@cX.off}#{@cX.green}.rb#{@cX.off}  this file is called by skin.rb
          if there are several such files, site appearance may be changed by
          requesting the skin_site desired from skin.rb
    and

    #{@cX.blue}(ii)#{@cX.off} presentation maintenance:
          if you have a body of documents the easiest way to give them a particular appearance/skin, is to associate that directory with a skin, all files in that directory take on the specified appearance, changing appearance of documents once directories are set up is as simple as copying the files from one directory to another (or renaming the directory); or associating the directory with a different skin.

    see also directories
WOK
    end
    def configure
      print <<WOK
      see the following topics
        install
        setup
        and note for initial configuration it is necessary to run:
          sisu -C
          (this places the default CSS files and DTDs in place)
WOK
    end
    def path
      help_env
      puts <<WOK

If you have problems check permissions (and if in home directory ownership).

#{@cX.green}directory paths as currently set#{@cX.off}:
  output docs:                 #{@cX.blue}#{@env.path.webserv}#{@cX.off}
  cgi scripts:                 #{@cX.blue}#{@env.path.cgi}#{@cX.off}
  processing:                  #{@cX.blue}#{@env.processing_path.processing}#{@cX.off}
      sisu meta markup:        #{@cX.blue}#{@env.processing_path.dal}#{@cX.off}
      html tuning:             #{@cX.blue}#{@env.processing_path.tune}#{@cX.off}
      latex:                   #{@cX.blue}#{@env.processing_path.tex}#{@cX.off}
      texinfo:                 #{@cX.blue}#{@env.processing_path.texi}#{@cX.off}
  images:
    source:                    #{@cX.blue}#{@env.path.image_source}#{@cX.off}
    latex source:              #{@cX.blue}#{@env.path.image_source_include}#{@cX.off}
    note images are also sourced from within your pwd - #{@cX.blue}#{Dir.pwd}/_sisu/image#{@cX.off} if it exists
  #{@cX.grey}[ texinfo:                     #{@env.processing_path.texinfo} - check duplication ]#{@cX.off}

 #{@cX.green}resource configuraton files#{@cX.off} to change the paths specified above, are searched for in the following order:
   under the current SiSU markup data directory: #{@cX.blue}#{Dir.pwd}/_sisu/sisurc.yml#{@cX.off}
   under the home directory ~/.sisu:             #{@cX.blue}#{@env.path.home}/.sisu/sisurc.yml#{@cX.off}
   in the "/etc" directory:                      #{@cX.blue}#{@env.path.etc}/sisurc.yml#{@cX.off}
   default file paths are set by the program SiSU

 #{@cX.green}skins#{@cX.off} for document appearances on a site, directory or per document basis are located in subdirectories #{@cX.blue}doc/#{@cX.off}  #{@cX.blue}dir/#{@cX.off} and #{@cX.blue}site/#{@cX.off} within:
   #{@cX.blue}#{Dir.pwd}/_sisu/skin#{@cX.off}
   #{@cX.blue}#{@env.path.home}/.sisu/skin#{@cX.off}
   #{@cX.blue}#{@env.path.etc}/skin#{@cX.off}
   default appearances are set by the program SiSU in the absence of skins

   #{@cX.green}Note on subdirectories for output documents#{@cX.off}
   The last part of the name of the directory you choose to work from is used as the major sub-directory in which output files are placed,
   i.e. if you are working in a directory called #{@cX.blue}#{@env.path.home}/ebook#{@cX.off}
        the output files will be placed in a sub-directory named after the processed text within #{@cX.blue}#{@env.path.webserv}/ebook#{@cX.off}
   ( Within this major sub-directory, a sub-directory is made with the name of each document processed, into which output files - html, pdf, xml, plaintext etc. are placed (texinfo being an exception at present) )

    #{@cX.green}sisu -C#{@cX.off} [#{@cX.green}--init=site#{@cX.off}] configure/initialise shared output directory files initialize shared output directory (config files such as css and dtd files are not updated if they already exist unless modifier is used).  -C --init=site configure/initialise site more extensive than -C on its own, shared output directory files/force update, existing shared output config files such as css and dtd files  are updated if this modifier is used.  in a new markup document working directory should initialise the corresponding output directory, though SiSU will automatically do this, the first time it is run (for processing) in a given directory.

   There are additional details, ... this should get you started.

   See also
      sisu --help directory
WOK
      help_env
    end
    def directories
      help_env
      print <<WOK

  the directory structure used by sisu is controlled by the configuration files #{@cX.blue}sisurc.yml#{@cX.off}

   there are separate directories for the following:

    (a) #{@cX.green}data directories#{@cX.off}
      the directories in which you place the SiSU marked-up data files that are to be processed
      there may be as many directories and files as you choose to have,
      you are currently in:                                    #{@cX.blue}#{Dir.pwd}#{@cX.off}

    (b) #{@cX.green}output directory#{@cX.off}
      by default files in the data directory are output to
      a sub-directory within the output directory (usually the web document directory), or to an sql database
      of the same name as the stub or last portion of the data directory name
      by way of example
      you are currently in:                                    #{@cX.blue}#{Dir.pwd}#{@cX.off}
      the document output directory is set to:                 #{@cX.blue}#{@env.path.webserv}#{@cX.off}
      documents from your current directory will be placed in: #{@cX.blue}#{@env.path.output}#{@cX.off}

      the final output is placed in subdirectories either as configured by default in the program or as modified by SiSU configuration files
      subdirectories are created within the main output directory, based on the name of the data directory
      subsubdirectories are created the sub-directory contained in the main output directory based on the name of the file
      (subdirectories are created in this (output) sub-directory named after the data file)
      for this reason it is a convention to give descriptive names to the data file.
      The default output directory is #{@cX.green}~/sisu_www#{@cX.off}
      The output directory is currently set to:
        #{@cX.blue}#{@env.path.webserv}#{@cX.off}
      Output files, are currently set to be produced in:
        processed document output:           #{@cX.blue}#{@env.path.output}#{@cX.off}
        a document in the current directory  #{@cX.blue}#{Dir.pwd}#{@cX.off}
            will have its output placed in:  #{@cX.blue}#{@env.path.output}/#{@output_stub}#{@cX.off}

      NB: the verbose flag v included in the generate command string, should
      result in a list of output filenames together with their paths.
      The flag U on its own (e.g. sisu -U gpl3.fsf.sst) should provide a list
      of output files that could be generated together with their paths.

    (c) #{@cX.green}configuration files#{@cX.off}
       SiSU program defaults are set within the program, and may be adjusted in the yml file #{@cX.blue}sisurc.yml#{@cX.off} which is searched for in the following paths, which are prioritized as listed (the first one found is loaded):
###
       under the current SiSU markup data directory: #{@cX.blue}#{@env.path.pwd}/_sisu/sisurc.yml#{@cX.off}
       under the home directory ~/.sisu:             #{@cX.blue}#{@env.path.home}/.sisu/sisurc.yml#{@cX.off}
       in the "/etc" directory:                      #{@cX.blue}#{@env.path.etc}/sisurc.yml#{@cX.off}

    (d) #{@cX.green}processing directories#{@cX.off}     sisu creates a number of processing directories,
      where these should be located can be modified in #{@cX.green}~/.sisu/sisurc.yml#{@cX.off}
      work directories include the following:
          root working directory                               #{@cX.blue}#{@env.processing_path.processing}#{@cX.off}
          metaverse       intermediate markup                  #{@cX.blue}#{@env.processing_path.dal}#{@cX.off}
          tune html       (for special html/navigation pages)  #{@cX.blue}#{@env.processing_path.tune}#{@cX.off}
          tex             for latex and pdf                    #{@cX.blue}#{@env.processing_path.tex}#{@cX.off}
          texinfo         for texinfo and info files           #{@cX.blue}#{@env.processing_path.texi}#{@cX.off}

      These files are usually used only for processing and removed. There is a maintenance flag to keep them.

    (e) #{@cX.green}images#{@cX.off}
      there are a number of categories of images,
      NB the document markup directory is initialised by issuing the command
        sisu -C --init=site
      this creates the output sub-directory, and makes necessary image links, and
      copies images specific to the markup directory if there are any.

      general images for the sisu program that come with the package,
      that are the defaults used by sisu, these are installed with the program

      images that the author wishes to include within documents,
      these should be placed in a sub-directory
      within the current document markup directory called #{@cX.green}_sisu/image#{@cX.off}

      if an instruction is given to process a remote document which contains
      downloadable images, they are included in a sub-directory of the current
      markup directory #{@cX.green}_sisu/sisu/image_external#{@cX.off} that is created
      if necessary for the purpose.

      finally skins may specify/indicate other image directories. see sisu --help skin
      any site images required by the skin instruction must be copied in to the
      site image directory (it may be necessary to do manual configuration depending
      on what you are trying to achieve).

    (f) #{@cX.green}program directories#{@cX.off}
      sisu --help install
      sisu ~ install

 See also
    sisu --help path
WOK
      help_env
    end
    def program_found?(program)
      if program
        rc=if SiSU_Env::InfoSettings.new.program?(program)
          SiSU_Env::InfoSettings.new.program?(program)
        else ''
        end
        if program =='rmagick' then program='identify' #rmagick is ruby lib uses imagemagick's identify
        end
        bin=if SiSU_Env::SystemCall.new.program_found?(program)
          SiSU_Env::SystemCall.new.program_found?(program)
        else 'false'
        end
      else bin,rc='false','false'
      end
      (program) \
      ? ("#{@cX.blue}#{program}#{@cX.off}  bin: #{@cX.brown}#{bin}#{@cX.off} rc: #{@cX.brown}#{rc}#{@cX.off}")
      : ("bin: #{@cX.brown}#{bin}#{@cX.off} rc: #{@cX.brown}#{rc}#{@cX.off}")
    end
    def sisu_version
      version=SiSU_Env::InfoVersion.instance.get_version
      rb_ver=SiSU_Env::InfoVersion.instance.rbversion
      if version[:version]
        SiSU_Screen::Ansi.new('-v',version[:project],version[:version],version[:date_stamp],version[:date],rb_ver).version
      else puts 'SiSU version information not available'
      end
    end
    def rhost
      @ls=leading_spaces=' '*49
      @rhost=SiSU_Env::InfoRemoteHost.new.rhost
      def r1
        (@rhost.r1) \
        ? @rhost.r1 + "\n"
        : ''
      end
      def r2
        (@rhost.r2) \
        ? @ls + @rhost.r2 + "\n"
        : ''
      end
      def r3
        (@rhost.r3) \
        ? @ls + @rhost.r3 + "\n"
        : ''
      end
      def r4
        (@rhost.r4) \
        ? @ls + @rhost.r4 + "\n"
        : ''
      end
      def r5
        (@rhost.r5) \
        ? @ls + @rhost.r5 + "\n"
        : ''
      end
      def r6
        (@rhost.r6) \
        ? @ls + @rhost.r6 + "\n"
        : ''
      end
      def note
        msg='(remote settings user and host set in sisurc.yml under remote:)'
        (@rhost.r1) \
        ? @ls + msg
        : msg
      end
      self
    end
    def environment
      cf_defaults=SiSU_Env::InfoProcessingFlag.new
      sisu_version
      x =<<WOK
  #{@cX.green}current and output directories#{@cX.off}
  user:                                          #{@cX.blue}#{@env.user}#{@cX.off}
  home:                                          #{@cX.blue}#{@env.path.home}#{@cX.off}
  remote set [remote user]@[remote host]:        #{@cX.blue}#{rhost.r1}#{rhost.r2}#{rhost.r3}#{rhost.r4}#{rhost.r5}#{rhost.r6}#{@cX.off}#{rhost.note}
  locale (encoding, UTF-8 desired):              #{@cX.blue}#{@env.locale}#{@cX.off}
  current directory:                             #{@cX.blue}#{@env.path.pwd}#{@cX.off}
  document output root directory set to:         #{@cX.blue}#{@env.path.webserv}#{@cX.off}
  documents from current directory placed in:    #{@cX.blue}#{@env.path.output}#{@cX.off}
  webrick url:                                   #{@cX.blue}#{@env.url.webserv_base_cgi}#{@cX.off}
                                                 (to start webrick server 'sisu -W')
  sqlite db for present directory:               #{@cX.blue}sqlite #{@env.path.output}/sisu_sqlite.db#{@cX.off}
  postgresql port set to:                        #{@cX.blue}#{@db.psql.port}#{@cX.off}
  postgresql db for present directory:           #{@cX.blue}#{@db.psql.db}#{@cX.off}
                                                 [first create manually if necessary: 'createdb #{@db.psql.db}']

  [generated sqlite cgi search form]:            #{@cX.blue}#{@env.url.webserv_base_cgi}/cgi-bin/sisu_sqlite.cgi#{@cX.off}
  [generated postgresql cgi search form]:        #{@cX.blue}#{@env.url.webserv_base_cgi}/cgi-bin/sisu_pgsql.cgi#{@cX.off}
                                                 (to generate 'sisu -F' or 'sisu -F webrick')
  #{@cX.green}configuration files#{@cX.off}
  sisurc.yml used:                              #{@cX.blue}#{@env.path.yamlrc}#{@cX.off}
  configuration information search path:        #{@cX.blue}#{@env.path.rc.join(', ')}#{@cX.off}
                                                (directory also relevant for skins and images)
  digest (md5 or sha256):                        #{@cX.blue}#{@env.digest.type}#{@cX.off}
  papersize set (LaTeX/pdf):                     #{@cX.blue}#{@env.papersize}#{@cX.off}
                                                 (digest and papersize can be changed in sisurc.yml under default:)
  #{@cX.green}intermediate processing#{@cX.off}
  processing directory:                          #{@cX.blue}#{@env.processing_path.processing}#{@cX.off}
                                                  (to keep processing output, use -M flag)
  #{@cX.green}programs selected for viewing output#{@cX.off}
  text editor:                                   #{@cX.blue}#{@env.program.text_editor}#{@cX.off}
  web browser:                                   #{@cX.blue}#{@env.program.web_browser}#{@cX.off}
  console web browser:                           #{@cX.blue}#{@env.program.console_web_browser}#{@cX.off}
  pdf viewer:                                    #{@cX.blue}#{@env.program.pdf_viewer}#{@cX.off}
  xml viewer:                                    #{@cX.blue}#{@env.program.xml_editor}#{@cX.off}
  odf viewer:                                    #{@cX.blue}#{@env.program.odf_viewer}#{@cX.off}
  epub viewer:                                   #{@cX.blue}#{@env.program.epub_viewer}#{@cX.off}
                                                  (default selections can be changed in sisurc.yml under program_select:)
  #{@cX.green}programs used if available#{@cX.off}
  word count:                                    #{program_found?(@env.program.wc)}
  imagemagick/rmagick:                           #{program_found?(@env.program.rmagick)}
  tidy:                                          #{program_found?(@env.program.tidy)}
  rexml:                                         #{program_found?(@env.program.rexml)}
  latex to pdf:                                  #{program_found?(@env.program.pdflatex)}
  postgresql:                                    #{program_found?(@env.program.postgresql)}
  sqlite:                                        #{program_found?(@env.program.sqlite)}
                                                  (these can be turned off if unavailable in sisurc.yml under program_set:)
  #{@cX.green}processing shortcut defaults set to:#{@cX.off}
  color defaut set (on==true)                    #{@cX.blue}#{cf_defaults.color}#{@cX.off}
  sisu -0                                        #{@cX.blue}#{cf_defaults.cf_0}#{@cX.off} [set as default]
  sisu -1                                        #{@cX.blue}#{cf_defaults.cf_1}#{@cX.off}
  sisu -2                                        #{@cX.blue}#{cf_defaults.cf_2}#{@cX.off}
  sisu -3                                        #{@cX.blue}#{cf_defaults.cf_3}#{@cX.off}
  sisu -4                                        #{@cX.blue}#{cf_defaults.cf_4}#{@cX.off}
  sisu -5                                        #{@cX.blue}#{cf_defaults.cf_5}#{@cX.off}
                                                  (defaults may be changed in active sisurc.yml file under flag:)
  #{@cX.green}special powers, risky operations set:#{@cX.off}
  zap (delete output directories)                #{@cX.blue}#{SiSU_Env::InfoSettings.new.permission?('zap')}#{@cX.off}
  css copy (copy over css files)                 #{@cX.blue}#{SiSU_Env::InfoSettings.new.permission?('css_modify')}#{@cX.off}
                                                  (true/false defaults may be changed in active sisurc.yml file under permissions_set:)

NOTE: for HELP type 'sisu --help', 'sisu --help [help request]', 'man sisu', (or see the system or online documentation)
WOK
print x
    end
    def dublin_core
    print <<WOK
@title:

@subtitle: [is added to title for purposes of Dublin Core description]

@creator:

@type:

@subject:

@date: [ccyy-mm-dd]

@date.created:

@date.issued:

@date.available:

@date.valid:

@date.modified:

@source:

@language: en

@papersize: A4

@relation:

@coverage:

@rights:

WOK
    end
    def headings
      print <<WOK
These are not required, a header is quicker to prepare if a documents structure can be defined by matching words or a regular expression, see headers).

@structure: PART; CHAPTER; SECTION; ARTICLE; none; none;

structure can be defined by a match words or regular expression (the regular expression is assumed to start at the beginning of a line of text i.e. ^)

The following heading or level (structuring) defaults are available (for use instead of or together with @structure: header):

  1~  2~  3~  4~  5~  6~

or, [0.38]

  A~  B~  C~  1~  2~  3~

Heading tags take either of the forms above, ranging from 1-6

They appear at the beginning of the line on which a heading appears,
the number indicates the level of the heading with level 1 being a title,

segments (in html output) are by default created on level 4
(segmented text is split/segmented on level 4, and
assigned a file name automatically according to the title number,
unless you explicitly specify otherwise)

eg.

% SiSU 0.16 - 0.37

1~ Document Title

2~ Document Subtitle whatever it is

3~ Part

4~ Chapter

5~ Heading

6~ sub-heading

in the 0.38 notation this maps to:

% SiSU 0.38

A~ Document Title

B~ Document Subtitle whatever it is

C~ Part

1~ Chapter

2~ Heading

3~ sub-heading

(a conversion script provided in sisu-examples, modify.rb makes conversion between 0.37 and 0.38 markup simple)

Normal text would follow each heading level as appropriate, though it is most usual to start with ordinary writing beneath level 4 as it is at this level that segments are created.

Automatic numbering of paragraphs is usually set to start at level 4 trough level 6 and takes the form 1. then 1.1 then 1.1.1 this being given as a Header tag 0~ There may be up to 6 levels in a document,

If auto-numbering is on, then for html output the segments created  (on level 4 headings) are automatically assigned the name of the title number.
However, you may indicate an alternative set of key/title words, with one of the following instructions:
4~filename This is a Section or Subject Heading

If there is a strictly discernable word appearing at the beginning of the line in a document that identifies the level,
the words can be used to identify the levels in a header tag:
0~toc Part; Chapter; Section; Article; none; none
instead of providing individual heading tags

sisu structure, (0.38) alternative notation, A,B,C,1,2,3 mapping to 1,2,3,4,5,6

 SiSU has in effect two sets of levels to be considered

 1-3 headings/levels, (A-C [0.38]) pre-ordinary paragraphs /pre-substantive text, and

 4-6 headings/levels, (1-3 [0.38]) levels which are followed by ordinary text.

 This may be conceptualised as levels A,B,C, 1,2,3, and using such letter number notation, in effect:

 A must exist, optional B and C follow in the sequence

 1 must exist, optional 2 and 3 follow in the sequence

 i.e. there are two independent heading level sequences A,B,C and 1,2,3 or using the standard notation 1,2,3 and 4,5,6

on the positive side: (a) the A,B,C,1,2,3 alternative makes explicit an aspect of structuring documents in SiSU that is not otherwise obvious to the newcomer (though it appears more complicated, is more in your face and likely to be understood fairly quickly); (b) the substantive text follows levels 1,2,3 and it is 'nice' to do most work in those levels

WOK
    end
    def languages
      lang=SiSU_i18n::Languages.new.language.table
      lang.each_value do |lng|
        if lng[:t] == lng[:n]
          puts "#{lng[:c]}:  #{lng[:t]}"
        else
          puts "#{lng[:c]}:  #{lng[:t]} (#{lng[:n]})"
        end
      end
      puts <<WOK

 Multi-language Document File Naming and Directory Mapping

 A list of language codes and languages that may be available for most output formats. These are for the most part ISO 639/1 and where there is a departure it follows those made by po4a, and the languages supported will be limited (at this time) to those supported by polyglossia. (SiSU markup text is stored in Unicode so some output formats are served by this, for example, html and sql had no problem with Chinese, pdfs would be a problem as this is not (yet?) suported by xetex and polyglossia. SiSU parses left to right and would have problems with right to left languages.)

 If the same document exists in different language versions, a directory structure, or a filenaming convention may be followed. Using Spannish as the sample language code (es) [filename]~[language code].sst

 The simplest now is to place each document in a sub-directory which has the language code as a name, if this convention is used it is preferable that all files are placed by language in the appropriate language sub-directory ... e.g.
   ./en/filename.sst
   ./es/filename.sst

 Alternatively files may all be placed in the same directory with the language and named using a tilde and the language code as shown:
  filename~es.sst

  within sisurc.yml under the heading
    default:
      language file: [at 1, 2 or 3]

  determines the output filenaming convention used, as follows:

    (1) [output directory path]/filename/es.index.html

    (2) [output directory path]/filename/index.es.html

    (3) [output directory path]/filename/index.html.es (which Apache for example can be configured to use to automatically serve each users preference)

    filename~fr.sst
    filename~de.sst

  etc. would be placed in the same directory using the same convention as indeed would:
    filename.sst
  using the default convention mapping convention.

  Selecting this form of filename will overide other language settings including the language header within a document.

WOK
    end
    def endnotes
      print <<WOK

(1) Footnote/endnotes tags take a number of possible forms, the simplest being to embed an endnote within your text~{ this would appear as an endnote, and would have an automatically assigned number }~ Embedded endnotes~{this is an endnote}~ and at the end of the paragraph~{* an asterisk marked note }~ writing the endnote:~{another endnote}~

  ------------------------------------------
#{@cX.ruby}All you need to know about endnotes appears above this line...#{@cX.off} apart from the fact that you cannot mix endnote markup styles

(2) The other ways of inserting an endnote involve placing a tag within the text as to where the endnote reference number should appear like so~^ and at the end of the paragraph writing the endnote:~^

^~ like so, this is an endnote

^~ another endnote

WOK
    end
    def tables
      print <<WOK

#{@cX.green}table{ [number of columns] [column width %];[column width %]#{@cX.off}

[table content, line breaks are important see example below]

#{@cX.green}}table#{@cX.off}
#{@cX.grey}----#{@cX.off}
This is a sample table:
-----------------------

#{@cX.green}table{ c3; 40; 30; 30;#{@cX.off}

This is a table
this would become column two of row one
column three of row one is here

And here begins another row
column two of row two
column three of row two, and so on

#{@cX.green}}table#{@cX.off}

there is an alternative way to markup tables, a sample document is provided in the file
#{@cX.green}sisu_output_overview.sst#{@cX.off} located in
#{@cX.green}/usr/share/doc/sisu#{@cX.off} or equivalent directory

preformatted text
-----------------

#{@cX.green}poem{#{@cX.off}

  [Text here]

#{@cX.green}}poem#{@cX.off}
#{@cX.grey}----#{@cX.off}

#{@cX.green}block{#{@cX.off}

  [Text here]

#{@cX.green}}block#{@cX.off}
#{@cX.grey}----#{@cX.off}

#{@cX.green}group{#{@cX.off}

  [Text here]

#{@cX.green}}group#{@cX.off}
#{@cX.grey}----#{@cX.off}

#{@cX.green}code{#{@cX.off}

  [Text here]

#{@cX.green}}code#{@cX.off}

WOK
    end
    def modules
      print <<WOK

      #{@cX.ruby}IGNORE#{@cX.off}

WOK
    end
    def install                                                        #% system configuration
      print <<WOK
  #{@cX.green}Install SiSU#{@cX.off}

  Presumably if you are reading this interactively you have a copy of SiSU already installed, nevertheless here are a few notes.

  SiSU does require setup, the executable file #{@cX.blue}sisu#{@cX.off} is placed in #{@cX.blue}#{Config::CONFIG['bindir']}#{@cX.off} or #{@cX.blue}#{Config::CONFIG['sitelibdir']}#{@cX.off} and the library files, in #{@cX.blue}#{Config::CONFIG['rubylibdir']}/#{SiSU_lib}#{@cX.off}
 or in #{@cX.blue}#{Config::CONFIG['sitelibdir']}/#{SiSU_lib}#{@cX.off}

  SiSU comes with a number of installers, including #{@cX.blue}setup.rb#{@cX.off}, #{@cX.blue}install#{@cX.off} and a #{@cX.blue}Rantfile#{@cX.off} if rant is installed on your system, you may need to be root to install sisu on your system. After unpacking the tarball, in the top directory of the tarball which contains the named files type, one of:
      sudo ./sisu-install base
      sudo ./sisu-install setup
    if that does not work try
      sudo ruby ./sisu-install setup
    if rant is installed on your system you may instead run:
      sudo rant base

    for further options:
      ./sisu-install -T

  SiSU is pre-packaged for some GNU/Linux distributions such as Debian.

  For information on download and installation, see #{@cX.blue}http://www.jus.uio.no/sisu/SiSU/download#{@cX.off}

  For post installation help it is best you refer to '#{@cX.blue}man 8 sisu#{@cX.off}'

  Host
    host:             #{@cX.blue}#{@env.hostname}#{@cX.off}
    arch:             #{@cX.blue}#{@env.arch}#{@cX.off}

  Directories for installation
    bin:                                     #{@cX.blue}#{Config::CONFIG['bindir']}#{@cX.off} or #{@cX.blue}#{Config::CONFIG['sitelibdir']}#{@cX.off}
    lib (site-ruby):                         #{@cX.blue}#{Config::CONFIG['rubylibdir']}/#{SiSU_lib}#{@cX.off} or #{@cX.blue}#{Config::CONFIG['sitelibdir']}/#{SiSU_lib}#{@cX.off}
    conf [etc]:                              #{@cX.blue}#{@env.path.etc}/sisu#{@cX.off}
    data (document samples, images, README): #{@cX.blue}#{@env.path.sample_data}#{@cX.off}
    processing:                              #{@cX.blue}#{@env.processing_path.processing}#{@cX.off}
    output www:                              #{@cX.blue}#{@env.path.output}#{@cX.off}

    Output files, are currently set to be produced in:
      processed document output:             #{@cX.blue}#{@env.path.output}#{@cX.off}
      a document in the current directory    #{@cX.blue}#{Dir.pwd}#{@cX.off}
          will have its output placed in:    #{@cX.blue}#{@env.path.output}/#{@output_stub}#{@cX.off}

  Install any additional programs of interest (that SiSU makes use of, that are not already on your system)

    Programs SiSU makes use of include:
      LaTeX
      texinfo
      pdfetex aka. pdflatex
      sqlite
      postgresql

  Again, refer to '#{@cX.blue}man 8 sisu#{@cX.off}'

  For additional help on using SiSU once installed type:

    sisu --help

WOK
    end
    def setup
      print <<WOK

     #{@cX.green}configuration files#{@cX.off}
     sisurc.yml used:
       #{@cX.blue}#{@env.path.yamlrc}#{@cX.off}
     configuration information search path:
       #{@cX.blue}#{@env.path.rc.join(', ')}#{@cX.off}
                                                (directory also relevant for skins and images)

      to initialise the mapped output directory, from within the markup document directory type:
        #{@cX.blue}sisu -CC#{@cX.off}

      for information on your current sisu configuration settings, type:
        #{@cX.blue}sisu --help env#{@cX.off}
      or
        #{@cX.blue}sisu -V#{@cX.off}

      see also
        #{@cX.blue}man 8 sisu#{@cX.off}
      and
        #{@cX.blue}http://www.jus.uio.no/sisu/SiSU#{@cX.off}
WOK
    end
    def termsheet
      print <<WOK

  #{@cX.green}sisu --termsheet [termsheetname].termsheet.rb#{@cX.off}
    will produce the collection of documents associated with [termsheetname.termsheet.rb]

  #{@cX.green}sisu -t [termsheetname].termsheet.rb#{@cX.off}
    will produce the collection of documents associated with [termsheetname.termsheet.rb]

  #{@cX.green}termsheet.rb#{@cX.off} files:
  (i) are named after the facility
  (ii) contain instructions as to which standard forms to use for the agreement (standard_form.rb)
     there may be several, eg. the termsheet, and the resulting:
     main agreement; collection account charge; and deed of assignment
  (iii) contain the variable terms of the agreement, borrower, interest etc.

  for a new loan agreement fill out a new termsheet specifying
  what standard forms are to be used,
  and the terms of the agreement.

  #{@cX.green}standard_form.rb#{@cX.off} files:
  contain the standard terms of the agreement
  there is a standard form for each variation of agreement
    (so eg. there are as many facility agreements as there are variations in standard facility)
  these may be prepared for any agreement that is to be reused.
  (preparation takes the form of formating and
  placing variable holders for the variables that are to be provided by the termsheet.rb file)

  it is necessary to purge the directory ~facilityData when old files are removed

WOK
    end
    def help_commands
      print <<WOK

    also see:
      sisu --help commands
      man sisu
WOK
    end
    def help_env
      print <<WOK

    for sisu environment information see:
      sisu --help env
WOK
    end
    def help_general
      help_env
      help_commands
    end
    def help_markup
      print <<WOK

    for help with sisu markup see:
      sisu --help markup
      sisu --help header
      sisu --help structure [sisu --help heading]

      to check markup version in file:
        sisu --identify [filename].sst

      for brief descriptive summary of markup history
        sisu --query-history
      or if for a particular version
        sisu --query-0.38

      for markup:
        sisu --help example

      sample marked up documents are provided in directory:
        #{@cX.green}/usr/share/doc/sisu/markup-samples#{@cX.off}
      and online
        #{@cX.green}www.jus.uio.no/sisu#{@cX.off}
WOK
      end
    def convert
      print <<WOK

      for information on the markup version used within a sisu markup file:
        sisu --inspect [filename]

      to convert between sst markup versions 0.37 and 0.38:
        sisu --to-current
        sisu --to-38  [filename/wildcard]
        sisu --to-37  [filename/wildcard]

      convert an sst file with footnotes following text to (preferred) inline footnotes
        sisu --convert-footnotes  [filename/wildcard]

      to convert from sst to simple xml representations (sax, dom and node):
        sisu --to-sax [filename/wildcard]
        sisu --to-sxs [filename/wildcard]

        sisu --to-dom [filename/wildcard]
        sisu --to-sxd [filename/wildcard]

        sisu --to-node [filename/wildcard]
        sisu --to-sxn [filename/wildcard]

      to convert to sst from simple xml representations (sax, dom and node):
        sisu --from-xml2sst [filename/wildcard [.sxs.xml,.sxd.xml,sxn.xml]]
        sisu --from-sxml [filename/wildcard [.sxs.xml,.sxd.xml,sxn.xml]]

      to attempt to convert a kdissert (.kdi) file to sisu markup:
        sisu --from-kdi  [kdissert filename]
        (very basic and experimental)
WOK
    end
    def dal
      print <<WOK

    sisu --dal [filename/wildcard]    creates the metaverse, used by all other modules for downstream processing
    sisu -m [filename/wildcard]    creates the metaverse, used by all other modules for downstream processing
WOK
      help_commands
    end
    def utf8
      print <<WOK

      documents prepared for sisu processing should be stored in utf8
WOK
    end
    def plaintext
      print <<WOK

    sisu --txt [filename/wildcard]    plaintext with Unix linefeeds (footnotes follow paragraphs)
    sisu -t [filename/wildcard]    plaintext with Unix linefeeds (footnotes follow paragraphs)

WOK
      help_commands
    end
    def html
      print <<WOK

    sisu --html [filename/wildcard]    html document type suffixes included
    sisu -h [filename/wildcard]    html document type suffixes included

WOK
      help_commands
    end
    def xhtml
      print <<WOK

    sisu --xhtml [filename/wildcard]    xhtml document
    sisu -b [filename/wildcard]    xhtml document
WOK
      help_commands
    end
    def xml
      print <<WOK

    sisu --xml-sax [filename/wildcard]    xml document (sax type parsing)
    sisu -x [filename/wildcard]    xml document (sax type parsing)

    sisu --xml-dom [filename/wildcard]    xml document (dom type parsing)
    sisu -X [filename/wildcard]    xml document (dom type parsing)

    sisu --odt [filename/wildcard]    odt document, (odf open document format)
    sisu -o [filename/wildcard]    odt document, (odf open document format)

    sisu --epub [filename/wildcard]    odt document, (epub document)
    sisu -e [filename/wildcard]    odt document, (epub document)
WOK
      help_commands
    end
    def odf
      print <<WOK

    sisu --odt [filename/wildcard]    odt document, (odf open document format)

    sisu -o [filename/wildcard]    odt document, (odf open document format)
WOK
      help_commands
    end
    def epub
      print <<WOK

    sisu --epub [filename/wildcard]    epub document, (open format for e-books)
    sisu -e [filename/wildcard]    epub document, (open format for e-books)
WOK
      help_commands
    end
    def php
      print <<WOK

    not supported
    [php output has been removed]
WOK
      help_commands
    end
    def pdf
      print <<WOK

    sisu --pdf [filename/wildcard]     produces pdf files from LaTeX output
    sisu -p [filename/wildcard]     produces pdf files from LaTeX output
WOK
      help_commands
    end
    def latex
      print <<WOK

    sisu --pdf [filename/wildcard]     produces pdf files from LaTeX output
    sisu -p [filename/wildcard]     produces pdf files from LaTeX output
WOK
      help_commands
    end
    def texinfo
      print <<WOK

    sisu --texinfo [filename]     produces texinfo and info files
    sisu -I [filename]     produces texinfo and info files

    info and texinfo files are currently left in a separate work/output directory... have not decided what to do with them

    on my system info works fine point at file with info command

    pinfo, requires you to be within the work/output directory
      cd [work/output directory]

    and then to point at the file using
      pinfo ./[filename]
WOK
      help_commands
    end
    def lout
      print <<WOK

    sisu -l [filename/wildcard]

    not currently supported, revisit someday?
WOK
      help_commands
    end
    def concordance
      print <<WOK

    sisu --concordance        starts the sisu webrick server, default port 8081
    sisu --wordmap        starts the sisu webrick server, default port 8081
    sisu -W        starts the sisu webrick server, default port 8081
WOK
      help_commands
    end
    def help_search
      print <<WOK

      SiSU searches,
      depending on how you wish to implement search,
      the following may bre of interest:
        sisu --help sql
        sisu --help searchform    (or 'sisu --help cgi')
        sisu --help hyperestraier (or 'sisu --help est')
        sisu --help webrick
WOK
    end
    def cgi
      print <<WOK

      sisu --sample-search-form                 generates a sample search form
      sisu -F                generates a sample search form

      sisu -F --webserv=webrick  generates a sample search form for use with the webrick server
      sisu -Fv               as above, and provides some information on setting up hyperestraier
      sisu -W                starts the webrick server

      the generated search form must be copied to the webserver directory as instructed
WOK
      help_search
      help_general
    end
    def sql
      print <<WOK

    Mappings to two databases are provided by default,
    postgresql (--pg or -D) and sqlite (--sqlite or -d),
    the same modifier commands are used within sisu to construct and populate
    databases the examples here will use --sqlite

    sisu --sqlite --createdb         creates database where no database existed before
    sisu --sqlite --create           creates database tables where no database tables existed before
    sisu --sqlite --dropall          destroys database (including all its content)!!
    sisu --sqlite --recreate         destroys existing database and builds a new empty database structure

    sisu --sqlite --import [filename/wildcard]   populates database with the contents of the file
    sisu --sqlite --update [filename/wildcard]   updates file contents in database

    sisu --sample-search-form --webserv=webrick    builds a cgi web search frontend for the database created

  Postgresql
    user:             #{@cX.blue}#{@db.psql.user}#{@cX.off}
    current db set:   #{@cX.blue}#{@db.psql.db}#{@cX.off}
    port:             #{@cX.blue}#{@db.psql.port}#{@cX.off}
    dbi connect:      #{@cX.blue}#{@db.psql.dbi}#{@cX.off}

  sqlite
    current db set:   #{@cX.blue}#{@db.sqlite.db}#{@cX.off}
    dbi connect       #{@cX.blue}#{@db.sqlite.dbi} #{@cX.off}

  Note on databases built
   By default, [unless otherwise specified] databases are built on a directory basis, from collections of documents within that directory.
   The name of the directory you choose to work from is used as the database name,
   i.e. if you are working in a directory called #{@cX.blue}#{@env.path.home}/ebook#{@cX.off} the database #{@cX.blue}#{Db[:name_prefix]}ebook#{@cX.off} is used. [otherwise a manual mapping for the collection is necessary]
WOK
      help_search
      help_general
    end
    def webrick
      print <<WOK

    sisu --webrick  starts the sisu webrick server, default port 8081
    sisu -W         starts the sisu webrick server, default port 8081
WOK
      help_commands
    end
    def hyperestraier
      out_dir='(' + `ls #{@env.path.webserv}`.split("\n").join('|') + ')'
      print <<WOK
  Not tested recently, not up-to-date

  NOTE: The examples that follow assume that sisu output is placed in the directory
  /home/ralph/sisu_www

 (A)  to generate the index
   within the webserver directory to be indexed:
      #{@cX.orange}estcmd gather -sd [index name] [directory path to index]#{@cX.off}
   the following are examples that will need to be tailored according to your needs:
     #{@cX.green}
     cd #{@env.path.webserv}
     estcmd gather -sd casket #{@env.path.webserv}
     #{@cX.off}
     you may use the 'find' command together with 'egrep' to limit
     indexing to particular document collection directories within
     the web server directory:#{@cX.green}

     find /home/ralph/sisu_www -type f | egrep '#{@env.path.output}/.+?\.html$' |estcmd gather -sd casket - #{@cX.off}

     check which directories in the webserver/output directory #{@cX.green}#{@env.path.webserv}#{@cX.off}
     you wish to include in the search index, these appear to be:

     #{@env.path.webserv}/#{@cX.green}#{out_dir}#{@cX.off}

     as sisu duplicates output in multiple file formats,
     it it is probably preferable to limit the estraier index
     to html output, and as it may also be desirable to
     exclude files 'doc.html' and 'concordance.html', as these
     duplicate information held in other html output e.g. #{@cX.green}

     find /home/ralph/sisu_www -type f | egrep '/sisu_www/(sisu|bookmarks)/.+?\.html$' | egrep -v '(doc|concordance)\.html$' |estcmd gather -sd casket - #{@cX.off}

     from your current document preparation/markup directory, you would construct a rune along the following lines: #{@cX.green}

     find /home/ralph/sisu_www -type f | egrep '#{@env.path.webserv}/([specify first directory for inclusion]|[specify second directory for inclusion]|[another directory for inclusion? ...])/.+?\.html$' | egrep -v '(doc|concordance)\.html$' |estcmd gather -sd #{@env.path.webserv}/casket - #{@cX.off}

 (B) to set up the search form
   (i) copy #{@cX.green}estseek.cgi#{@cX.off} to your cgi directory and set file permissions to 755: #{@cX.green}

     sudo cp -vi /usr/lib/estraier/estseek.cgi /usr/lib/cgi-bin
     sudo chmod -v 755 /usr/lib/cgi-bin/estseek.cgi
     sudo cp -v /usr/share/hyperestraier/estseek.* /usr/lib/cgi-bin #{@cX.off}
     [see estraier documentation for paths]

   (ii) edit #{@cX.green}estseek.conf#{@cX.off}, with attention to the lines starting 'indexname:' and 'replace:': #{@cX.green}

     indexname: #{@env.path.webserv}/casket
     replace: ^file://#{@env.path.webserv}{{!}}#{@env.url.webserv_host_base}
     replace: /index\.html?${{!}}/ #{@cX.off}

 (C) to test using webrick, start webrick: #{@cX.green}
     sisu -W #{@cX.off}

   and try open the url: #{@cX.blue}
     #{@env.url.webserv_host_base}/cgi-bin/estseek.cgi #{@cX.off}

WOK
    end
    def yaml
      print <<WOK
   Yaml sisurc files may be used to configure sisu, these are searched for in the following locations:

   under the current SiSU markup data directory: #{@cX.blue}#{Dir.pwd}/_sisu/sisurc.yml#{@cX.off}
   under the home directory ~/.sisu:             #{@cX.blue}#{@env.path.home}/.sisu/sisurc.yml#{@cX.off}
   in the "/etc" directory:                      #{@cX.blue}#{@env.path.etc}/sisurc.yml#{@cX.off}

   The Yaml files #{@cX.blue}promo.yml#{@cX.off} and #{@cX.blue}list.yml#{@cX.off} may be used to build a minor right pane in html, they may be placed in the following locations:

   under the current SiSU markup data directory: #{@cX.blue}#{Dir.pwd}/_sisu/skin/yml/#{@cX.off}
   under the home directory ~/.sisu:             #{@cX.blue}#{@env.path.home}/.sisu/skin/yml/#{@cX.off}
   in the "/etc" directory:                      #{@cX.blue}#{@env.path.etc}/skin/yml/#{@cX.off}

   these may be called by the sisurc.yml, skins for document, directory or site, or from individual document headers in the header @@promo: [a commented out example header may be found in  document  sample: free_as_in_freedom.richard_stallman_cru‐ sade_for_free_software.sam_williams.sst, it calls for the specified lists in list.yml, which in turn calls the widgets named in promo.yml which are used to build content in the right pane of html output]

WOK
    end
    def sitemap
      print <<WOK

      SiSU sitemaps,
      an experimental feature (following g,y,m announcement to use them this week)
        sisu -Y [filename/wildcard]
      it may be necessary run -m first (generate the the metaverse)
        sisu -mY [filename/wildcard]

      to generate/update the index of sitemaps
        sisu --sitemaps
WOK
    end
    def license

      print <<WOK

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997 - 2013 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <#{@cX.blue}http://www.gnu.org/licenses/#{@cX.off}>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
     <#{@cX.blue}http://www.fsf.org/licenses/gpl.html#{@cX.off}>
     <#{@cX.blue}http://www.gnu.org/licenses/gpl.html#{@cX.off}>
     <#{@cX.blue}http://www.jus.uio.no/sisu/gpl.fsf#{@cX.off}>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <#{@cX.blue}http://www.jus.uio.no/sisu#{@cX.off}>
   <#{@cX.blue}http://www.sisudoc.org#{@cX.off}>

 * Download:
   <#{@cX.blue}http://www.jus.uio.no/sisu/SiSU/download.html#{@cX.off}>

   Ralph Amissah
   <#{@cX.blue}ralph@amissah.com#{@cX.off}>
   <#{@cX.blue}ralph.amissah@gmail.com#{@cX.off}>

WOK
    end
    def standards
      print <<WOK

 * SiSU uses:
   *  Standard SiSU markup syntax,
   *  Standard SiSU meta-markup syntax, and the
   *  Standard SiSU object citation numbering and system

Copyright (C) Ralph Amissah 1997, current 2013.
All Rights Reserved.

Information on these may be obtained from:
  http://www.jus.uio.no/sisu

More information to be provided later.

* however note also the License section

* Ralph Amissah ralph@amissah.com
  Ralph Amissah ralph.amissah@gmail.com

WOK
    end
    def conversion
      print <<WOK
sisu_convert does the initial conversion from a couple of file formats to SiSU file format, currently only html and word97
  #{@cX.cyan}sisu_convert#{@cX.off} [keyword]
  sisu [keyword]
    #{@cX.green}--html#{@cX.off}       convert from html
  ------------------------------------------
  Preparing Documents for SiSU
    #{@cX.green}--word97#{@cX.off}       sisu --help markup     (an incomplete overview)
WOK
    end
    def external_programs
      puts <<WOK

    external ruby programs

    external programs
      #{@cX.cyan}pdf output - tex/latex#{@cX.off}
        #{@cX.orange}required#{@cX.off}
          tex-base/latex
          pdfetex aka. pdflatex
        #{@cX.brown}suggested/recommended#{@cX.off}
      #{@cX.cyan}db/sql output#{@cX.off}
        #{@cX.orange}required#{@cX.off}
          postgresql
        #{@cX.brown}suggested/recommended#{@cX.off}
          sqlite
      #{@cX.cyan}xml/xhtml/html output#{@cX.off}
        #{@cX.orange}required#{@cX.off}
        #{@cX.brown}suggested/recommended#{@cX.off}
          tidy  (xml, xhtml well formed check)
          trang (relaxng, rnc to dtd conversion)
WOK
    end
    def scratch
      print <<WOK
Types of tag,

then there are various tags which occur within the document.
Structural tags, which consist of:
  heading tags that identify headings within text, and;
  footnote/endnote tags ...

Markup instructions: giving information as to what is to be done to the presentation of the text

Markup tags

These have been kept to a minimum. A number of text html markup tags can be used <b>to bold</b> <i>to indent</i> <sup>for superscript</sup> <sub>for subscript text</sub>

_1 at the beginning of a line indents the paragraph

_2 at the beginning of a line double indents the paragraph

Others include

Other things to note:

By default paragraphs are automatically numbered... and is the same across all output formats
This makes citation a lot easier... regardless of the form of output that is being looked at
It also permits the building of various addons, like the concordance feature which identifies each word and the paragraphs in which the word appears with links to the paragraph...

Urls are automatically turned to live links in the html and pdf files created...
WOK
    end
  end
end
__END__

