# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   harvest metadata from document corpus (suitable for medium sized sites)
   (concept example, [to remove size constraint: implement SQL equivalent])

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/harvest.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Harvest
  @@the_idx_topics,@@the_idx_authors={},{}
  class Source
    require_relative 'options'                              # options.rb
    require_relative 'harvest_topics'                       # harvest_topics.rb
    require_relative 'harvest_authors'                      # harvest_authors.rb
    require_relative 'sysenv'                               # sysenv.rb
      include SiSU_Env
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::InfoEnv.new
    end
    def read
      begin
        harvest_pth="#{@env.path.webserv}/#{@opt.base_stub}"
        FileUtils::mkdir_p(harvest_pth) unless FileTest.directory?(harvest_pth)
        cases(@opt,@env)
      rescue
      ensure
        SiSU_Env::CreateSite.new(@opt.cmd).cp_css
      end
    end
    def help
      puts <<WOK
      harvest --harvest   extracts document index metadata

WOK
    end
    def css(opt)
      require_relative 'css'                                # css.rb
      css=SiSU_Style::CSS.new
      fn_css=SiSU_Env::CSS_Default.new
      style=File.new("#{@env.path.pwd}/#{fn_css.harvest}",'w')
      style << css.harvest
      style.close
    end
    def cases(opt,env)
      case opt.mod.inspect
      when/--harvest/i
        css(opt) if opt.cmd.inspect =~/M/
        SiSU_HarvestAuthors::Songsheet.new(opt,env).songsheet
        SiSU_HarvestTopics::Songsheet.new(opt,env).songsheet
        if opt.cmd.inspect =~/R/
          require_relative 'remote'                         # remote.rb
          SiSU_Remote::Put.new(opt).rsync_harvest
        end
      else
        help
      end
    end
  end
end
__END__
