# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/git.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Git
  require_relative 'param'                              # param.rb
  require_relative 'sysenv'                             # sysenv.rb
  require_relative 'dal'                                # dal.rb
  class Source
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::InfoEnv.new
      @md=SiSU_Param::Parameters.new(@opt).get
      @file=SiSU_Env::FileOp.new(@md)
      l=SiSU_Env::StandardiseLanguage.new(@md.opt.lng).language
      unless @opt.lng==l[:c] # @md.i18n[0]==l[:c]
        p "using: #{@opt.lng} (@make: :language:); filename #{@md.fns} filename language: #{l[:c]}, mismatch"
      end
      if @env.output_dir_structure.multilingual?
        m=/((.+?)(?:\~\w{2,3})?)\.((?:-|ssm\.)?sst|ssm)$/ #watch added match for sss
        fnn,fnb,fnt=@opt.fns[m,1],@opt.fns[m,2],@opt.fns[m,3]
      else m=/(.+?)\.((?:-|ssm\.)?sst|ssm)$/
        fnb=@fnn=@opt.fns[m,1]
        fnt=@opt.fns[m,2]
      end
      git_path_fnb=@env.processing_path.git + '/' + fnb
      #unless @opt.cmd =~/q/
      #  @opt.cmd=~/[MVvz]/ \
      #  ? SiSU_Screen::Ansi.new(@opt.cmd,'Git path',@git_path[:fnb]).green_hi_blue \
      #  : SiSU_Screen::Ansi.new(@opt.cmd,'Git path',@git_path[:fnb]).green_title_hi
      #  SiSU_Screen::Ansi.new(@opt.cmd,"Git path","#{@opt.fns} -> #{@git_path[:fnb]}").warn if @opt.cmd =~/[MVv]/
      #end
      lng=(@md.opt.lng) ? (@md.opt.lng) : (@md.i18n[0])
      @git_path={
        fnb:       git_path_fnb,
        doc:       git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:doc] + '/' + lng,
        po:        git_path_fnb + '/' + Gt[:po] + '/' + lng,
        pot:       git_path_fnb + '/' + Gt[:pot],
        conf:      git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:conf],
        skin:      git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:skin],
        image:     git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:image],
        audio:     git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:audio],
        video:     git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:video],
        conf:      git_path_fnb + '/' + Gt[:sisupod] + '/' + Gt[:conf]
      }
      SiSU_DAL::Source.new(@opt).read                                         # -m
    end
    def create_file_structure_git
      make_dir_fnb
      if program_found?
        git_init
      end
    end
    def read
      create_file_structure_git
      populate.sisusrc_files
      #if program_found?
      #  git_commit
      #end
      unless @opt.cmd =~/q/
        @opt.cmd=~/[MVvz]/ \
        ? SiSU_Screen::Ansi.new(@opt.cmd,'Git path',@git_path[:fnb]).green_hi_blue
        : SiSU_Screen::Ansi.new(@opt.cmd,'Git path',@git_path[:fnb]).green_title_hi
        SiSU_Screen::Ansi.new(@opt.cmd,"Git path","#{@opt.fns} -> #{@git_path[:fnb]}").warn if @opt.cmd =~/[MVv]/
      end
    end
    def program_found?
      found=`whereis git`
      (found =~/bin\/git\b/) ? true : false
    end
    def make_dir_fnb
      FileUtils::mkdir_p(@git_path[:fnb]) unless FileTest.directory?(@git_path[:fnb])
      FileUtils::mkdir_p(@git_path[:doc]) unless FileTest.directory?(@git_path[:doc])
      FileUtils::mkdir_p(@git_path[:po]) unless FileTest.directory?(@git_path[:po])
      FileUtils::mkdir_p(@git_path[:pot]) unless FileTest.directory?(@git_path[:pot])
      FileUtils::mkdir_p(@git_path[:conf]) unless FileTest.directory?(@git_path[:conf])
      FileUtils::mkdir_p(@git_path[:skin]) unless FileTest.directory?(@git_path[:skin])
      FileUtils::mkdir_p(@git_path[:image]) unless FileTest.directory?(@git_path[:image])
      #FileUtils::mkdir_p(@git_path[:audio]) unless FileTest.directory?(@git_path[:audio])
      #FileUtils::mkdir_p(@git_path[:video]) unless FileTest.directory?(@git_path[:video])
    end
    def git_init
      unless FileTest.directory?("#{@git_path[:fnb]}/.git")
        pwd=Dir.pwd
        Dir.chdir(@git_path[:fnb])
        system("git init ")
        Dir.chdir(pwd)
      end
    end
    def git_commit
      if program_found?
        if FileTest.directory?("#{@git_path[:fnb]}")
          pwd=Dir.pwd
          Dir.chdir(@git_path[:fnb])
          system("
            git add . \
            && git commit -a
          ")
          Dir.chdir(pwd)
        end
      end
    end
    def populate
      def identify_language_versions
        print __FILE__ + ':'
        p __LINE__
      end
      def copy_src_head
        if @opt.f_pth[:lng]
          FileUtils::cp_r("#{@env.path.pwd}/#{@opt.f_pth[:lng]}/#{@opt.fns}",@git_path[:doc])
        elsif @opt.fns =~/\.ssm\.sst/
          ssm=@opt.fns.gsub(/\.ssm\.sst/,'.ssm')
          FileUtils::cp_r("#{@env.path.pwd}/#{ssm}",@git_path[:doc])
        else
          FileUtils::cp_r("#{@env.path.pwd}/#{@opt.fns}",@git_path[:doc])
        end
      end
      def copy_related_sst_ssi
        doc_import=[]
        @rgx_doc_import=/^<<\s(\S+?\.ss[ti])/
        file_array=IO.readlines(@opt.fns,'')
        file_array.each do |f|
          if f =~@rgx_doc_import
            doc_import = doc_import + f.scan(@rgx_doc_import).uniq.flatten
          end
        end
        doc_import.each do |f|
          if @opt.f_pth[:lng]
            FileUtils::cp_r("#{@env.path.pwd}/#{@opt.f_pth[:lng]}/#{f}",@git_path[:doc])
          else
            FileUtils::cp_r("#{@env.path.pwd}/#{f}",@git_path[:doc])
          end
        end
      end
      def locate_parse_file
        composite_src=@opt.fns=~/\.ssm$/ ? true : false
        parse_file=if composite_src \
        and @opt.cmd.inspect !~/m/
          ##SiSU_Assemble::Composite.new(@opt).read
          #SiSU_DAL::Source.new(@opt).read                                         # -m
          "#{@env.processing_path.composite_file}/#{@opt.fnb}.ssm.sst"
        elsif composite_src
          "#{@env.processing_path.composite_file}/#{@opt.fnb}.ssm.sst"
        else "#{@env.path.pwd}/#{@opt.fns}"
        end
      end
      def locate_skin
        SiSU_Env::InfoSkin.new(@md).select
      end
      def read_composite
        #print __FILE__ + ':'
        #p __LINE__
      end
      def extract_skin
        #print __FILE__ + ':'
        #p __LINE__
      end
      def extract_skin_and_images #(parse_file)
        parse_file_name=locate_parse_file
        parse_file=IO.readlines(parse_file_name,'')
        rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
        #rgx_rb_image=/["'](\S+?\.(?:png|jpg|gif))["']/
        #rgx_rb_image=/[^\/]?([a-z]\S+?\.(?:png|jpg|gif))/
        rgx_rb_image=/([a-z][^ \/]+?\.(?:png|jpg|gif))/
        rgx_skin=/^\s+:skin:\s+(\S+)/
        skin_get=nil
        images=[]
        skin_get
        parse_file.each do |f|                                                  #% work area
          if f !~/^%+\s/
            skin_get ||= f.scan(rgx_skin).uniq.flatten if f =~rgx_skin
            if f =~rgx_image
              images << f.scan(rgx_image).uniq
            end
          end
        end
        skin=skin_get[0] if skin_get
        skin=locate_skin
        parse_skin=IO.readlines(skin,"\n")
        parse_skin.each do |f|                                                  #% work area
          if f !~/^#/ \
          and f =~rgx_rb_image
            images << f.scan(rgx_rb_image).uniq
          end
        end
        image_path="#{@env.path.pwd}/_sisu/image"
        images.flatten.each do |i|
          if FileTest.file?("#{image_path}/#{i}")
            FileUtils::cp_r("#{image_path}/#{i}",@git_path[:image])
          end
        end
        if FileTest.file?(skin)
          FileUtils::cp_r(skin,"#{@git_path[:conf]}/skin")
        end
        { skin: skin, images: images }
      end
      def sisuyaml_rc
        sisurc=@env.path.sisurc_path
        if FileTest.file?(sisurc)
          FileUtils::cp_r(sisurc,@git_path[:conf])
        end
      end
      def read_src
        print __FILE__ + ':'
        p __LINE__
      end
      def composite_src?
        @opt.fns=~/\.ssm$/ ? true : false
      end
      def sisusrc_files
        populate.copy_src_head
        if composite_src?
          populate.copy_related_sst_ssi
        end
        populate.extract_skin
        #parse_file_name=locate_parse_file
        #parse_file=IO.readlines(parse_file_name,'')
        populate.sisuyaml_rc #(parse_file)
        populate.extract_skin_and_images #(parse_file)
        #populate.extract_composite_source
        #populate.read_composite # or read_each_composite
        populate.identify_language_versions
      end
      self
    end
  end
end
__END__
@file.output_path.sisugit
