# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v3/dal_images.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_DAL_Images
  class Images
    #require 'RMagick'
    #include Magick
    def initialize(md,data)
      @md,@data=md,data
    end
    def images
      data=@data
      tuned_file=[]
      @rmgk=false
      imagemagick_=true      #imagemagick_=SiSU_Env::InfoSettings.new.program?('rmagick')
      if imagemagick_
        begin
          @rmgk=SiSU_Env::Load.new('RMagick').prog
        rescue
          @rmgk=false
        end
      else
        if @md.opt.cmd =~/[vVM]/
          SiSU_Screen::Ansi.new(@md.opt.cmd,'*WARN* use of RMagick is not enabled in sisurc.yml').warn
        end
      end
      data.each do |dob|
        unless dob.is ==:table
          dob.obj=dob.obj.strip
          if dob.obj =~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif)(?:\s*|\s+.+)?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/
            if dob.obj !~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif)\s+\d+x\d+/
              m=/#{Mx[:lnk_o]}\s*(\S+\.(?:png|jpg|gif))/
              if imagemagick_
                imgs=dob.obj.scan(m).flatten
                img_col=img_row=nil
                images=imgs.each do |image|
                  dir=SiSU_Env::InfoEnv.new(@md.fns)
                  path_image=[dir.path.image_source_include_local,dir.path.image_source_include_remote,dir.path.image_source_include]
                  image_path=nil
                  path_image.each do |img_pth|
                    image_path=img_pth
                    break if FileTest.exist?("#{img_pth}/#{image}")
                  end
                  if FileTest.exist?("#{image_path}/#{image}")
                    if @rmgk
                      img=Magick::ImageList.new("#{image_path}/#{image}")
                      img_col,img_row=img.columns,img.rows
                    else
                      if @md.opt.cmd =~/[vVM]/
                        SiSU_Screen::Ansi.new(@md.opt.cmd,'*WARN* RMagick not present, will attempt to use imagemagick (identify) directly').warn
                      end
                      imgk=SiSU_Env::SystemCall.new.imagemagick
                      gmgk=SiSU_Env::SystemCall.new.graphicksmagick
                      if imgk or gmgk
                        if imgk
                          imgsys=`identify #{image_path}/#{image}`.strip                           #system call
                        elsif gmgk
                          imgsys=`gm identify #{image_path}/#{image}`.strip                        #system call
                        end
                        img_col,img_row=/(\d+)x(\d+)/m.match(imgsys)[1,2]
                        img_col,img_row=img_col.to_i,img_row.to_i
                      end
                    end
                    row=((img && defined? img.rows) ? img.rows : img_row)
                    col=((img && defined? img.columns) ? img.columns : img_col)
                    if img_col > img_row                                                           #landscape
                      if img_col> 640
                        img_col=640
                        img_row=((1.00*img_col/col)*row).round
                      end
                    else                                                                           #portrait
                      if img_col> 640
                        img_col=640
                        img_row=((1.00*img_col/col)*row).round
                      end
                      if img_row > 640
                        img_row=640
                        img_col=((1.00*img_row/row)*col).round
                      end
                    end
                    dob.obj=dob.obj.gsub(/(#{image})/,"#{image} #{img_col}x#{img_row}")
                  else dob.obj=dob.obj.gsub(/#{Mx[:lnk_o]}\s*(\S+)\.(png|jpg|gif).+?#{Mx[:lnk_c]}(#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/,'[ \1 (\2 missing) ]')
                  end
                end
              else
                images=dob.obj.scan(m) do |image|
                  SiSU_Screen::Ansi.new(@md.opt.cmd,'*WARN* where image dimensions have not been provided RMagick or imagemagick is required',image).warn #unless @opt.cmd =~/q/
                end
              end
            end
          end
          if dob.obj =~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/
            dob.obj=dob.obj.gsub(/(#{Mx[:lnk_o]})\s*(\S+\.(?:png|jpg|gif))\s+/i,'\1\2 ')
          end
        end
        tuned_file << dob unless dob.nil?
      end
      tuned_file
    end
  end
end
__END__
imgsys=`identify #{image_path}/#{image}`.strip
